/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationQueueId {
    private final ServerName serverName;
    private final String peerId;
    private final Optional<ServerName> sourceServerName;
    private static final char PEER_ID_SEPARATOR = '-';
    private static final char SERVER_NAME_SEPARATOR = '/';

    public ReplicationQueueId(ServerName serverName, String peerId) {
        this.serverName = Objects.requireNonNull(serverName);
        this.peerId = Objects.requireNonNull(peerId);
        this.sourceServerName = Optional.empty();
    }

    public ReplicationQueueId(ServerName serverName, String peerId, ServerName sourceServerName) {
        this.serverName = Objects.requireNonNull(serverName);
        this.peerId = Objects.requireNonNull(peerId);
        this.sourceServerName = Optional.of(sourceServerName);
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public Optional<ServerName> getSourceServerName() {
        return this.sourceServerName;
    }

    public ServerName getServerWALsBelongTo() {
        return this.sourceServerName.orElse(this.serverName);
    }

    public boolean isRecovered() {
        return this.sourceServerName.isPresent();
    }

    public ReplicationQueueId claim(ServerName targetServerName) {
        ServerName newSourceServerName = this.sourceServerName.orElse(this.serverName);
        return new ReplicationQueueId(targetServerName, this.peerId, newSourceServerName);
    }

    public int hashCode() {
        return Objects.hash(this.peerId, this.serverName, this.sourceServerName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReplicationQueueId)) {
            return false;
        }
        ReplicationQueueId other = (ReplicationQueueId)obj;
        return Objects.equals(this.peerId, other.peerId) && Objects.equals(this.serverName, other.serverName) && Objects.equals(this.sourceServerName, other.sourceServerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.peerId).append('-').append(this.serverName);
        this.sourceServerName.ifPresent(s -> sb.append('/').append(s.toString()));
        return sb.toString();
    }

    public static ReplicationQueueId parse(String str) {
        int dashIndex = str.indexOf(45);
        String peerId = str.substring(0, dashIndex);
        int slashIndex = str.indexOf(47, dashIndex + 1);
        if (slashIndex < 0) {
            String serverName = str.substring(dashIndex + 1);
            return new ReplicationQueueId(ServerName.valueOf((String)serverName), peerId);
        }
        String serverName = str.substring(dashIndex + 1, slashIndex);
        String sourceServerName = str.substring(slashIndex + 1);
        return new ReplicationQueueId(ServerName.valueOf((String)serverName), peerId, ServerName.valueOf((String)sourceServerName));
    }

    public static String getPeerId(String str) {
        int dashIndex = str.indexOf(45);
        return str.substring(0, dashIndex);
    }

    public static byte[] getScanPrefix(ServerName serverName, String peerId) {
        return Bytes.toBytes((String)(peerId + '-' + serverName.toString()));
    }

    public static byte[] getScanPrefix(String peerId) {
        return Bytes.toBytes((String)(peerId + '-'));
    }

    private static char getNextChar(char c) {
        return (char)(c + '\u0001');
    }

    public static byte[] getScanStartRowForNextPeerId(String peerId) {
        return Bytes.toBytes((String)(peerId + ReplicationQueueId.getNextChar('-')));
    }
}

