/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.NoopProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureSuspended {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureSuspended.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureSuspended.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static final Procedure NULL_PROC = null;
    private ProcedureExecutor<TestProcEnv> procExecutor;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtil htu;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtil();
        this.procStore = new NoopProcedureStore();
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)new TestProcEnv(), this.procStore);
        this.procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(this.procExecutor, 1, true);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
    }

    @Test
    public void testSuspendWhileHoldingLocks() {
        AtomicBoolean lockA = new AtomicBoolean(false);
        AtomicBoolean lockB = new AtomicBoolean(false);
        TestLockProcedure p1keyA = new TestLockProcedure(lockA, "keyA", false, true);
        TestLockProcedure p2keyA = new TestLockProcedure(lockA, "keyA", false, true);
        TestLockProcedure p3keyB = new TestLockProcedure(lockB, "keyB", false, true);
        this.procExecutor.submitProcedure((Procedure)p1keyA);
        this.procExecutor.submitProcedure((Procedure)p2keyA);
        this.procExecutor.submitProcedure((Procedure)p3keyB);
        this.waitAndAssertTimestamp(p1keyA, 1, 1);
        this.waitAndAssertTimestamp(p2keyA, 0, -1);
        this.waitAndAssertTimestamp(p3keyB, 1, 2);
        Assert.assertEquals((Object)true, (Object)lockA.get());
        Assert.assertEquals((Object)true, (Object)lockB.get());
        p3keyB.setThrowSuspend(false);
        this.procExecutor.getScheduler().addFront((Procedure)p3keyB);
        this.waitAndAssertTimestamp(p1keyA, 1, 1);
        this.waitAndAssertTimestamp(p2keyA, 0, -1);
        this.waitAndAssertTimestamp(p3keyB, 2, 3);
        Assert.assertEquals((Object)true, (Object)lockA.get());
        ProcedureTestingUtility.waitProcedure(this.procExecutor, p3keyB);
        Assert.assertEquals((Object)false, (Object)lockB.get());
        p1keyA.setTriggerRollback(true);
        this.procExecutor.getScheduler().addFront((Procedure)p1keyA);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, p1keyA);
        this.waitAndAssertTimestamp(p1keyA, 4, 60000);
        this.waitAndAssertTimestamp(p2keyA, 1, 7);
        this.waitAndAssertTimestamp(p3keyB, 2, 3);
        Assert.assertEquals((Object)true, (Object)lockA.get());
        p2keyA.setThrowSuspend(false);
        this.procExecutor.getScheduler().addFront((Procedure)p2keyA);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, p2keyA);
        this.waitAndAssertTimestamp(p1keyA, 4, 60000);
        this.waitAndAssertTimestamp(p2keyA, 2, 8);
        this.waitAndAssertTimestamp(p3keyB, 2, 3);
        Assert.assertEquals((Object)false, (Object)lockA.get());
        Assert.assertEquals((Object)false, (Object)lockB.get());
    }

    @Test
    public void testYieldWhileHoldingLocks() {
        AtomicBoolean lock = new AtomicBoolean(false);
        TestLockProcedure p1 = new TestLockProcedure(lock, "key", true, false);
        TestLockProcedure p2 = new TestLockProcedure(lock, "key", true, false);
        this.procExecutor.submitProcedure((Procedure)p1);
        this.procExecutor.submitProcedure((Procedure)p2);
        while (p1.getTimestamps().size() < 100) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)0L, (long)p2.getTimestamps().size());
        p1.setThrowYield(false);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, p1);
        while (p2.getTimestamps().size() < 100) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)(p1.getTimestamps().get(p1.getTimestamps().size() - 1) + 1L), (long)p2.getTimestamps().get(0));
        p1.setThrowYield(false);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, p1);
    }

    private void waitAndAssertTimestamp(TestLockProcedure proc, int size, int lastTs) {
        ArrayList<Long> timestamps = proc.getTimestamps();
        while (timestamps.size() < size) {
            Threads.sleep((long)10L);
        }
        LOG.info((Object)((Object)proc) + " -> " + timestamps);
        Assert.assertEquals((long)size, (long)timestamps.size());
        if (size > 0) {
            Assert.assertEquals((long)lastTs, (long)timestamps.get(timestamps.size() - 1));
        }
    }

    private static class TestProcEnv {
        public final AtomicLong timestamp = new AtomicLong(0L);

        private TestProcEnv() {
        }

        public long nextTimestamp() {
            return this.timestamp.incrementAndGet();
        }
    }

    public static class TestLockProcedure
    extends Procedure<TestProcEnv> {
        private final ArrayList<Long> timestamps = new ArrayList();
        private final String key;
        private boolean triggerRollback = false;
        private boolean throwSuspend = false;
        private boolean throwYield = false;
        private AtomicBoolean lock = null;
        private boolean hasLock = false;

        public TestLockProcedure(AtomicBoolean lock, String key, boolean throwYield, boolean throwSuspend) {
            this.lock = lock;
            this.key = key;
            this.throwYield = throwYield;
            this.throwSuspend = throwSuspend;
        }

        public void setThrowYield(boolean throwYield) {
            this.throwYield = throwYield;
        }

        public void setThrowSuspend(boolean throwSuspend) {
            this.throwSuspend = throwSuspend;
        }

        public void setTriggerRollback(boolean triggerRollback) {
            this.triggerRollback = triggerRollback;
        }

        protected Procedure[] execute(TestProcEnv env) throws ProcedureYieldException, ProcedureSuspendedException {
            LOG.info("EXECUTE " + (Object)((Object)this) + " suspend " + (this.lock != null));
            this.timestamps.add(env.nextTimestamp());
            if (this.triggerRollback) {
                this.setFailure(((Object)((Object)this)).getClass().getSimpleName(), new Exception("injected failure"));
            } else {
                if (this.throwYield) {
                    throw new ProcedureYieldException();
                }
                if (this.throwSuspend) {
                    throw new ProcedureSuspendedException();
                }
            }
            return null;
        }

        protected void rollback(TestProcEnv env) {
            LOG.info("ROLLBACK " + (Object)((Object)this));
            this.timestamps.add(env.nextTimestamp() * 10000L);
        }

        protected Procedure.LockState acquireLock(TestProcEnv env) {
            this.hasLock = this.lock.compareAndSet(false, true);
            if (this.hasLock) {
                LOG.info("ACQUIRE LOCK " + (Object)((Object)this) + " " + this.hasLock);
                return Procedure.LockState.LOCK_ACQUIRED;
            }
            return Procedure.LockState.LOCK_YIELD_WAIT;
        }

        protected void releaseLock(TestProcEnv env) {
            LOG.info("RELEASE LOCK " + (Object)((Object)this) + " " + this.hasLock);
            this.lock.set(false);
        }

        protected boolean holdLock(TestProcEnv env) {
            return true;
        }

        public ArrayList<Long> getTimestamps() {
            return this.timestamps;
        }

        protected void toStringClassDetails(StringBuilder builder) {
            builder.append(((Object)((Object)this)).getClass().getName());
            builder.append("(" + this.key + ")");
        }

        protected boolean abort(TestProcEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }
}

