/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRemoteProcedureDispatcherUncaughtExceptionHandler {
    private static HBaseCommonTestingUtil UTIL = new HBaseCommonTestingUtil();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRemoteProcedureDispatcherUncaughtExceptionHandler.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ExceptionHandler handler;
    private Dispatcher dispatcher;

    @Before
    public void setUp() {
        this.handler = new ExceptionHandler();
        this.dispatcher = new Dispatcher(this.handler);
        this.dispatcher.start();
    }

    @After
    public void tearDown() {
        this.dispatcher.stop();
        this.dispatcher = null;
        this.handler = null;
    }

    @Test
    public void testSubmit() throws Throwable {
        final String message = "inject error";
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage(message);
        this.dispatcher.submitTask(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException(message);
            }
        });
        this.handler.get();
    }

    @Test
    public void testDelayedSubmit() throws Throwable {
        final String message = "inject error";
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage(message);
        this.dispatcher.submitTask(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException(message);
            }
        }, 100L, TimeUnit.MILLISECONDS);
        this.handler.get();
    }

    private static final class Dispatcher
    extends RemoteProcedureDispatcher<Void, Integer> {
        private final Thread.UncaughtExceptionHandler handler;

        public Dispatcher(Thread.UncaughtExceptionHandler handler) {
            super(UTIL.getConfiguration());
            this.handler = handler;
        }

        protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
            return this.handler;
        }

        protected void remoteDispatch(Integer key, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
        }

        protected void abortPendingOperations(Integer key, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
        }
    }

    private static final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Throwable error;

        private ExceptionHandler() {
        }

        @Override
        public synchronized void uncaughtException(Thread t, Throwable e) {
            this.error = e;
            this.notifyAll();
        }

        public synchronized void get() throws Throwable {
            while (this.error == null) {
                this.wait();
            }
            throw this.error;
        }
    }
}

