/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.LeaseRecovery;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStorePerformanceEvaluation;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;

public class ProcedureWALPerformanceEvaluation
extends ProcedureStorePerformanceEvaluation<WALProcedureStore> {
    public static int DEFAULT_NUM_WALS = 0;
    public static Option NUM_WALS_OPTION = new Option("wals", true, "Number of WALs to write. If -ve or 0, uses hbase.procedure.store.wal.roll.threshold conf to roll the logs. Default: " + DEFAULT_NUM_WALS);
    private long numProcsPerWal = Long.MAX_VALUE;
    private int numWals;

    private void setupConf() {
        this.conf.setBoolean("hbase.procedure.store.wal.use.hsync", "hsync".equals(this.syncType));
        if (this.numWals > 0) {
            this.conf.setLong("hbase.procedure.store.wal.roll.threshold", Long.MAX_VALUE);
            this.numProcsPerWal = this.numProcs / (long)this.numWals;
        }
    }

    @Override
    public void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        this.numWals = this.getOptionAsInt(cmd, NUM_WALS_OPTION.getOpt(), DEFAULT_NUM_WALS);
        this.setupConf();
    }

    @Override
    public void addOptions() {
        super.addOptions();
        this.addOption(NUM_WALS_OPTION);
    }

    @Override
    protected WALProcedureStore createProcedureStore(Path storeDir) throws IOException {
        if ("nosync".equals(this.syncType)) {
            return new NoSyncWalProcedureStore(this.conf, storeDir);
        }
        return ProcedureTestingUtility.createWalStore(this.conf, storeDir);
    }

    @Override
    protected void printRawFormatResult(long timeTakenNs) {
        System.out.println(String.format("RESULT [%s=%s, %s=%s, %s=%s, %s=%s, %s=%s, total_time_ms=%s]", NUM_PROCS_OPTION.getOpt(), this.numProcs, STATE_SIZE_OPTION.getOpt(), this.stateSize, SYNC_OPTION.getOpt(), this.syncType, NUM_THREADS_OPTION.getOpt(), this.numThreads, NUM_WALS_OPTION.getOpt(), this.numWals, timeTakenNs));
    }

    @Override
    protected void preWrite(long procId) throws IOException {
        if (procId > 0L && procId % this.numProcsPerWal == 0L) {
            ((WALProcedureStore)this.store).rollWriterForTesting();
            System.out.println("Starting new log : " + ((WALProcedureStore)this.store).getActiveLogs().get(((WALProcedureStore)this.store).getActiveLogs().size() - 1));
        }
    }

    public static void main(String[] args) throws IOException {
        ProcedureWALPerformanceEvaluation tool = new ProcedureWALPerformanceEvaluation();
        tool.setConf(HBaseConfiguration.create());
        tool.run(args);
    }

    private static class NoSyncWalProcedureStore
    extends WALProcedureStore {
        public NoSyncWalProcedureStore(Configuration conf, Path logDir) throws IOException {
            super(conf, logDir, null, new LeaseRecovery(){

                public void recoverFileLease(FileSystem fs, Path path) throws IOException {
                }
            });
        }

        protected void syncStream(FSDataOutputStream stream) {
        }
    }
}

