/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.LeaseRecovery;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFile;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.io.IOUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.Int64Value;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestWALProcedureStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALProcedureStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALProcedureStore.class);
    private static final int PROCEDURE_STORE_SLOTS = 1;
    private WALProcedureStore procStore;
    private final HBaseCommonTestingUtil htu = new HBaseCommonTestingUtil();
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    private void setupConfig(Configuration conf) {
        conf.setBoolean("hbase.procedure.store.wal.exec.cleanup.on.load", true);
    }

    @Before
    public void setUp() throws IOException {
        this.testDir = this.htu.getDataTestDir();
        this.htu.getConfiguration().set("hbase.rootdir", this.testDir.toString());
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        this.htu.getConfiguration().set("hbase.rootdir", this.testDir.toString());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        TestSequentialProcedure.seqId.set(0L);
        this.setupConfig(this.htu.getConfiguration());
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.logDir);
        this.procStore.start(1);
        this.procStore.recoverLease();
        this.procStore.load((ProcedureStore.ProcedureLoader)new ProcedureTestingUtility.LoadCounter());
    }

    @After
    public void tearDown() throws IOException {
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    private void storeRestart(ProcedureStore.ProcedureLoader loader) throws Exception {
        ProcedureTestingUtility.storeRestart((ProcedureStore)this.procStore, loader);
    }

    @Test
    public void testEmptyRoll() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.procStore.periodicRollForTesting();
        }
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
        FileStatus[] status = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)status.length);
    }

    @Test
    public void testRestartWithoutData() throws Exception {
        for (int i = 0; i < 10; ++i) {
            ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
            this.storeRestart(loader);
        }
        LOG.info("ACTIVE WALs " + this.procStore.getActiveLogs());
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
        FileStatus[] status = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)status.length);
    }

    @Test
    public void trackersLoadedForAllOldLogs() throws Exception {
        int i;
        for (i = 0; i <= 20; ++i) {
            this.procStore.insert((Procedure)new ProcedureTestingUtility.TestProcedure(i), null);
            if (i <= 0 || i % 5 != 0) continue;
            ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
            this.storeRestart(loader);
        }
        Assert.assertEquals((long)5L, (long)this.procStore.getActiveLogs().size());
        for (i = 0; i < this.procStore.getActiveLogs().size() - 1; ++i) {
            ProcedureStoreTracker tracker = ((ProcedureWALFile)this.procStore.getActiveLogs().get(i)).getTracker();
            Assert.assertTrue((tracker != null && !tracker.isEmpty() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWalCleanerSequentialClean() throws Exception {
        Procedure[] procs = new Procedure[5];
        ArrayList logs = null;
        for (int i = 0; i < procs.length; ++i) {
            procs[i] = new TestSequentialProcedure();
            this.procStore.insert(procs[i], null);
            this.procStore.rollWriterForTesting();
            logs = this.procStore.getActiveLogs();
            Assert.assertEquals((long)logs.size(), (long)(i + 2));
        }
        int[] deleteOrder = new int[]{0, 1, 2, 3, 4};
        for (int i = 0; i < deleteOrder.length; ++i) {
            this.procStore.delete(procs[deleteOrder[i]].getProcId());
            this.procStore.removeInactiveLogsForTesting();
            Assert.assertFalse((String)((ProcedureWALFile)logs.get(deleteOrder[i])).toString(), (boolean)this.procStore.getActiveLogs().contains(logs.get(deleteOrder[i])));
            Assert.assertEquals((long)this.procStore.getActiveLogs().size(), (long)(procs.length - i));
        }
    }

    @Test
    public void testWalCleanerNoHoles() throws Exception {
        int i;
        Procedure[] procs = new Procedure[5];
        ArrayList logs = null;
        for (i = 0; i < procs.length; ++i) {
            procs[i] = new TestSequentialProcedure();
            this.procStore.insert(procs[i], null);
            this.procStore.rollWriterForTesting();
            logs = this.procStore.getActiveLogs();
            Assert.assertEquals((long)(i + 2), (long)logs.size());
        }
        for (i = 1; i < procs.length; ++i) {
            this.procStore.delete(procs[i].getProcId());
        }
        Assert.assertEquals((long)(procs.length + 1), (long)this.procStore.getActiveLogs().size());
        this.procStore.delete(procs[0].getProcId());
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
    }

    @Test
    public void testWalCleanerUpdates() throws Exception {
        TestSequentialProcedure p1 = new TestSequentialProcedure();
        TestSequentialProcedure p2 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)p1, null);
        this.procStore.insert((Procedure)p2, null);
        this.procStore.rollWriterForTesting();
        ProcedureWALFile firstLog = (ProcedureWALFile)this.procStore.getActiveLogs().get(0);
        this.procStore.update((Procedure)p1);
        this.procStore.rollWriterForTesting();
        this.procStore.update((Procedure)p2);
        this.procStore.rollWriterForTesting();
        this.procStore.removeInactiveLogsForTesting();
        Assert.assertFalse((boolean)this.procStore.getActiveLogs().contains(firstLog));
    }

    @Test
    public void testWalCleanerUpdatesDontLeaveHoles() throws Exception {
        TestSequentialProcedure p1 = new TestSequentialProcedure();
        TestSequentialProcedure p2 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)p1, null);
        this.procStore.insert((Procedure)p2, null);
        this.procStore.rollWriterForTesting();
        ProcedureWALFile log1 = (ProcedureWALFile)this.procStore.getActiveLogs().get(0);
        this.procStore.update((Procedure)p2);
        this.procStore.rollWriterForTesting();
        ProcedureWALFile log2 = (ProcedureWALFile)this.procStore.getActiveLogs().get(1);
        this.procStore.update((Procedure)p2);
        this.procStore.rollWriterForTesting();
        this.procStore.removeInactiveLogsForTesting();
        Assert.assertEquals((long)4L, (long)this.procStore.getActiveLogs().size());
        this.procStore.update((Procedure)p1);
        this.procStore.rollWriterForTesting();
        this.procStore.removeInactiveLogsForTesting();
        Assert.assertEquals((long)3L, (long)this.procStore.getActiveLogs().size());
        Assert.assertFalse((boolean)this.procStore.getActiveLogs().contains(log1));
        Assert.assertFalse((boolean)this.procStore.getActiveLogs().contains(log2));
    }

    @Test
    public void testWalCleanerWithEmptyRolls() throws Exception {
        int i;
        Procedure[] procs = new Procedure[3];
        for (i = 0; i < procs.length; ++i) {
            procs[i] = new TestSequentialProcedure();
            this.procStore.insert(procs[i], null);
        }
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
        this.procStore.rollWriterForTesting();
        Assert.assertEquals((long)2L, (long)this.procStore.getActiveLogs().size());
        this.procStore.rollWriterForTesting();
        Assert.assertEquals((long)3L, (long)this.procStore.getActiveLogs().size());
        for (i = 0; i < procs.length; ++i) {
            this.procStore.update(procs[i]);
            this.procStore.rollWriterForTesting();
            this.procStore.rollWriterForTesting();
            if (i >= procs.length - 1) continue;
            Assert.assertEquals((long)(3 + (i + 1) * 2), (long)this.procStore.getActiveLogs().size());
        }
        Assert.assertEquals((long)7L, (long)this.procStore.getActiveLogs().size());
        for (i = 0; i < procs.length; ++i) {
            this.procStore.delete(procs[i].getProcId());
            Assert.assertEquals((long)(7 - (i + 1) * 2), (long)this.procStore.getActiveLogs().size());
        }
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
    }

    @Test
    public void testEmptyLogLoad() throws Exception {
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)0L, (long)loader.getMaxProcId());
        Assert.assertEquals((long)0L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testLoad() throws Exception {
        HashSet<Long> procIds = new HashSet<Long>();
        TestSequentialProcedure proc1 = new TestSequentialProcedure();
        procIds.add(proc1.getProcId());
        this.procStore.insert((Procedure)proc1, null);
        TestSequentialProcedure proc2 = new TestSequentialProcedure();
        Procedure[] child2 = new Procedure[]{new TestSequentialProcedure(), new TestSequentialProcedure()};
        procIds.add(proc2.getProcId());
        procIds.add(child2[0].getProcId());
        procIds.add(child2[1].getProcId());
        this.procStore.insert((Procedure)proc2, child2);
        this.verifyProcIdsOnRestart(procIds);
        this.procStore.update((Procedure)proc1);
        this.procStore.update(child2[1]);
        this.procStore.delete(child2[1].getProcId());
        procIds.remove(child2[1].getProcId());
        this.verifyProcIdsOnRestart(procIds);
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)3L, (long)logs.length);
        for (int i = 0; i < logs.length; ++i) {
            this.corruptLog(logs[i], 4L);
        }
        this.verifyProcIdsOnRestart(procIds);
    }

    @Test
    public void testNoTrailerDoubleRestart() throws Exception {
        TestSequentialProcedure proc0 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc0, null);
        TestSequentialProcedure proc1 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc1, null);
        TestSequentialProcedure proc2 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc2, null);
        this.procStore.rollWriterForTesting();
        this.procStore.delete(proc1.getProcId());
        this.procStore.rollWriterForTesting();
        this.procStore.update((Procedure)proc2);
        this.procStore.rollWriterForTesting();
        this.procStore.delete(proc2.getProcId());
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)4L, (long)logs.length);
        for (int i = 0; i < logs.length; ++i) {
            this.corruptLog(logs[i], 4L);
        }
        this.htu.getConfiguration().setBoolean("hbase.procedure.store.wal.exec.cleanup.on.load", false);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)1L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
        Assert.assertEquals((long)5L, (long)this.fs.listStatus(this.logDir).length);
        loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)1L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
        this.procStore.delete(proc0.getProcId());
        this.procStore.periodicRollForTesting();
        Assert.assertEquals((long)1L, (long)this.fs.listStatus(this.logDir).length);
        this.storeRestart(loader);
    }

    @Test
    public void testProcIdHoles() throws Exception {
        int i;
        for (i = 0; i < 100; i += 2) {
            this.procStore.insert((Procedure)new ProcedureTestingUtility.TestProcedure(i), null);
            if (i <= 0 || i % 10 != 0) continue;
            ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
            this.storeRestart(loader);
            Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
            Assert.assertEquals((long)(i / 2 + 1), (long)loader.getLoadedCount());
        }
        Assert.assertEquals((long)10L, (long)this.procStore.getActiveLogs().size());
        for (i = 0; i < 100; i += 2) {
            this.procStore.delete((long)i);
        }
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)0L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testCorruptedTrailer() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.procStore.insert((Procedure)new TestSequentialProcedure(), null);
        }
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)logs.length);
        this.corruptLog(logs[0], 4L);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)100L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    private static void assertUpdated(ProcedureStoreTracker tracker, Procedure<?>[] procs, int[] updatedProcs, int[] nonUpdatedProcs) {
        long procId;
        for (int index : updatedProcs) {
            procId = procs[index].getProcId();
            Assert.assertTrue((String)("Procedure id : " + procId), (boolean)tracker.isModified(procId));
        }
        for (int index : nonUpdatedProcs) {
            procId = procs[index].getProcId();
            Assert.assertFalse((String)("Procedure id : " + procId), (boolean)tracker.isModified(procId));
        }
    }

    private static void assertDeleted(ProcedureStoreTracker tracker, Procedure<?>[] procs, int[] deletedProcs, int[] nonDeletedProcs) {
        long procId;
        for (int index : deletedProcs) {
            procId = procs[index].getProcId();
            Assert.assertEquals((String)("Procedure id : " + procId), (Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted(procId));
        }
        for (int index : nonDeletedProcs) {
            procId = procs[index].getProcId();
            Assert.assertEquals((String)("Procedure id : " + procId), (Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted(procId));
        }
    }

    @Test
    public void testCorruptedTrailersRebuild() throws Exception {
        Procedure[] procs = new Procedure[6];
        for (int i = 0; i < procs.length; ++i) {
            procs[i] = new TestSequentialProcedure();
        }
        this.procStore.insert(procs[0], null);
        this.procStore.insert(procs[1], null);
        this.procStore.insert(procs[2], null);
        this.procStore.insert(procs[3], null);
        this.procStore.delete(procs[0].getProcId());
        this.procStore.rollWriterForTesting();
        this.procStore.delete(procs[2].getProcId());
        this.procStore.update(procs[3]);
        this.procStore.insert(procs[4], null);
        this.procStore.rollWriterForTesting();
        this.procStore.delete(procs[4].getProcId());
        this.procStore.insert(procs[5], null);
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)3L, (long)logs.length);
        for (int i = 0; i < logs.length; ++i) {
            this.corruptLog(logs[i], 4L);
        }
        this.htu.getConfiguration().setBoolean("hbase.procedure.store.wal.exec.cleanup.on.load", false);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)3L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
        ArrayList walFiles = this.procStore.getActiveLogs();
        LOG.info("WALs " + walFiles);
        Assert.assertEquals((long)4L, (long)walFiles.size());
        LOG.info("Checking wal " + walFiles.get(0));
        TestWALProcedureStore.assertUpdated(((ProcedureWALFile)walFiles.get(0)).getTracker(), procs, new int[]{0, 1, 2, 3}, new int[]{4, 5});
        LOG.info("Checking wal " + walFiles.get(1));
        TestWALProcedureStore.assertUpdated(((ProcedureWALFile)walFiles.get(1)).getTracker(), procs, new int[]{2, 3, 4}, new int[]{0, 1, 5});
        LOG.info("Checking wal " + walFiles.get(2));
        TestWALProcedureStore.assertUpdated(((ProcedureWALFile)walFiles.get(2)).getTracker(), procs, new int[]{4, 5}, new int[]{0, 1, 2, 3});
        LOG.info("Checking global tracker ");
        TestWALProcedureStore.assertDeleted(this.procStore.getStoreTracker(), procs, new int[]{0, 2, 4}, new int[]{1, 3, 5});
    }

    @Test
    public void testCorruptedEntries() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.procStore.insert((Procedure)new TestSequentialProcedure(), null);
        }
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)logs.length);
        this.corruptLog(logs[0], 1823L);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertTrue((this.procStore.getCorruptedLogs() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.procStore.getCorruptedLogs().size());
        Assert.assertEquals((long)87L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testCorruptedProcedures() throws Exception {
        int i;
        ProcedureTestingUtility.TestProcedure[] rootProcs = new ProcedureTestingUtility.TestProcedure[10];
        for (i = 1; i <= rootProcs.length; ++i) {
            rootProcs[i - 1] = new ProcedureTestingUtility.TestProcedure(i, 0L);
            this.procStore.insert((Procedure)rootProcs[i - 1], null);
            rootProcs[i - 1].addStackId(0);
            this.procStore.update((Procedure)rootProcs[i - 1]);
        }
        this.procStore.rollWriterForTesting();
        for (i = 1; i <= rootProcs.length; ++i) {
            ProcedureTestingUtility.TestProcedure b = new ProcedureTestingUtility.TestProcedure(rootProcs.length + i, i);
            rootProcs[i - 1].addStackId(1);
            this.procStore.insert((Procedure)rootProcs[i - 1], new Procedure[]{b});
        }
        this.procStore.rollWriterForTesting();
        for (i = 1; i <= rootProcs.length; ++i) {
            this.procStore.update((Procedure)new ProcedureTestingUtility.TestProcedure(rootProcs.length + i, i));
        }
        this.procStore.stop(false);
        Object[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((String)Arrays.toString(logs), (long)2L, (long)logs.length);
        Arrays.sort(logs, new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus o1, FileStatus o2) {
                return o1.getPath().getName().compareTo(o2.getPath().getName());
            }
        });
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)(rootProcs.length * 2), (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
        this.fs.delete(logs[0].getPath(), false);
        loader.reset();
        this.storeRestart(loader);
        Assert.assertEquals((long)0L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)rootProcs.length, (long)loader.getCorruptedCount());
        for (Procedure proc : loader.getCorrupted()) {
            Assert.assertTrue((String)proc.toString(), (proc.getParentProcId() <= (long)rootProcs.length ? 1 : 0) != 0);
            Assert.assertTrue((String)proc.toString(), (proc.getProcId() > (long)rootProcs.length && proc.getProcId() <= (long)(rootProcs.length * 2) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRollAndRemove() throws IOException {
        TestSequentialProcedure proc1 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc1, null);
        TestSequentialProcedure proc2 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc2, null);
        this.procStore.rollWriterForTesting();
        Assert.assertEquals((long)2L, (long)this.procStore.getActiveLogs().size());
        this.procStore.update((Procedure)proc1);
        this.procStore.update((Procedure)proc2);
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
        this.procStore.rollWriterForTesting();
        Assert.assertEquals((long)2L, (long)this.procStore.getActiveLogs().size());
        this.procStore.delete(proc1.getProcId());
        this.procStore.delete(proc2.getProcId());
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
    }

    @Test
    public void testFileNotFoundDuringLeaseRecovery() throws IOException {
        int i;
        ProcedureTestingUtility.TestProcedure[] procs = new ProcedureTestingUtility.TestProcedure[3];
        for (i = 0; i < procs.length; ++i) {
            procs[i] = new ProcedureTestingUtility.TestProcedure(i + 1, 0L);
            this.procStore.insert((Procedure)procs[i], null);
        }
        this.procStore.rollWriterForTesting();
        for (i = 0; i < procs.length; ++i) {
            this.procStore.update((Procedure)procs[i]);
            this.procStore.rollWriterForTesting();
        }
        this.procStore.stop(false);
        FileStatus[] status = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)(procs.length + 1), (long)status.length);
        this.procStore = new WALProcedureStore(this.htu.getConfiguration(), this.logDir, null, new LeaseRecovery(){
            private int count = 0;

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
                if (++this.count <= 2) {
                    fs.delete(path, false);
                    LOG.debug("Simulate FileNotFound at count=" + this.count + " for " + path);
                    throw new FileNotFoundException("test file not found " + path);
                }
                LOG.debug("Simulate recoverFileLease() at count=" + this.count + " for " + path);
            }
        });
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.procStore.start(1);
        this.procStore.recoverLease();
        this.procStore.load((ProcedureStore.ProcedureLoader)loader);
        Assert.assertEquals((long)procs.length, (long)loader.getMaxProcId());
        Assert.assertEquals((long)1L, (long)loader.getRunnableCount());
        Assert.assertEquals((long)0L, (long)loader.getCompletedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testLogFileAlreadyExists() throws IOException {
        final boolean[] tested = new boolean[]{false};
        final WALProcedureStore mStore = (WALProcedureStore)Mockito.spy((Object)this.procStore);
        Answer<Boolean> ans = new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                long logId = (Long)invocationOnMock.getArgument(0);
                switch ((int)logId) {
                    case 2: {
                        Path logFilePath = mStore.getLogFilePath(logId);
                        mStore.getFileSystem().create(logFilePath);
                        break;
                    }
                    case 3: {
                        tested[0] = true;
                    }
                }
                return (Boolean)invocationOnMock.callRealMethod();
            }
        };
        ((WALProcedureStore)Mockito.doAnswer((Answer)ans).when((Object)mStore)).rollWriter(2L);
        ((WALProcedureStore)Mockito.doAnswer((Answer)ans).when((Object)mStore)).rollWriter(3L);
        mStore.recoverLease();
        Assert.assertTrue((boolean)tested[0]);
    }

    @Test
    public void testLoadChildren() throws Exception {
        ProcedureTestingUtility.TestProcedure a = new ProcedureTestingUtility.TestProcedure(1L, 0L);
        ProcedureTestingUtility.TestProcedure b = new ProcedureTestingUtility.TestProcedure(2L, 1L);
        ProcedureTestingUtility.TestProcedure c = new ProcedureTestingUtility.TestProcedure(3L, 1L);
        this.procStore.insert((Procedure)a, null);
        a.addStackId(0);
        this.procStore.update((Procedure)a);
        a.addStackId(1);
        this.procStore.insert((Procedure)a, new Procedure[]{b, c});
        b.addStackId(2);
        this.procStore.update((Procedure)b);
        c.addStackId(3);
        this.procStore.update((Procedure)c);
        b.addStackId(4);
        this.procStore.update((Procedure)b);
        a.addStackId(5);
        a.setSuccessState();
        this.procStore.delete((Procedure)a, new long[]{b.getProcId(), c.getProcId()});
        this.restartAndAssert(3L, 0L, 1, 0);
    }

    @Test
    public void testBatchDelete() throws Exception {
        int i;
        for (int i2 = 1; i2 < 10; ++i2) {
            this.procStore.insert((Procedure)new ProcedureTestingUtility.TestProcedure(i2), null);
        }
        long[] toDelete = new long[]{1L, 2L, 3L, 4L};
        this.procStore.delete(toDelete, 2, 0);
        ProcedureTestingUtility.LoadCounter loader = this.restartAndAssert(9L, 9L, 0, 0);
        for (i = 1; i < 10; ++i) {
            Assert.assertEquals((Object)true, (Object)loader.isRunnable(i));
        }
        toDelete = new long[]{2L, 4L, 6L, 8L};
        this.procStore.delete(toDelete, 0, toDelete.length);
        loader = this.restartAndAssert(9L, 5L, 0, 0);
        for (i = 1; i < 10; ++i) {
            Assert.assertEquals((Object)(i % 2 != 0 ? 1 : 0), (Object)loader.isRunnable(i));
        }
        toDelete = new long[]{5L, 7L, 1L, 3L, 9L};
        this.procStore.delete(toDelete, 2, 2);
        loader = this.restartAndAssert(9L, 3L, 0, 0);
        for (i = 1; i < 10; ++i) {
            Assert.assertEquals((Object)(i > 3 && i % 2 != 0 ? 1 : 0), (Object)loader.isRunnable(i));
        }
        toDelete = new long[]{5L};
        this.procStore.delete(toDelete, 0, 1);
        loader = this.restartAndAssert(9L, 2L, 0, 0);
        for (i = 1; i < 10; ++i) {
            Assert.assertEquals((Object)(i > 5 && i % 2 != 0 ? 1 : 0), (Object)loader.isRunnable(i));
        }
        toDelete = new long[]{0L, 7L, 9L};
        this.procStore.delete(toDelete, 1, 2);
        loader = this.restartAndAssert(0L, 0L, 0, 0);
        for (i = 1; i < 10; ++i) {
            Assert.assertEquals((Object)false, (Object)loader.isRunnable(i));
        }
    }

    @Test
    public void testBatchInsert() throws Exception {
        int i;
        int count = 10;
        Procedure[] procs = new ProcedureTestingUtility.TestProcedure[10];
        for (i = 0; i < procs.length; ++i) {
            procs[i] = new ProcedureTestingUtility.TestProcedure(i + 1);
        }
        this.procStore.insert(procs);
        this.restartAndAssert(10L, 10L, 0, 0);
        for (i = 0; i < procs.length; ++i) {
            long procId = procs[i].getProcId();
            this.procStore.delete(procId);
            this.restartAndAssert(procId != 10L ? 10L : 0L, 10 - (i + 1), 0, 0);
        }
        this.procStore.removeInactiveLogsForTesting();
        Assert.assertEquals((String)("WALs=" + this.procStore.getActiveLogs()), (long)1L, (long)this.procStore.getActiveLogs().size());
    }

    @Test
    public void testWALDirAndWALArchiveDir() throws IOException {
        Configuration conf = this.htu.getConfiguration();
        this.procStore = this.createWALProcedureStore(conf);
        Assert.assertEquals((Object)this.procStore.getFileSystem(), (Object)this.procStore.getWalArchiveDir().getFileSystem(conf));
    }

    private WALProcedureStore createWALProcedureStore(Configuration conf) throws IOException {
        return new WALProcedureStore(conf, new LeaseRecovery(){

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
            }
        });
    }

    private ProcedureTestingUtility.LoadCounter restartAndAssert(long maxProcId, long runnableCount, int completedCount, int corruptedCount) throws Exception {
        return ProcedureTestingUtility.storeRestartAndAssert((ProcedureStore)this.procStore, maxProcId, runnableCount, completedCount, corruptedCount);
    }

    private void corruptLog(FileStatus logFile, long dropBytes) throws IOException {
        Assert.assertTrue((logFile.getLen() > dropBytes ? 1 : 0) != 0);
        LOG.debug("corrupt log " + logFile.getPath() + " size=" + logFile.getLen() + " drop=" + dropBytes);
        Path tmpPath = new Path(this.testDir, "corrupted.log");
        FSDataInputStream in = this.fs.open(logFile.getPath());
        FSDataOutputStream out = this.fs.create(tmpPath);
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (long)(logFile.getLen() - dropBytes), (boolean)true);
        if (!this.fs.rename(tmpPath, logFile.getPath())) {
            throw new IOException("Unable to rename");
        }
    }

    private void verifyProcIdsOnRestart(Set<Long> procIds) throws Exception {
        LOG.debug("expected: " + procIds);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)procIds.size(), (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    public static class TestSequentialProcedure
    extends SequentialProcedure<Void> {
        private static final AtomicLong seqId = new AtomicLong(0L);

        public TestSequentialProcedure() {
            this.setProcId(seqId.incrementAndGet());
        }

        protected Procedure<Void>[] execute(Void env) {
            return null;
        }

        protected void rollback(Void env) {
        }

        protected boolean abort(Void env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
            long procId = this.getProcId();
            if (procId % 2L == 0L) {
                Int64Value.Builder builder = Int64Value.newBuilder().setValue(procId);
                serializer.serialize((Message)builder.build());
            }
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
            long procId = this.getProcId();
            if (procId % 2L == 0L) {
                Int64Value value = (Int64Value)serializer.deserialize(Int64Value.class);
                Assert.assertEquals((long)procId, (long)value.getValue());
            }
        }
    }
}

