/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.util.Apps;

@InterfaceAudience.LimitedPrivate(value={"yarn", "mapreduce"})
public class AggregatedLogDeletionService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AggregatedLogDeletionService.class);
    private Timer timer = null;
    private long checkIntervalMsecs;
    private LogDeletionTask task;

    private static void logException(String comment, Throwable t) {
        if (t instanceof AccessControlException) {
            String message = t.getMessage();
            message = message.split("\n")[0];
            LOG.warn((Object)(comment + " " + message));
        } else {
            LOG.error((Object)comment, t);
        }
    }

    public AggregatedLogDeletionService() {
        super(AggregatedLogDeletionService.class.getName());
    }

    protected void serviceStart() throws Exception {
        this.scheduleLogDeletionTask();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopRMClient();
        this.stopTimer();
        super.serviceStop();
    }

    private void setLogAggCheckIntervalMsecs(long retentionSecs) {
        Configuration conf = this.getConfig();
        this.checkIntervalMsecs = 1000L * conf.getLong("yarn.log-aggregation.retain-check-interval-seconds", -1L);
        if (this.checkIntervalMsecs <= 0L) {
            this.checkIntervalMsecs = retentionSecs * 1000L / 10L;
        }
    }

    public void refreshLogRetentionSettings() throws IOException {
        if (this.getServiceState() == Service.STATE.STARTED) {
            Configuration conf = this.createConf();
            this.setConfig(conf);
            this.stopRMClient();
            this.stopTimer();
            this.scheduleLogDeletionTask();
        } else {
            LOG.warn((Object)"Failed to execute refreshLogRetentionSettings : Aggregated Log Deletion Service is not started");
        }
    }

    private void scheduleLogDeletionTask() throws IOException {
        Configuration conf = this.getConfig();
        if (!conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return;
        }
        long retentionSecs = conf.getLong("yarn.log-aggregation.retain-seconds", -1L);
        if (retentionSecs < 0L) {
            LOG.info((Object)("Log Aggregation deletion is disabled because retention is too small (" + retentionSecs + ")"));
            return;
        }
        this.setLogAggCheckIntervalMsecs(retentionSecs);
        this.task = new LogDeletionTask(conf, retentionSecs, this.createRMClient());
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this.task, 0L, this.checkIntervalMsecs);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public long getCheckIntervalMsecs() {
        return this.checkIntervalMsecs;
    }

    protected Configuration createConf() {
        return new Configuration();
    }

    @VisibleForTesting
    protected ApplicationClientProtocol createRMClient() throws IOException {
        return ClientRMProxy.createRMProxy(this.getConfig(), ApplicationClientProtocol.class);
    }

    @VisibleForTesting
    protected void stopRMClient() {
        if (this.task != null && this.task.getRMClient() != null) {
            RPC.stopProxy((Object)this.task.getRMClient());
        }
    }

    static class LogDeletionTask
    extends TimerTask {
        private Configuration conf;
        private long retentionMillis;
        private String suffix = null;
        private Path remoteRootLogDir = null;
        private ApplicationClientProtocol rmClient = null;

        public LogDeletionTask(Configuration conf, long retentionSecs, ApplicationClientProtocol rmClient) {
            this.conf = conf;
            this.retentionMillis = retentionSecs * 1000L;
            LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(conf);
            LogAggregationFileController fileController = factory.getFileControllerForWrite();
            this.remoteRootLogDir = fileController.getRemoteRootLogDir();
            this.suffix = fileController.getRemoteRootLogDirSuffix();
            this.rmClient = rmClient;
        }

        @Override
        public void run() {
            long cutoffMillis = System.currentTimeMillis() - this.retentionMillis;
            LOG.info((Object)"aggregated log deletion started.");
            try {
                FileSystem fs = this.remoteRootLogDir.getFileSystem(this.conf);
                for (FileStatus userDir : fs.listStatus(this.remoteRootLogDir)) {
                    if (!userDir.isDirectory()) continue;
                    Path userDirPath = new Path(userDir.getPath(), this.suffix);
                    LogDeletionTask.deleteOldLogDirsFrom(userDirPath, cutoffMillis, fs, this.rmClient);
                }
            }
            catch (Throwable t) {
                AggregatedLogDeletionService.logException("Error reading root log dir this deletion attempt is being aborted", t);
            }
            LOG.info((Object)"aggregated log deletion finished.");
        }

        private static void deleteOldLogDirsFrom(Path dir, long cutoffMillis, FileSystem fs, ApplicationClientProtocol rmClient) {
            FileStatus[] appDirs;
            try {
                appDirs = fs.listStatus(dir);
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logException("Could not read the contents of " + dir, e);
                return;
            }
            for (FileStatus appDir : appDirs) {
                LogDeletionTask.deleteAppDirLogs(cutoffMillis, fs, rmClient, appDir);
            }
        }

        private static void deleteAppDirLogs(long cutoffMillis, FileSystem fs, ApplicationClientProtocol rmClient, FileStatus appDir) {
            block11: {
                try {
                    if (!appDir.isDirectory() || appDir.getModificationTime() >= cutoffMillis) break block11;
                    ApplicationId appId = ApplicationId.fromString((String)appDir.getPath().getName());
                    boolean appTerminated = LogDeletionTask.isApplicationTerminated(appId, rmClient);
                    if (!appTerminated) {
                        FileStatus[] logFiles;
                        try {
                            logFiles = fs.listStatus(appDir.getPath());
                        }
                        catch (IOException e) {
                            AggregatedLogDeletionService.logException("Error reading the contents of " + appDir.getPath(), e);
                            return;
                        }
                        for (FileStatus node : logFiles) {
                            if (node.getModificationTime() >= cutoffMillis) continue;
                            try {
                                fs.delete(node.getPath(), true);
                            }
                            catch (IOException ex) {
                                AggregatedLogDeletionService.logException("Could not delete " + appDir.getPath(), ex);
                            }
                        }
                        break block11;
                    }
                    if (LogDeletionTask.shouldDeleteLogDir(appDir, cutoffMillis, fs)) {
                        try {
                            LOG.info((Object)("Deleting aggregated logs in " + appDir.getPath()));
                            fs.delete(appDir.getPath(), true);
                        }
                        catch (IOException e) {
                            AggregatedLogDeletionService.logException("Could not delete " + appDir.getPath(), e);
                        }
                    }
                }
                catch (Exception e) {
                    AggregatedLogDeletionService.logException("Could not delete " + appDir.getPath(), e);
                }
            }
        }

        private static boolean shouldDeleteLogDir(FileStatus dir, long cutoffMillis, FileSystem fs) {
            boolean shouldDelete = true;
            try {
                for (FileStatus node : fs.listStatus(dir.getPath())) {
                    if (node.getModificationTime() < cutoffMillis) continue;
                    shouldDelete = false;
                    break;
                }
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logException("Error reading the contents of " + dir.getPath(), e);
                shouldDelete = false;
            }
            return shouldDelete;
        }

        private static boolean isApplicationTerminated(ApplicationId appId, ApplicationClientProtocol rmClient) throws IOException {
            ApplicationReport appReport = null;
            try {
                appReport = rmClient.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId)).getApplicationReport();
            }
            catch (ApplicationNotFoundException e) {
                return true;
            }
            catch (YarnException e) {
                throw new IOException(e);
            }
            YarnApplicationState currentState = appReport.getYarnApplicationState();
            return Apps.isApplicationFinalState(currentState);
        }

        public ApplicationClientProtocol getRMClient() {
            return this.rmClient;
        }
    }
}

