/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.HdfsActionUtils;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartRandomJournalNodeAction
extends RestartActionBaseAction {
    private static final Logger LOG = LoggerFactory.getLogger(RestartRandomJournalNodeAction.class);

    public RestartRandomJournalNodeAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        String qjournal;
        this.getLogger().info("Performing action: Restart random JournalNode");
        try (DistributedFileSystem dfs = HdfsActionUtils.createDfs(this.getConf());){
            Configuration conf = dfs.getConf();
            String nameServiceID = DFSUtil.getNamenodeNameServiceId((Configuration)conf);
            if (!HAUtil.isHAEnabled((Configuration)conf, (String)nameServiceID)) {
                this.getLogger().info("HA for HDFS is not enabled; skipping");
                return;
            }
            qjournal = conf.get("dfs.namenode.shared.edits.dir");
            if (StringUtils.isEmpty((CharSequence)qjournal)) {
                this.getLogger().info("Empty qjournals!");
                return;
            }
        }
        ServerName journalNode = PolicyBasedChaosMonkey.selectRandomItem(RestartRandomJournalNodeAction.getJournalNodes(qjournal));
        this.restartJournalNode(journalNode, this.sleepTime);
    }

    private static ServerName[] getJournalNodes(String qjournal) {
        String[] journalNodes = qjournal.toLowerCase().replaceAll("qjournal:\\/\\/", "").replaceAll("\\/.*$", "").split(";");
        return (ServerName[])Arrays.stream(journalNodes).map(Address::fromString).map(addr -> ServerName.valueOf((String)addr.getHostName(), (long)addr.getPort())).toArray(ServerName[]::new);
    }
}

