/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs.monitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExcludeDatanodeManager
implements ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(ExcludeDatanodeManager.class);
    public static final String WAL_MAX_EXCLUDE_SLOW_DATANODE_COUNT_KEY = "hbase.regionserver.async.wal.max.exclude.datanode.count";
    public static final int DEFAULT_WAL_MAX_EXCLUDE_SLOW_DATANODE_COUNT = 3;
    public static final String WAL_EXCLUDE_DATANODE_TTL_KEY = "hbase.regionserver.async.wal.exclude.datanode.info.ttl.hour";
    public static final int DEFAULT_WAL_EXCLUDE_DATANODE_TTL = 6;
    private volatile Cache<DatanodeInfo, Long> excludeDNsCache;
    private final int maxExcludeDNCount;
    private final Configuration conf;
    private final Map<String, StreamSlowMonitor> streamSlowMonitors = new ConcurrentHashMap<String, StreamSlowMonitor>(1);

    public ExcludeDatanodeManager(Configuration conf) {
        this.conf = conf;
        this.maxExcludeDNCount = conf.getInt(WAL_MAX_EXCLUDE_SLOW_DATANODE_COUNT_KEY, 3);
        this.excludeDNsCache = CacheBuilder.newBuilder().expireAfterWrite(this.conf.getLong(WAL_EXCLUDE_DATANODE_TTL_KEY, 6L), TimeUnit.HOURS).maximumSize((long)this.maxExcludeDNCount).build();
    }

    public boolean tryAddExcludeDN(DatanodeInfo datanodeInfo, String cause) {
        boolean alreadyMarkedSlow = this.getExcludeDNs().containsKey(datanodeInfo);
        if (!alreadyMarkedSlow) {
            this.excludeDNsCache.put((Object)datanodeInfo, (Object)EnvironmentEdgeManager.currentTime());
            LOG.info("Added datanode: {} to exclude cache by [{}] success, current excludeDNsCache size={}", new Object[]{datanodeInfo, cause, this.excludeDNsCache.size()});
            return true;
        }
        LOG.debug("Try add datanode {} to exclude cache by [{}] failed, current exclude DNs are {}", new Object[]{datanodeInfo, cause, this.getExcludeDNs().keySet()});
        return false;
    }

    public StreamSlowMonitor getStreamSlowMonitor(String name) {
        String key = name == null || name.isEmpty() ? "defaultMonitorName" : name;
        return this.streamSlowMonitors.computeIfAbsent(key, k -> new StreamSlowMonitor(this.conf, key, this));
    }

    public Map<DatanodeInfo, Long> getExcludeDNs() {
        return this.excludeDNsCache.asMap();
    }

    public void onConfigurationChange(Configuration conf) {
        for (StreamSlowMonitor monitor : this.streamSlowMonitors.values()) {
            monitor.onConfigurationChange(conf);
        }
        this.excludeDNsCache = CacheBuilder.newBuilder().expireAfterWrite(this.conf.getLong(WAL_EXCLUDE_DATANODE_TTL_KEY, 6L), TimeUnit.HOURS).maximumSize((long)this.conf.getInt(WAL_MAX_EXCLUDE_SLOW_DATANODE_COUNT_KEY, 3)).build();
    }
}

