/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.hadoop.hbase.spark.ByteArrayWrapper;
import org.apache.hadoop.hbase.spark.KeyFamilyQualifier;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.Partitioner;
import org.apache.yetus.audience.InterfaceAudience;
import scala.reflect.ScalaSignature;

@InterfaceAudience.Public
@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0002\u0004\u0001#!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0003(\u0001\u0011\u0005\u0003\u0006C\u0003-\u0001\u0011\u0005SFA\nCk2\\Gj\\1e!\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0006Q\n\f7/\u001a\u0006\u0003\u00171\ta\u0001[1e_>\u0004(BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111#F\u0007\u0002))\u0011q\u0001D\u0005\u0003-Q\u00111\u0002U1si&$\u0018n\u001c8fe\u0006I1\u000f^1si.+\u0017p\u001d\t\u00043qqR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0007ear\u0004\u0005\u0002\u001aA%\u0011\u0011E\u0007\u0002\u0005\u0005f$X-\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0019\u0002\"!\n\u0001\u000e\u0003\u0019AQa\u0006\u0002A\u0002a\tQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#A\u0015\u0011\u0005eQ\u0013BA\u0016\u001b\u0005\rIe\u000e^\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u0003S9BQa\f\u0003A\u0002A\n1a[3z!\tI\u0012'\u0003\u000235\t\u0019\u0011I\\=)\u0005\u0001!\u0004CA\u001b>\u001d\t14(D\u00018\u0015\tA\u0014(\u0001\u0005bk\u0012LWM\\2f\u0015\tQD\"A\u0003zKR,8/\u0003\u0002=o\u0005\t\u0012J\u001c;fe\u001a\f7-Z!vI&,gnY3\n\u0005yz$A\u0002)vE2L7M\u0003\u0002=o\u0001")
public class BulkLoadPartitioner
extends Partitioner {
    private final byte[][] startKeys;

    public int numPartitions() {
        return this.startKeys.length == 0 ? 1 : this.startKeys.length;
    }

    public int getPartition(Object key) {
        int partition;
        block5: {
            byte[] byArray;
            Comparator<byte[]> comparator = new Comparator<byte[]>(null){

                public Comparator<byte[]> reversed() {
                    return Comparator.super.reversed();
                }

                public Comparator<byte[]> thenComparing(Comparator<? super byte[]> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public <U> Comparator<byte[]> thenComparing(Function<? super byte[], ? extends U> x$1, Comparator<? super U> x$2) {
                    return Comparator.super.thenComparing(x$1, x$2);
                }

                public <U extends Comparable<? super U>> Comparator<byte[]> thenComparing(Function<? super byte[], ? extends U> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public Comparator<byte[]> thenComparingInt(ToIntFunction<? super byte[]> x$1) {
                    return Comparator.super.thenComparingInt(x$1);
                }

                public Comparator<byte[]> thenComparingLong(ToLongFunction<? super byte[]> x$1) {
                    return Comparator.super.thenComparingLong(x$1);
                }

                public Comparator<byte[]> thenComparingDouble(ToDoubleFunction<? super byte[]> x$1) {
                    return Comparator.super.thenComparingDouble(x$1);
                }

                public int compare(byte[] o1, byte[] o2) {
                    return Bytes.compareTo((byte[])o1, (byte[])o2);
                }
            };
            Object object = key;
            if (object instanceof KeyFamilyQualifier) {
                KeyFamilyQualifier keyFamilyQualifier = (KeyFamilyQualifier)object;
                byArray = keyFamilyQualifier.rowKey();
            } else if (object instanceof ByteArrayWrapper) {
                ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)object;
                byArray = byteArrayWrapper.value();
            } else {
                byArray = (byte[])key;
            }
            byte[] rowKey = byArray;
            partition = Arrays.binarySearch((Object[])this.startKeys, rowKey, comparator);
            if (partition < 0) {
                partition = partition * -1 + -2;
            }
            if (partition >= 0) break block5;
            partition = 0;
        }
        return partition;
    }

    public BulkLoadPartitioner(byte[][] startKeys) {
        this.startKeys = startKeys;
    }
}

