/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.spark.JavaHBaseContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class JavaHBaseBulkDeleteExample {
    private JavaHBaseBulkDeleteExample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("JavaHBaseBulkDeleteExample  {tableName}");
            return;
        }
        String tableName = args[0];
        SparkConf sparkConf = new SparkConf().setAppName("JavaHBaseBulkDeleteExample " + tableName);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        try {
            ArrayList<byte[]> list = new ArrayList<byte[]>(5);
            list.add(Bytes.toBytes((String)"1"));
            list.add(Bytes.toBytes((String)"2"));
            list.add(Bytes.toBytes((String)"3"));
            list.add(Bytes.toBytes((String)"4"));
            list.add(Bytes.toBytes((String)"5"));
            JavaRDD rdd = jsc.parallelize(list);
            Configuration conf = HBaseConfiguration.create();
            JavaHBaseContext hbaseContext = new JavaHBaseContext(jsc, conf);
            hbaseContext.bulkDelete(rdd, TableName.valueOf((String)tableName), new DeleteFunction(), 4);
        }
        finally {
            jsc.stop();
        }
    }

    public static class DeleteFunction
    implements Function<byte[], Delete> {
        private static final long serialVersionUID = 1L;

        public Delete call(byte[] v) throws Exception {
            return new Delete(v);
        }
    }
}

