/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.spark.JavaHBaseContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Tuple2;

@InterfaceAudience.Private
public final class JavaHBaseMapGetPutExample {
    private JavaHBaseMapGetPutExample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("JavaHBaseBulkGetExample {tableName}");
            return;
        }
        final String tableName = args[0];
        SparkConf sparkConf = new SparkConf().setAppName("JavaHBaseBulkGetExample " + tableName);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        try {
            ArrayList<byte[]> list = new ArrayList<byte[]>(5);
            list.add(Bytes.toBytes((String)"1"));
            list.add(Bytes.toBytes((String)"2"));
            list.add(Bytes.toBytes((String)"3"));
            list.add(Bytes.toBytes((String)"4"));
            list.add(Bytes.toBytes((String)"5"));
            JavaRDD rdd = jsc.parallelize(list);
            Configuration conf = HBaseConfiguration.create();
            JavaHBaseContext hbaseContext = new JavaHBaseContext(jsc, conf);
            hbaseContext.foreachPartition(rdd, new VoidFunction<Tuple2<Iterator<byte[]>, Connection>>(){

                public void call(Tuple2<Iterator<byte[]>, Connection> t) throws Exception {
                    Table table = ((Connection)t._2()).getTable(TableName.valueOf((String)tableName));
                    BufferedMutator mutator = ((Connection)t._2()).getBufferedMutator(TableName.valueOf((String)tableName));
                    while (((Iterator)t._1()).hasNext()) {
                        byte[] b = (byte[])((Iterator)t._1()).next();
                        Result r = table.get(new Get(b));
                        if (!r.getExists().booleanValue()) continue;
                        mutator.mutate((Mutation)new Put(b));
                    }
                    mutator.flush();
                    mutator.close();
                    table.close();
                }
            });
        }
        finally {
            jsc.stop();
        }
    }

    public static class GetFunction
    implements Function<byte[], Get> {
        private static final long serialVersionUID = 1L;

        public Get call(byte[] v) throws Exception {
            return new Get(v);
        }
    }
}

