/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public final class CopyListingFileStatus
implements Writable {
    private static final byte NO_ACL_ENTRIES = -1;
    private static final int NO_XATTRS = -1;
    private Path path;
    private long length;
    private boolean isdir;
    private short blockReplication;
    private long blocksize;
    private long modificationTime;
    private long accessTime;
    private FsPermission permission;
    private String owner;
    private String group;
    private static final AclEntryType[] ACL_ENTRY_TYPES = AclEntryType.values();
    private static final AclEntryScope[] ACL_ENTRY_SCOPES = AclEntryScope.values();
    private static final FsAction[] FS_ACTIONS = FsAction.values();
    private List<AclEntry> aclEntries;
    private Map<String, byte[]> xAttrs;
    private long chunkOffset = 0L;
    private long chunkLength = Long.MAX_VALUE;

    public CopyListingFileStatus() {
        this(0L, false, 0, 0L, 0L, 0L, null, null, null, null);
    }

    public CopyListingFileStatus(FileStatus fileStatus) {
        this(fileStatus.getLen(), fileStatus.isDirectory(), fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), fileStatus.getAccessTime(), fileStatus.getPermission(), fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.getPath());
    }

    public CopyListingFileStatus(FileStatus fileStatus, long chunkOffset, long chunkLength) {
        this(fileStatus.getLen(), fileStatus.isDirectory(), fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), fileStatus.getAccessTime(), fileStatus.getPermission(), fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.getPath());
        this.chunkOffset = chunkOffset;
        this.chunkLength = chunkLength;
    }

    public CopyListingFileStatus(long length, boolean isdir, int blockReplication, long blocksize, long modificationTime, long accessTime, FsPermission permission, String owner, String group, Path path) {
        this(length, isdir, blockReplication, blocksize, modificationTime, accessTime, permission, owner, group, path, 0L, Long.MAX_VALUE);
    }

    public CopyListingFileStatus(long length, boolean isdir, int blockReplication, long blocksize, long modificationTime, long accessTime, FsPermission permission, String owner, String group, Path path, long chunkOffset, long chunkLength) {
        this.length = length;
        this.isdir = isdir;
        this.blockReplication = (short)blockReplication;
        this.blocksize = blocksize;
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
        this.permission = permission != null ? permission : (isdir ? FsPermission.getDirDefault() : FsPermission.getFileDefault());
        this.owner = owner == null ? "" : owner;
        this.group = group == null ? "" : group;
        this.path = path;
        this.chunkOffset = chunkOffset;
        this.chunkLength = chunkLength;
    }

    public CopyListingFileStatus(CopyListingFileStatus other) {
        this.length = other.length;
        this.isdir = other.isdir;
        this.blockReplication = other.blockReplication;
        this.blocksize = other.blocksize;
        this.modificationTime = other.modificationTime;
        this.accessTime = other.accessTime;
        this.permission = other.permission;
        this.owner = other.owner;
        this.group = other.group;
        this.path = new Path(other.path.toUri());
        this.chunkOffset = other.chunkOffset;
        this.chunkLength = other.chunkLength;
    }

    public Path getPath() {
        return this.path;
    }

    public long getLen() {
        return this.length;
    }

    public long getBlockSize() {
        return this.blocksize;
    }

    public boolean isDirectory() {
        return this.isdir;
    }

    public short getReplication() {
        return this.blockReplication;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    public List<AclEntry> getAclEntries() {
        return AclUtil.getAclFromPermAndEntries((FsPermission)this.getPermission(), this.aclEntries != null ? this.aclEntries : Collections.emptyList());
    }

    public void setAclEntries(List<AclEntry> aclEntries) {
        this.aclEntries = aclEntries;
    }

    public Map<String, byte[]> getXAttrs() {
        return this.xAttrs != null ? this.xAttrs : Collections.emptyMap();
    }

    public void setXAttrs(Map<String, byte[]> xAttrs) {
        this.xAttrs = xAttrs;
    }

    public long getChunkOffset() {
        return this.chunkOffset;
    }

    public void setChunkOffset(long offset) {
        this.chunkOffset = offset;
    }

    public long getChunkLength() {
        return this.chunkLength;
    }

    public void setChunkLength(long chunkLength) {
        this.chunkLength = chunkLength;
    }

    public boolean isSplit() {
        return this.getChunkLength() != Long.MAX_VALUE && this.getChunkLength() != this.getLen();
    }

    public long getSizeToCopy() {
        return this.isSplit() ? this.getChunkLength() : this.getLen();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.getPath().toString(), (int)0x100000);
        out.writeLong(this.getLen());
        out.writeBoolean(this.isDirectory());
        out.writeShort(this.getReplication());
        out.writeLong(this.getBlockSize());
        out.writeLong(this.getModificationTime());
        out.writeLong(this.getAccessTime());
        this.getPermission().write(out);
        Text.writeString((DataOutput)out, (String)this.getOwner(), (int)0x100000);
        Text.writeString((DataOutput)out, (String)this.getGroup(), (int)0x100000);
        if (this.aclEntries != null) {
            out.writeByte(this.aclEntries.size());
            for (AclEntry aclEntry : this.aclEntries) {
                out.writeByte(aclEntry.getScope().ordinal());
                out.writeByte(aclEntry.getType().ordinal());
                WritableUtils.writeString((DataOutput)out, (String)aclEntry.getName());
                out.writeByte(aclEntry.getPermission().ordinal());
            }
        } else {
            out.writeByte(-1);
        }
        if (this.xAttrs != null) {
            out.writeInt(this.xAttrs.size());
            for (Map.Entry<String, byte[]> entry : this.xAttrs.entrySet()) {
                WritableUtils.writeString((DataOutput)out, (String)entry.getKey());
                byte[] value = entry.getValue();
                if (value != null) {
                    out.writeInt(value.length);
                    if (value.length <= 0) continue;
                    out.write(value);
                    continue;
                }
                out.writeInt(-1);
            }
        } else {
            out.writeInt(-1);
        }
        out.writeLong(this.chunkOffset);
        out.writeLong(this.chunkLength);
    }

    public void readFields(DataInput in) throws IOException {
        int xAttrsSize;
        String strPath = Text.readString((DataInput)in, (int)0x100000);
        this.path = new Path(strPath);
        this.length = in.readLong();
        this.isdir = in.readBoolean();
        this.blockReplication = in.readShort();
        this.blocksize = in.readLong();
        this.modificationTime = in.readLong();
        this.accessTime = in.readLong();
        this.permission.readFields(in);
        this.owner = Text.readString((DataInput)in, (int)0x100000);
        this.group = Text.readString((DataInput)in, (int)0x100000);
        int aclEntriesSize = in.readByte();
        if (aclEntriesSize != -1) {
            this.aclEntries = Lists.newArrayListWithCapacity((int)aclEntriesSize);
            for (int i = 0; i < aclEntriesSize; ++i) {
                this.aclEntries.add(new AclEntry.Builder().setScope(ACL_ENTRY_SCOPES[in.readByte()]).setType(ACL_ENTRY_TYPES[in.readByte()]).setName(WritableUtils.readString((DataInput)in)).setPermission(FS_ACTIONS[in.readByte()]).build());
            }
        } else {
            this.aclEntries = null;
        }
        if ((xAttrsSize = in.readInt()) != -1) {
            this.xAttrs = Maps.newHashMap();
            for (int i = 0; i < xAttrsSize; ++i) {
                String name = WritableUtils.readString((DataInput)in);
                int valueLen = in.readInt();
                byte[] value = null;
                if (valueLen > -1) {
                    value = new byte[valueLen];
                    if (valueLen > 0) {
                        in.readFully(value);
                    }
                }
                this.xAttrs.put(name, value);
            }
        } else {
            this.xAttrs = null;
        }
        this.chunkOffset = in.readLong();
        this.chunkLength = in.readLong();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CopyListingFileStatus other = (CopyListingFileStatus)o;
        return this.getPath().equals((Object)other.getPath()) && Objects.equal(this.aclEntries, other.aclEntries) && Objects.equal(this.xAttrs, other.xAttrs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.aclEntries, this.xAttrs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append('{');
        sb.append(this.getPath().toString());
        sb.append(" length = ").append(this.getLen());
        sb.append(" aclEntries = ").append(this.aclEntries);
        sb.append(", xAttrs = ").append(this.xAttrs);
        if (this.isSplit()) {
            sb.append(", chunkOffset = ").append(this.getChunkOffset());
            sb.append(", chunkLength = ").append(this.getChunkLength());
        }
        sb.append('}');
        return sb.toString();
    }
}

