/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinished;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.util.SystemClock;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskFinishedEvent
implements HistoryEvent {
    private TaskFinished datum = null;
    private TaskID taskid;
    private TaskAttemptID successfulAttemptId;
    private long finishTime;
    private TaskType taskType;
    private String status;
    private Counters counters;
    private long startTime;

    public TaskFinishedEvent(TaskID id, TaskAttemptID attemptId, long finishTime, TaskType taskType, String status, Counters counters, long startTs) {
        this.taskid = id;
        this.successfulAttemptId = attemptId;
        this.finishTime = finishTime;
        this.taskType = taskType;
        this.status = status;
        this.counters = counters;
        this.startTime = startTs;
    }

    public TaskFinishedEvent(TaskID id, TaskAttemptID attemptId, long finishTime, TaskType taskType, String status, Counters counters) {
        this(id, attemptId, finishTime, taskType, status, counters, SystemClock.getInstance().getTime());
    }

    TaskFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskFinished();
            this.datum.setTaskid((CharSequence)new Utf8(this.taskid.toString()));
            if (this.successfulAttemptId != null) {
                this.datum.setSuccessfulAttemptId((CharSequence)new Utf8(this.successfulAttemptId.toString()));
            }
            this.datum.setFinishTime(this.finishTime);
            this.datum.setCounters(EventWriter.toAvro(this.counters));
            this.datum.setTaskType((CharSequence)new Utf8(this.taskType.name()));
            this.datum.setStatus((CharSequence)new Utf8(this.status));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (TaskFinished)((Object)oDatum);
        this.taskid = TaskID.forName(this.datum.getTaskid().toString());
        if (this.datum.getSuccessfulAttemptId() != null) {
            this.successfulAttemptId = TaskAttemptID.forName(this.datum.getSuccessfulAttemptId().toString());
        }
        this.finishTime = this.datum.getFinishTime();
        this.taskType = TaskType.valueOf(this.datum.getTaskType().toString());
        this.status = this.datum.getStatus().toString();
        this.counters = EventReader.fromAvro(this.datum.getCounters());
    }

    public TaskID getTaskId() {
        return this.taskid;
    }

    public TaskAttemptID getSuccessfulTaskAttemptId() {
        return this.successfulAttemptId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getTaskStatus() {
        return this.status.toString();
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_FINISHED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase((String)this.getEventType().name()));
        tEvent.addInfo("TASK_TYPE", (Object)this.getTaskType().toString());
        tEvent.addInfo("FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("STATUS", (Object)TaskStatus.State.SUCCEEDED.toString());
        tEvent.addInfo("SUCCESSFUL_TASK_ATTEMPT_ID", (Object)(this.getSuccessfulTaskAttemptId() == null ? "" : this.getSuccessfulTaskAttemptId().toString()));
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        Set<TimelineMetric> jobMetrics = JobHistoryEventUtils.countersToTimelineMetric(this.getCounters(), this.finishTime);
        return jobMetrics;
    }
}

