/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.HBCKMetaTableAccessor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HBCKActions {
    private Configuration conf;

    public HBCKActions(Configuration conf) {
        this.conf = conf;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        Configuration conf = HBaseConfiguration.create();
        HBCKActions tool = new HBCKActions(conf);
        if (args.length < 1 || args[0].equals("help")) {
            HBCKActions.printUsageAndExit();
        }
        if (args[0].equals("deleteRegionFromMeta")) {
            if (args.length != 2) {
                System.err.println("ERROR: Number of parameters not correct");
                HBCKActions.printUsageAndExit();
            }
            String tableName = args[1];
            tool.deleteRegionFromMeta(tableName);
        } else {
            System.err.println("ERROR: Unknown option passed.");
            HBCKActions.printUsageAndExit();
        }
    }

    private static void printUsageAndExit() {
        System.err.println("hbckActions <options>");
        System.err.println("OPTIONS:");
        System.err.println("help");
        System.err.println("      Prints this help message.\n");
        System.err.println("deleteRegionFromMeta <tableName>");
        System.err.println("      Deletes the middle region from the regions of the\n      given table from Meta table. Removes whole of the\n      info column family");
        System.exit(1);
    }

    private void deleteRegionFromMeta(String tname) throws IOException, InterruptedException {
        TableName tn = TableName.valueOf((String)tname);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.conf);){
            Table metaTable = connection.getTable(TableName.valueOf((String)"hbase:meta"));
            List<RegionInfo> ris = HBCKMetaTableAccessor.getTableRegions(connection, tn);
            System.out.println(String.format("Current Regions of the table " + tn.getNameAsString() + " in Meta before deletion of the region are: " + ris, new Object[0]));
            RegionInfo ri = ris.get(ris.size() / 2);
            System.out.println("Deleting Region " + ri.getRegionNameAsString());
            byte[] key = HBCKMetaTableAccessor.getMetaKeyForRegion(ri);
            Delete delete = new Delete(key);
            delete.addFamily(Bytes.toBytes((String)"info"));
            metaTable.delete(delete);
            Thread.sleep(500L);
            ris = HBCKMetaTableAccessor.getTableRegions(connection, tn);
            System.out.println("Current Regions of the table " + tn.getNameAsString() + " in Meta after deletion of the region are: " + ris);
        }
    }
}

