/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hbase.HBCK2;
import org.apache.hbase.hbck1.HBaseFsck;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;

public class ReplicationFsck
implements Closeable {
    private final Configuration configuration;

    ReplicationFsck(Configuration conf) throws IOException {
        this.configuration = conf;
    }

    @Override
    public void close() {
    }

    int fsck(String[] args) throws IOException {
        CommandLine commandLine;
        Options options = new Options();
        Option fixOption = Option.builder((String)"f").longOpt("fix").build();
        options.addOption(fixOption);
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args, false);
        }
        catch (ParseException e) {
            HBCK2.showErrorMessage(e.getMessage());
            return -1;
        }
        boolean fix = commandLine.hasOption(fixOption.getOpt());
        try (HBaseFsck hbaseFsck = new HBaseFsck(this.configuration);){
            hbaseFsck.setFixReplication(fix);
            hbaseFsck.checkAndFixReplication();
            List tables = commandLine.getArgList();
            if (tables != null && !tables.isEmpty()) {
                hbaseFsck.connect();
                hbaseFsck.setCleanReplicationBarrier(fix);
                for (String table : tables) {
                    hbaseFsck.setCleanReplicationBarrierTable(table);
                    hbaseFsck.cleanReplicationBarrier();
                }
            }
        }
        catch (ClassNotFoundException | ReplicationException e) {
            throw new IOException(e);
        }
        return 0;
    }
}

