/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp;

import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.manager.zk.ByteArraySerializer;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.webapp.RestAdminApplication;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixAdminWebApp {
    public final Logger LOG = LoggerFactory.getLogger(HelixAdminWebApp.class);
    private RestAdminApplication _adminApp = null;
    private Component _component = null;
    private final int _helixAdminPort;
    private final String _zkServerAddress;
    private ZkClient _zkClient = null;
    private ZkClient _rawZkClient = null;

    public HelixAdminWebApp(String zkServerAddress, int adminPort) {
        this._zkServerAddress = zkServerAddress;
        this._helixAdminPort = adminPort;
    }

    public synchronized void start() throws Exception {
        this.LOG.info("helixAdminWebApp starting");
        if (this._component == null) {
            this._zkClient = new ZkClient(this._zkServerAddress, 30000, 60000, (ZkSerializer)new ZNRecordSerializer());
            this._rawZkClient = new ZkClient(this._zkServerAddress, 30000, 60000, (ZkSerializer)new ByteArraySerializer());
            this._component = new Component();
            this._component.getServers().add(Protocol.HTTP, this._helixAdminPort);
            Context applicationContext = this._component.getContext().createChildContext();
            applicationContext.getAttributes().put("zkSvr", this._zkServerAddress);
            applicationContext.getAttributes().put("port", "" + this._helixAdminPort);
            applicationContext.getAttributes().put("zkClient", this._zkClient);
            applicationContext.getAttributes().put(ResourceUtil.ContextKey.RAW_ZKCLIENT.toString(), this._rawZkClient);
            this._adminApp = new RestAdminApplication(applicationContext);
            this._component.getDefaultHost().attach((Restlet)this._adminApp);
            this._component.start();
        }
        this.LOG.info("helixAdminWebApp started on port: " + this._helixAdminPort);
    }

    public synchronized void stop() {
        this.LOG.info("Stopping helixAdminWebApp");
        try {
            this._component.stop();
            this.LOG.info("Stopped helixAdminWebApp");
        }
        catch (Exception e) {
            this.LOG.error("Exception in stopping helixAdminWebApp", (Throwable)e);
        }
        finally {
            if (this._zkClient != null) {
                this._zkClient.close();
            }
            if (this._rawZkClient != null) {
                this._rawZkClient.close();
            }
        }
    }
}

