/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.api.rebalancer.constraint.dataprovider.PartitionWeightProvider;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.model.Partition;

public class ResourceUsageCalculator {
    public static Map<String, Integer> getResourceUsage(ResourcesStateMap resourceAssignment, PartitionWeightProvider weightProvider) {
        HashMap<String, Integer> newParticipantUsage = new HashMap<String, Integer>();
        for (String resource : resourceAssignment.resourceSet()) {
            Map<Partition, Map<String, String>> stateMap = resourceAssignment.getPartitionStateMap(resource).getStateMap();
            for (Partition partition : stateMap.keySet()) {
                for (String participant : stateMap.get(partition).keySet()) {
                    if (!newParticipantUsage.containsKey(participant)) {
                        newParticipantUsage.put(participant, 0);
                    }
                    newParticipantUsage.put(participant, (Integer)newParticipantUsage.get(participant) + weightProvider.getPartitionWeight(resource, partition.getPartitionName()));
                }
            }
        }
        return newParticipantUsage;
    }
}

