/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.engine.header.Header;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class HttpExchangeCall
extends ServerCall {
    private final HttpExchange exchange;
    private volatile boolean requestHeadersAdded;

    public HttpExchangeCall(Server server, HttpExchange exchange) {
        super(server);
        this.exchange = exchange;
    }

    @Override
    public boolean abort() {
        this.exchange.close();
        return true;
    }

    @Override
    public void flushBuffers() throws IOException {
        this.exchange.getResponseBody().flush();
    }

    @Override
    public String getClientAddress() {
        return this.exchange.getRemoteAddress().getAddress().getHostAddress();
    }

    @Override
    public int getClientPort() {
        return this.exchange.getRemoteAddress().getPort();
    }

    @Override
    public String getMethod() {
        return this.exchange.getRequestMethod();
    }

    @Override
    public Series<Header> getRequestHeaders() {
        Series<Header> result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            Headers headers = this.exchange.getRequestHeaders();
            for (String name : headers.keySet()) {
                Iterator i$ = headers.get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    result.add(name, value);
                }
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    @Override
    public InputStream getRequestEntityStream(long size) {
        return this.exchange.getRequestBody();
    }

    @Override
    public InputStream getRequestHeadStream() {
        return null;
    }

    @Override
    public String getRequestUri() {
        return this.exchange.getRequestURI().toString();
    }

    @Override
    public OutputStream getResponseEntityStream() {
        return this.exchange.getResponseBody();
    }

    @Override
    public void writeResponseHead(Response restletResponse) throws IOException {
        Headers headers = this.exchange.getResponseHeaders();
        for (Header header : this.getResponseHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        Representation entity = restletResponse.getEntity();
        long responseLength = 0L;
        if (entity == null || !entity.isAvailable()) {
            responseLength = -1L;
        } else if (entity.getAvailableSize() != -1L) {
            responseLength = entity.getAvailableSize();
        }
        this.exchange.sendResponseHeaders(this.getStatusCode(), responseLength);
    }
}

