/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.glassfish.grizzly.ThreadCache;

public final class DirectByteBufferRecord {
    ByteBuffer strongRef;
    private SoftReference<ByteBuffer> softRef;
    private static final ThreadCache.CachedTypeIndex<DirectByteBufferRecord> CACHE_IDX = ThreadCache.obtainIndex("direct-buffer-cache", DirectByteBufferRecord.class, 1);

    public static DirectByteBufferRecord allocate(int size) {
        DirectByteBufferRecord record = ThreadCache.getFromCache(CACHE_IDX);
        if (record != null) {
            ByteBuffer byteBuffer = record.switchToStrong();
            if (byteBuffer != null && byteBuffer.remaining() >= size) {
                return record;
            }
        } else {
            record = new DirectByteBufferRecord();
            ThreadCache.putToCache(CACHE_IDX, record);
        }
        record.reset(ByteBuffer.allocateDirect(size));
        return record;
    }

    public ByteBuffer getByteBuffer() {
        return this.strongRef;
    }

    void reset(ByteBuffer byteBuffer) {
        this.strongRef = byteBuffer;
        this.softRef = null;
    }

    ByteBuffer switchToStrong() {
        if (this.strongRef == null && this.softRef != null) {
            this.strongRef = this.softRef.get();
        }
        return this.strongRef;
    }

    void switchToSoft() {
        if (this.strongRef != null && this.softRef == null) {
            this.softRef = new SoftReference<ByteBuffer>(this.strongRef);
        }
        this.strongRef = null;
    }

    public void release() {
        this.strongRef.clear();
        this.switchToSoft();
    }
}

