/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.server.filecache.FileCacheEntry;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class FileCacheFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(FileCacheFilter.class);
    private final FileCache fileCache;

    public FileCacheFilter(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        FileCacheEntry cacheEntry;
        HttpContent requestContent = (HttpContent)ctx.getMessage();
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        if (this.fileCache.isEnabled() && Method.GET.equals(request.getMethod()) && (cacheEntry = this.fileCache.get(request)) != null) {
            HttpResponsePacket response = request.getResponse();
            this.prepareResponse(cacheEntry, response);
            if (response.getStatus() != 200) {
                ctx.write((Object)HttpContent.builder((HttpHeader)response).content(Buffers.EMPTY_BUFFER).last(true).build());
                return this.flush(ctx);
            }
            boolean isServeCompressed = cacheEntry.canServeCompressed(request);
            this.prepareResponseWithPayload(cacheEntry, response, isServeCompressed);
            if (cacheEntry.type != FileCache.CacheType.FILE) {
                Buffer buffer = Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (ByteBuffer)cacheEntry.getByteBuffer(isServeCompressed));
                ctx.write((Object)HttpContent.builder((HttpHeader)response).content(buffer).last(true).build());
                return this.flush(ctx);
            }
            if (this.fileCache.isFileSendEnabled() && !request.isSecure()) {
                return this.sendFileZeroCopy(ctx, response, cacheEntry, isServeCompressed);
            }
            return this.sendFileUsingBuffers(ctx, response, cacheEntry, isServeCompressed);
        }
        return ctx.getInvokeAction();
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    private void prepareResponse(FileCacheEntry entry, HttpResponsePacket response) throws IOException {
        response.setContentType(entry.contentType.prepare());
        if (entry.server != null) {
            response.addHeader(Header.Server, entry.server);
        }
    }

    private void prepareResponseWithPayload(FileCacheEntry entry, HttpResponsePacket response, boolean isServeCompressed) throws IOException {
        response.addHeader(Header.ETag, entry.Etag);
        response.addHeader(Header.LastModified, entry.lastModifiedHeader);
        response.setContentLengthLong(entry.getFileSize(isServeCompressed));
        if (isServeCompressed) {
            response.addHeader(Header.ContentEncoding, "gzip");
        }
    }

    private NextAction sendFileUsingBuffers(FilterChainContext ctx, HttpResponsePacket response, FileCacheEntry cacheEntry, boolean isServeCompressed) {
        try {
            FileSendEntry sendEntry = FileSendEntry.create(ctx, response, cacheEntry.getFile(isServeCompressed), cacheEntry.getFileSize(isServeCompressed));
            ctx.suspend();
            sendEntry.send();
            return ctx.getSuspendAction();
        }
        catch (IOException e) {
            return ctx.getInvokeAction();
        }
    }

    private NextAction sendFileZeroCopy(FilterChainContext ctx, HttpResponsePacket response, final FileCacheEntry cacheEntry, boolean isServeCompressed) {
        ctx.write((Object)response);
        FileTransfer f = new FileTransfer(cacheEntry.getFile(isServeCompressed), 0L, cacheEntry.getFileSize(isServeCompressed));
        ctx.write((Object)f, (CompletionHandler)new EmptyCompletionHandler<WriteResult>(){
            final FileCacheEntry strongRef;
            {
                this.strongRef = cacheEntry;
            }

            public void failed(Throwable throwable) {
                LOGGER.log(Level.FINE, "Error reported during file-send entry: " + cacheEntry, throwable);
            }
        });
        return this.flush(ctx);
    }

    private NextAction flush(final FilterChainContext ctx) {
        HttpContext httpContext = HttpContext.get((FilterChainContext)ctx);
        assert (httpContext != null);
        OutputSink output = httpContext.getOutputSink();
        if (output.canWrite()) {
            return ctx.getStopAction();
        }
        NextAction suspendAction = ctx.getSuspendAction();
        ctx.suspend();
        output.notifyCanWrite(new WriteHandler(){

            public void onWritePossible() throws Exception {
                this.finish();
            }

            public void onError(Throwable t) {
                this.finish();
            }

            private void finish() {
                ctx.completeAndRecycle();
            }
        });
        return suspendAction;
    }

    private static class FileSendEntry
    implements WriteHandler {
        private final FilterChainContext ctx;
        private final FileChannel fc;
        private final FileInputStream fis;
        private final HttpResponsePacket response;
        private final OutputSink output;
        private long remaining;

        public static FileSendEntry create(FilterChainContext ctx, HttpResponsePacket response, File file, long size) throws IOException {
            FileInputStream fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            return new FileSendEntry(ctx, response, fis, fc, size);
        }

        public FileSendEntry(FilterChainContext ctx, HttpResponsePacket response, FileInputStream fis, FileChannel fc, long size) {
            this.ctx = ctx;
            this.response = response;
            this.fis = fis;
            this.fc = fc;
            this.remaining = size;
            HttpContext httpContext = HttpContext.get((FilterChainContext)ctx);
            assert (httpContext != null);
            this.output = httpContext.getOutputSink();
        }

        public void close() {
            try {
                this.fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void send() {
            int chunkSize = 8192;
            try {
                boolean isLast;
                do {
                    Buffer buffer = this.ctx.getMemoryManager().allocate(8192);
                    buffer.allowBufferDispose(true);
                    long readNow = Buffers.readFromFileChannel((FileChannel)this.fc, (Buffer)buffer);
                    isLast = readNow <= 0L || (this.remaining -= readNow) <= 0L;
                    buffer.trim();
                    this.ctx.write((Object)HttpContent.builder((HttpHeader)this.response).content(buffer).last(isLast).build());
                } while (!isLast && this.output.canWrite());
                if (isLast) {
                    this.done();
                } else {
                    this.output.notifyCanWrite((WriteHandler)this);
                }
            }
            catch (IOException e) {
                this.done();
            }
        }

        private void done() {
            this.close();
            this.ctx.resume(this.ctx.getStopAction());
        }

        public void onWritePossible() throws Exception {
            this.send();
        }

        public void onError(Throwable t) {
            this.done();
        }
    }
}

