/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.api.status;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import org.apache.helix.api.status.ClusterManagementMode;

@JsonDeserialize(builder=Builder.class)
public class ClusterManagementModeRequest {
    private final ClusterManagementMode.Type _mode;
    private final String _clusterName;
    private final String _reason;
    private final boolean _cancelPendingST;

    public ClusterManagementMode.Type getMode() {
        return this._mode;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public String getReason() {
        return this._reason;
    }

    public boolean isCancelPendingST() {
        return this._cancelPendingST;
    }

    public ClusterManagementModeRequest(Builder builder) {
        this._mode = builder.mode;
        this._clusterName = builder.clusterName;
        this._reason = builder.reason;
        this._cancelPendingST = builder.cancelPendingST;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonPOJOBuilder(buildMethodName="buildFromJson")
    public static final class Builder {
        private ClusterManagementMode.Type mode;
        private String clusterName;
        private String reason = "";
        private boolean cancelPendingST;

        public Builder withMode(ClusterManagementMode.Type mode) {
            this.mode = mode;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder withCancelPendingST(boolean cancelPendingST) {
            this.cancelPendingST = cancelPendingST;
            return this;
        }

        public ClusterManagementModeRequest build() {
            this.validate();
            return new ClusterManagementModeRequest(this);
        }

        private ClusterManagementModeRequest buildFromJson() {
            Preconditions.checkNotNull((Object)((Object)this.mode), (Object)"Mode not set");
            return new ClusterManagementModeRequest(this);
        }

        private void validate() {
            Preconditions.checkNotNull((Object)((Object)this.mode), (Object)"Mode not set");
            Preconditions.checkNotNull((Object)this.clusterName, (Object)"Cluster name not set");
        }
    }
}

