/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.servlet.Servlet;
import org.apache.helix.HelixException;
import org.apache.helix.rest.common.ContextPropertyKeys;
import org.apache.helix.rest.common.HelixRestNamespace;
import org.apache.helix.rest.common.ServletType;
import org.apache.helix.rest.server.HelixRestObjectNameFactory;
import org.apache.helix.rest.server.ServerContext;
import org.apache.helix.rest.server.auditlog.AuditLogger;
import org.apache.helix.rest.server.authValidator.AuthValidator;
import org.apache.helix.rest.server.authValidator.NoopAuthValidator;
import org.apache.helix.rest.server.filters.AuditLogFilter;
import org.apache.helix.rest.server.filters.CORSFilter;
import org.apache.helix.rest.server.filters.ClusterAuthFilter;
import org.apache.helix.rest.server.filters.NamespaceAuthFilter;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixRestServer {
    private static Logger LOG = LoggerFactory.getLogger(HelixRestServer.class);
    private static final String REST_DOMAIN = "org.apache.helix.rest";
    private static final String CORS_ENABLED = "cors.enabled";
    public static SSLContext REST_SERVER_SSL_CONTEXT;
    private int _port;
    private String _urlPrefix;
    private Server _server;
    private List<JmxReporter> _jmxReporterList;
    private List<HelixRestNamespace> _helixNamespaces;
    private ServletContextHandler _servletContextHandler;
    private List<AuditLogger> _auditLoggers;
    private AuthValidator _clusterAuthValidator;
    private AuthValidator _namespaceAuthValidator;
    private Map<String, ResourceConfig> _resourceConfigMap;

    public HelixRestServer(String zkAddr, int port, String urlPrefix) {
        this(zkAddr, port, urlPrefix, Collections.emptyList());
    }

    public HelixRestServer(String zkAddr, int port, String urlPrefix, List<AuditLogger> auditLoggers) {
        ArrayList<HelixRestNamespace> namespaces = new ArrayList<HelixRestNamespace>();
        namespaces.add(new HelixRestNamespace("default", HelixRestNamespace.HelixMetadataStoreType.ZOOKEEPER, zkAddr, true));
        this.init(namespaces, port, urlPrefix, auditLoggers);
    }

    public HelixRestServer(List<HelixRestNamespace> namespaces, int port, String urlPrefix, List<AuditLogger> auditLoggers) {
        this.init(namespaces, port, urlPrefix, auditLoggers);
    }

    public HelixRestServer(List<HelixRestNamespace> namespaces, int port, String urlPrefix, List<AuditLogger> auditLoggers, AuthValidator clusterAuthValidator, AuthValidator namespaceAuthValidator) {
        this.init(namespaces, port, urlPrefix, auditLoggers, clusterAuthValidator, namespaceAuthValidator);
    }

    private void init(List<HelixRestNamespace> namespaces, int port, String urlPrefix, List<AuditLogger> auditLoggers) {
        this.init(namespaces, port, urlPrefix, auditLoggers, new NoopAuthValidator(), new NoopAuthValidator());
    }

    private void init(List<HelixRestNamespace> namespaces, int port, String urlPrefix, List<AuditLogger> auditLoggers, AuthValidator clusterAuthValidator, AuthValidator namespaceAuthValidator) {
        if (namespaces.size() == 0) {
            throw new IllegalArgumentException("No namespace specified! Please provide ZOOKEEPER address or namespace manifest.");
        }
        this._port = port;
        this._urlPrefix = urlPrefix;
        this._server = new Server(this._port);
        this._jmxReporterList = new ArrayList<JmxReporter>();
        this._auditLoggers = auditLoggers;
        this._resourceConfigMap = new HashMap<String, ResourceConfig>();
        this._servletContextHandler = new ServletContextHandler((HandlerContainer)this._server, this._urlPrefix);
        this._helixNamespaces = namespaces;
        this._clusterAuthValidator = clusterAuthValidator;
        this._namespaceAuthValidator = namespaceAuthValidator;
        try {
            for (HelixRestNamespace namespace : this._helixNamespaces) {
                if (namespace.isDefault()) {
                    LOG.info("Creating default servlet for default namespace");
                    this.prepareServlet(namespace, ServletType.DEFAULT_SERVLET);
                    continue;
                }
                LOG.info("Creating common servlet for namespace {}", (Object)namespace.getName());
                this.prepareServlet(namespace, ServletType.COMMON_SERVLET);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize helix rest server. Tearing down.");
            this.cleanupResourceConfigs();
            throw e;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                HelixRestServer.this.shutdown();
            }
        }));
    }

    private void prepareServlet(HelixRestNamespace namespace, ServletType type) {
        String resourceConfigMapKey = this.getResourceConfigMapKey(type, namespace);
        if (this._resourceConfigMap.containsKey(resourceConfigMapKey)) {
            throw new IllegalArgumentException(String.format("Duplicated namespace name \"%s\"", namespace.getName()));
        }
        ResourceConfig config = this.getResourceConfig(namespace, type);
        this._resourceConfigMap.put(resourceConfigMapKey, config);
        this.initMetricRegistry(config, namespace.getName());
        this.initServlet(config, String.format(type.getServletPathSpecTemplate(), namespace.getName()));
    }

    private String getResourceConfigMapKey(ServletType type, HelixRestNamespace namespace) {
        return String.format("%s_%s", type.name(), namespace.getName());
    }

    protected ResourceConfig getResourceConfig(HelixRestNamespace namespace, ServletType type) {
        ResourceConfig cfg = new ResourceConfig();
        cfg.packages(type.getServletPackageArray());
        cfg.setApplicationName(namespace.getName());
        cfg.property(ContextPropertyKeys.SERVER_CONTEXT.name(), (Object)new ServerContext(namespace.getMetadataStoreAddress(), namespace.isMultiZkEnabled(), namespace.getMsdsEndpoint()));
        if (type == ServletType.DEFAULT_SERVLET) {
            cfg.property(ContextPropertyKeys.ALL_NAMESPACES.name(), this._helixNamespaces);
        }
        cfg.property(ContextPropertyKeys.METADATA.name(), (Object)namespace);
        if (Boolean.getBoolean(CORS_ENABLED)) {
            cfg.register((Object)new CORSFilter());
        }
        cfg.register((Object)new AuditLogFilter(this._auditLoggers));
        cfg.register((Object)new ClusterAuthFilter(this._clusterAuthValidator));
        cfg.register((Object)new NamespaceAuthFilter(this._namespaceAuthValidator));
        return cfg;
    }

    private void initMetricRegistry(ResourceConfig cfg, String namespace) {
        MetricRegistry metricRegistry = new MetricRegistry();
        Supplier<Reservoir> reservoirSupplier = () -> new SlidingTimeWindowReservoir(60L, TimeUnit.SECONDS);
        cfg.register((Object)new InstrumentedResourceMethodApplicationListener(metricRegistry, Clock.defaultClock(), false, reservoirSupplier));
        SharedMetricRegistries.add((String)namespace, (MetricRegistry)metricRegistry);
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain(REST_DOMAIN).createsObjectNamesWith((ObjectNameFactory)new HelixRestObjectNameFactory(namespace)).build();
        jmxReporter.start();
        this._jmxReporterList.add(jmxReporter);
    }

    private void initServlet(ResourceConfig cfg, String servletPathSpec) {
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(cfg));
        this._servletContextHandler.addServlet(servlet, servletPathSpec);
    }

    public void start() throws HelixException, InterruptedException {
        try {
            this._server.start();
        }
        catch (Exception ex) {
            LOG.error("Failed to start Helix rest server, " + ex);
            throw new HelixException("Failed to start Helix rest server! " + ex);
        }
        LOG.info("Helix rest server started!");
    }

    public void join() {
        if (this._server != null) {
            try {
                this._server.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Join on Helix rest server get interrupted!" + e);
            }
        }
    }

    public synchronized void shutdown() {
        if (this._server != null) {
            try {
                this._server.stop();
                LOG.info("Helix rest server stopped!");
            }
            catch (Exception ex) {
                LOG.error("Failed to stop Helix rest server, " + ex);
            }
        }
        this._jmxReporterList.forEach(JmxReporter::stop);
        this._jmxReporterList.clear();
        this.cleanupResourceConfigs();
    }

    private void cleanupResourceConfigs() {
        for (Map.Entry<String, ResourceConfig> e : this._resourceConfigMap.entrySet()) {
            ServerContext ctx = (ServerContext)e.getValue().getProperty(ContextPropertyKeys.SERVER_CONTEXT.name());
            if (ctx == null) {
                LOG.info("Server context for servlet " + e.getKey() + " is null.");
                continue;
            }
            LOG.info("Closing context for servlet " + e.getKey());
            ctx.close();
        }
    }

    public void setupSslServer(int port, SslContextFactory sslContextFactory) {
        if (this._server != null && port > 0) {
            try {
                HttpConfiguration https = new HttpConfiguration();
                https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                ServerConnector sslConnector = new ServerConnector(this._server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https)});
                sslConnector.setPort(port);
                this._server.addConnector((Connector)sslConnector);
                LOG.info("Helix SSL rest server is ready to start.");
            }
            catch (Exception ex) {
                LOG.error("Failed to setup Helix SSL rest server, " + ex);
            }
        }
    }

    public void registerServerSSLContext(SSLContext sslContext) {
        REST_SERVER_SSL_CONTEXT = sslContext;
    }
}

