/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.AbstractDataSnapshot;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.controller.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataCache<T extends HelixProperty> {
    private static Logger LOG = LoggerFactory.getLogger((String)AbstractDataCache.class.getName());
    public static final String UNKNOWN_CLUSTER = "UNKNOWN_CLUSTER";
    public static final String UNKNOWN_EVENT_ID = "NO_ID";
    public static final String UNKNOWN_PIPELINE = "UNKNOWN_PIPELINE";
    protected ControlContextProvider _controlContextProvider;

    public AbstractDataCache(ControlContextProvider controlContextProvider) {
        this._controlContextProvider = controlContextProvider;
    }

    protected Map<PropertyKey, T> refreshProperties(HelixDataAccessor accessor, Set<PropertyKey> reloadKeysIn, List<PropertyKey> cachedKeys, Map<PropertyKey, T> cachedPropertyMap, Set<PropertyKey> reloadedKeys) {
        ArrayList<PropertyKey> reloadKeys = new ArrayList<PropertyKey>(reloadKeysIn);
        HashMap refreshedPropertyMap = Maps.newHashMap();
        List<HelixProperty.Stat> stats = accessor.getPropertyStats(cachedKeys);
        for (int i = 0; i < cachedKeys.size(); ++i) {
            PropertyKey key = cachedKeys.get(i);
            HelixProperty.Stat stat = stats.get(i);
            if (stat != null) {
                HelixProperty property = (HelixProperty)cachedPropertyMap.get(key);
                if (property != null && property.getBucketSize() == 0 && property.getStat().equals(stat)) {
                    refreshedPropertyMap.put(key, property);
                    continue;
                }
                reloadKeys.add(key);
                continue;
            }
            LOG.warn("stat is null for key: " + key);
            reloadKeys.add(key);
        }
        reloadedKeys.clear();
        reloadedKeys.addAll(reloadKeys);
        List reloadedProperty = accessor.getProperty(reloadKeys, true);
        Iterator csKeyIter = reloadKeys.iterator();
        for (HelixProperty property : reloadedProperty) {
            PropertyKey key = (PropertyKey)csKeyIter.next();
            if (property != null) {
                refreshedPropertyMap.put(key, property);
                continue;
            }
            LOG.warn("znode is null for key: " + key);
        }
        LogUtil.logInfo(LOG, this.genEventInfo(), String.format("%s properties refreshed from ZK.", reloadKeys.size()));
        LOG.debug("refreshed keys: {}", reloadKeys);
        return refreshedPropertyMap;
    }

    protected String genEventInfo() {
        return String.format("%s::%s::%s", this._controlContextProvider.getClusterName(), this._controlContextProvider.getPipelineName(), this._controlContextProvider.getClusterEventId());
    }

    public AbstractDataSnapshot getSnapshot() {
        throw new HelixException(String.format("DataCache %s does not support generating snapshot.", this.getClass().getSimpleName()));
    }

    protected static ControlContextProvider createDefaultControlContextProvider(final String clusterName) {
        return new ControlContextProvider(){
            private String _clusterName;
            private String _eventId;
            {
                this._clusterName = clusterName;
                this._eventId = AbstractDataCache.UNKNOWN_EVENT_ID;
            }

            @Override
            public String getClusterName() {
                return this._clusterName;
            }

            @Override
            public String getClusterEventId() {
                return this._eventId;
            }

            @Override
            public void setClusterEventId(String eventId) {
                this._eventId = eventId;
            }

            @Override
            public String getPipelineName() {
                return AbstractDataCache.UNKNOWN_PIPELINE;
            }
        };
    }
}

