/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.github.benmanes.caffeine.cache.Ticker;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;

public class HMSCachingCatalog
extends CachingCatalog
implements SupportsNamespaces,
ViewCatalog {
    private final HiveCatalog hiveCatalog;

    public HMSCachingCatalog(HiveCatalog catalog, long expiration) {
        super((Catalog)catalog, true, expiration, Ticker.systemTicker());
        this.hiveCatalog = catalog;
    }

    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return this.hiveCatalog.buildTable(identifier, schema);
    }

    public void createNamespace(Namespace nmspc, Map<String, String> map) {
        this.hiveCatalog.createNamespace(nmspc, map);
    }

    public List<Namespace> listNamespaces(Namespace nmspc) throws NoSuchNamespaceException {
        return this.hiveCatalog.listNamespaces(nmspc);
    }

    public Map<String, String> loadNamespaceMetadata(Namespace nmspc) throws NoSuchNamespaceException {
        return this.hiveCatalog.loadNamespaceMetadata(nmspc);
    }

    public boolean dropNamespace(Namespace nmspc) throws NamespaceNotEmptyException {
        List tables = this.listTables(nmspc);
        for (TableIdentifier ident : tables) {
            this.invalidateTable(ident);
        }
        return this.hiveCatalog.dropNamespace(nmspc);
    }

    public boolean setProperties(Namespace nmspc, Map<String, String> map) throws NoSuchNamespaceException {
        return this.hiveCatalog.setProperties(nmspc, map);
    }

    public boolean removeProperties(Namespace nmspc, Set<String> set) throws NoSuchNamespaceException {
        return this.hiveCatalog.removeProperties(nmspc, set);
    }

    public boolean namespaceExists(Namespace namespace) {
        return this.hiveCatalog.namespaceExists(namespace);
    }

    public List<TableIdentifier> listViews(Namespace namespace) {
        return this.hiveCatalog.listViews(namespace);
    }

    public View loadView(TableIdentifier identifier) {
        return this.hiveCatalog.loadView(identifier);
    }

    public boolean viewExists(TableIdentifier identifier) {
        return this.hiveCatalog.viewExists(identifier);
    }

    public ViewBuilder buildView(TableIdentifier identifier) {
        return this.hiveCatalog.buildView(identifier);
    }

    public boolean dropView(TableIdentifier identifier) {
        return this.hiveCatalog.dropView(identifier);
    }

    public void renameView(TableIdentifier from, TableIdentifier to) {
        this.hiveCatalog.renameView(from, to);
    }

    public void invalidateView(TableIdentifier identifier) {
        this.hiveCatalog.invalidateView(identifier);
    }

    public void initialize(String name, Map<String, String> properties) {
        this.hiveCatalog.initialize(name, properties);
    }
}

