/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.client.utils.HiveMetaStoreClientUtils;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;

public abstract class BaseMetaStoreClient
implements IMetaStoreClient {
    protected final Configuration conf;

    public BaseMetaStoreClient(Configuration conf) {
        this.conf = conf == null ? (conf = MetastoreConf.newMetastoreConf()) : new Configuration(conf);
    }

    @Override
    public final void dropCatalog(String catName) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropCatalog(catName, true);
    }

    @Override
    public final List<String> getDatabases(String databasePattern) throws MetaException, TException {
        return this.getDatabases(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), databasePattern);
    }

    @Override
    public final List<String> getAllDatabases() throws MetaException, TException {
        return this.getAllDatabases(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
    }

    @Override
    public final List<String> getTables(String dbName, String tablePattern) throws MetaException, TException, UnknownDBException {
        try {
            return this.getTables(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tablePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    @Override
    public final List<String> getTables(String dbName, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        try {
            return this.getTables(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tablePattern, tableType);
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    @Override
    public final List<String> getMaterializedViewsForRewriting(String dbName) throws MetaException, TException, UnknownDBException {
        return this.getMaterializedViewsForRewriting(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName);
    }

    @Override
    public final List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException {
        return this.getTableMeta(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbPatterns, tablePatterns, tableTypes);
    }

    @Override
    public final List<String> getAllTables(String dbName) throws MetaException, TException, UnknownDBException {
        return this.getAllTables(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName);
    }

    @Override
    public final List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws TException, InvalidOperationException, UnknownDBException {
        return this.listTableNamesByFilter(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, filter, maxTables);
    }

    @Override
    public final void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbname, tableName, deleteData, ignoreUnknownTab, false);
    }

    @Override
    public final void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws MetaException, TException, NoSuchObjectException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbname, tableName, deleteData, ignoreUnknownTab, ifPurge);
    }

    @Override
    public final void dropTable(String dbname, String tableName) throws MetaException, TException, NoSuchObjectException {
        this.dropTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbname, tableName, true, true, false);
    }

    @Override
    public final void dropTable(String catName, String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws MetaException, NoSuchObjectException, TException {
        Table table;
        try {
            table = this.getTable(catName, dbName, tableName);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTable) {
                throw e;
            }
            return;
        }
        this.dropTable(table, deleteData, ignoreUnknownTable, ifPurge);
    }

    @Override
    public final void truncateTable(String dbName, String tableName, List<String> partNames) throws MetaException, TException {
        this.truncateTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, null, partNames, null, -1L, true, null);
    }

    @Override
    public final void truncateTable(TableName table, List<String> partNames) throws TException {
        this.truncateTable(table.getCat(), table.getDb(), table.getTable(), table.getTableMetaRef(), partNames, null, -1L, true, null);
    }

    @Override
    public final void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId) throws TException {
        this.truncateTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, null, partNames, validWriteIds, writeId, true, null);
    }

    @Override
    public final void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId, boolean deleteData) throws TException {
        this.truncateTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, null, partNames, validWriteIds, writeId, deleteData, null);
    }

    @Override
    public final boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), databaseName, tableName);
    }

    @Override
    public final Database getDatabase(String databaseName) throws NoSuchObjectException, MetaException, TException {
        return this.getDatabase(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), databaseName);
    }

    @Override
    public final Table getTable(String dbName, String tableName) throws MetaException, TException, NoSuchObjectException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        return this.getTable(req);
    }

    @Override
    public final Table getTable(String dbName, String tableName, boolean getColumnStats, String engine) throws MetaException, TException, NoSuchObjectException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        req.setGetColumnStats(getColumnStats);
        if (getColumnStats) {
            req.setEngine(engine);
        }
        return this.getTable(req);
    }

    @Override
    public final Table getTable(String catName, String dbName, String tableName) throws MetaException, TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(catName);
        return this.getTable(req);
    }

    @Override
    public final Table getTable(String catName, String dbName, String tableName, String validWriteIdList, boolean getColumnStats, String engine) throws TException {
        GetTableRequest req = new GetTableRequest(dbName, tableName);
        req.setCatName(catName);
        req.setValidWriteIdList(validWriteIdList);
        req.setGetColumnStats(getColumnStats);
        if (getColumnStats) {
            req.setEngine(engine);
        }
        return this.getTable(req);
    }

    @Override
    public final List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        return this.getTables(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableNames, null);
    }

    @Override
    public final List<Table> getTableObjectsByName(String catName, String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        return this.getTables(catName, dbName, tableNames, null);
    }

    @Override
    public final void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws MetaException, TException {
        this.updateCreationMetadata(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, cm);
    }

    @Override
    public final Partition appendPartition(String dbName, String tableName, List<String> partVals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, partVals);
    }

    @Override
    public final Partition appendPartition(String dbName, String tableName, String name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, name);
    }

    @Override
    public final int add_partitions(List<Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.add_partitions(partitions, false, true).size();
    }

    @Override
    public final Partition getPartition(String dbName, String tblName, List<String> partVals) throws NoSuchObjectException, MetaException, TException {
        return this.getPartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, partVals);
    }

    @Override
    public final Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        String catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        return this.exchange_partition(partitionSpecs, catName, sourceDb, sourceTable, catName, destdb, destTableName);
    }

    @Override
    public final List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        String catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        return this.exchange_partitions(partitionSpecs, catName, sourceDb, sourceTable, catName, destdb, destTableName);
    }

    @Override
    public final Partition getPartition(String dbName, String tblName, String name) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.getPartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, name);
    }

    @Override
    public final Partition getPartitionWithAuthInfo(String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.getPartitionWithAuthInfo(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, pvals, userName, groupNames);
    }

    @Override
    public final List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, (int)max_parts);
    }

    @Override
    public final PartitionSpecProxy listPartitionSpecs(String dbName, String tableName, int maxParts) throws TException {
        return this.listPartitionSpecs(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, maxParts);
    }

    @Override
    public final List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, part_vals, max_parts);
    }

    @Override
    public final List<String> listPartitionNames(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitionNames(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, (int)max_parts);
    }

    @Override
    public final List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
        if (db_name == null || tbl_name == null) {
            throw new MetaException("DbName/TableName cannot be null");
        }
        GetPartitionNamesPsRequest getPartitionNamesPsRequest = new GetPartitionNamesPsRequest(db_name, tbl_name);
        getPartitionNamesPsRequest.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        getPartitionNamesPsRequest.setPartValues(part_vals);
        getPartitionNamesPsRequest.setMaxParts(HiveMetaStoreClientUtils.shrinkMaxtoShort(max_parts));
        return this.listPartitionNamesRequest(getPartitionNamesPsRequest).getNames();
    }

    @Override
    public final List<String> listPartitionNames(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws MetaException, TException, NoSuchObjectException {
        if (db_name == null || tbl_name == null) {
            throw new MetaException("DbName/TableName cannot be null");
        }
        GetPartitionNamesPsRequest getPartitionNamesPsRequest = new GetPartitionNamesPsRequest(db_name, tbl_name);
        getPartitionNamesPsRequest.setCatName(catName);
        getPartitionNamesPsRequest.setPartValues(part_vals);
        getPartitionNamesPsRequest.setMaxParts(HiveMetaStoreClientUtils.shrinkMaxtoShort(max_parts));
        return this.listPartitionNamesRequest(getPartitionNamesPsRequest).getNames();
    }

    @Override
    public final int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        return this.getNumPartitionsByFilter(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, filter);
    }

    @Override
    public final List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException, NoSuchObjectException, TException {
        return this.listPartitionsByFilter(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, filter, max_parts);
    }

    @Override
    public final PartitionSpecProxy listPartitionSpecsByFilter(String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        return this.listPartitionSpecsByFilter(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, filter, max_parts);
    }

    @Override
    public final boolean listPartitionsByExpr(String db_name, String tbl_name, byte[] expr, String default_partition_name, short max_parts, List<Partition> result) throws TException {
        PartitionsByExprRequest req = new PartitionsByExprRequest(db_name, tbl_name, ByteBuffer.wrap(expr));
        req.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        req.setDefaultPartitionName(default_partition_name);
        if (max_parts >= 0) {
            req.setMaxParts(HiveMetaStoreClientUtils.shrinkMaxtoShort(max_parts));
        }
        return this.listPartitionsByExpr(req, result);
    }

    @Override
    public final boolean listPartitionsByExpr(String catName, String db_name, String tbl_name, byte[] expr, String default_partition_name, int max_parts, List<Partition> result) throws TException {
        PartitionsByExprRequest req = new PartitionsByExprRequest(db_name, tbl_name, ByteBuffer.wrap(expr));
        req.setCatName(catName);
        req.setDefaultPartitionName(default_partition_name);
        if (max_parts >= 0) {
            req.setMaxParts(HiveMetaStoreClientUtils.shrinkMaxtoShort(max_parts));
        }
        return this.listPartitionsByExpr(req, result);
    }

    @Override
    public final List<Partition> listPartitionsWithAuthInfo(String dbName, String tableName, short maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        return this.listPartitionsWithAuthInfo(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, (int)maxParts, userName, groupNames);
    }

    @Override
    public final List<Partition> getPartitionsByNames(String dbName, String tableName, List<String> partNames) throws NoSuchObjectException, MetaException, TException {
        GetPartitionsByNamesRequest req = MetaStoreUtils.convertToGetPartitionsByNamesRequest((String)MetaStoreUtils.prependCatalogToDbName((String)MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), (String)dbName, (Configuration)this.conf), (String)tableName, partNames);
        return this.getPartitionsByNames(req).getPartitions();
    }

    @Override
    public final List<Partition> listPartitionsWithAuthInfo(String dbName, String tableName, List<String> partialPvals, short maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        return this.listPartitionsWithAuthInfo(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, partialPvals, maxParts, userName, groupNames);
    }

    @Override
    public final void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        this.markPartitionForEvent(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public final boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        return this.isPartitionMarkedForEvent(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, partKVs, eventType);
    }

    @Override
    public final void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.createTable(new CreateTableRequest(tbl));
    }

    @Override
    public final void alter_table(String databaseName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        this.alter_table(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), databaseName, tblName, table, null, null);
    }

    @Override
    public final void alter_table(String catName, String dbName, String tblName, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        this.alter_table(catName, dbName, tblName, newTable, envContext, null);
    }

    @Override
    public final void alter_table(String databaseName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        if (cascade) {
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.alter_table(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), databaseName, tblName, table, environmentContext, null);
    }

    @Override
    public final void alter_table_with_environmentContext(String databaseName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.alter_table(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), databaseName, tblName, table, environmentContext, null);
    }

    @Override
    public final void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        DropDatabaseRequest req = new DropDatabaseRequest();
        req.setName(name);
        req.setCatalogName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        req.setIgnoreUnknownDb(false);
        req.setDeleteData(true);
        req.setCascade(false);
        this.dropDatabase(req);
    }

    @Override
    public final void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        DropDatabaseRequest req = new DropDatabaseRequest();
        req.setName(name);
        req.setCatalogName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        req.setIgnoreUnknownDb(ignoreUnknownDb);
        req.setDeleteData(deleteData);
        req.setCascade(false);
        this.dropDatabase(req);
    }

    @Override
    public final void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        DropDatabaseRequest req = new DropDatabaseRequest();
        req.setName(name);
        req.setCatalogName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        req.setIgnoreUnknownDb(ignoreUnknownDb);
        req.setDeleteData(deleteData);
        req.setCascade(cascade);
        this.dropDatabase(req);
    }

    @Override
    public final void alterDatabase(String name, Database db) throws NoSuchObjectException, MetaException, TException {
        this.alterDatabase(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), name, db);
    }

    @Override
    public final boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    @Override
    public final boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(catName, db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    @Override
    public final boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, part_vals, options);
    }

    @Override
    public final List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        PartitionDropOptions options = PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists);
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, partExprs, options, null);
    }

    @Override
    public final List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, partExprs, options, null);
    }

    @Override
    public final List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(catName, dbName, tblName, partExprs, options, null);
    }

    @Override
    public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options, EnvironmentContext context) throws NoSuchObjectException, MetaException, TException {
        RequestPartsSpec rps = new RequestPartsSpec();
        ArrayList<DropPartitionsExpr> exprs = new ArrayList<DropPartitionsExpr>(partExprs.size());
        for (Pair<Integer, byte[]> partExpr : partExprs) {
            DropPartitionsExpr dpe = new DropPartitionsExpr();
            dpe.setExpr((byte[])partExpr.getRight());
            dpe.setPartArchiveLevel(((Integer)partExpr.getLeft()).intValue());
            exprs.add(dpe);
        }
        rps.setExprs(exprs);
        return this.dropPartitions(new TableName(catName, dbName, tblName), rps, options, context);
    }

    @Override
    public final boolean dropPartition(String db_name, String tbl_name, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db_name, tbl_name, name, deleteData);
    }

    @Override
    public final void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, newPart, null, null);
    }

    @Override
    public final void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, newPart, environmentContext, null);
    }

    @Override
    public final void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(catName, dbName, tblName, newPart, environmentContext, null);
    }

    @Override
    public final void alter_partitions(String dbName, String tblName, List<Partition> newParts) throws InvalidOperationException, MetaException, TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, newParts, null, null, -1L);
    }

    @Override
    public final void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, newParts, environmentContext, null, -1L);
    }

    @Override
    public final void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws InvalidOperationException, MetaException, TException {
        this.alter_partitions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, newParts, environmentContext, writeIdList, writeId);
    }

    @Override
    public final void renamePartition(String dbname, String tableName, List<String> part_vals, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.renamePartition(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbname, tableName, part_vals, newPart, null);
    }

    @Override
    public final List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.getFields(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db, tableName);
    }

    @Override
    public final List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.getSchema(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), db, tableName);
    }

    @Override
    public final List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        return this.getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, colNames, engine, null);
    }

    @Override
    public final List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        return this.getTableColumnStatistics(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, colNames, engine, validWriteIdList);
    }

    @Override
    public final List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        return this.getTableColumnStatistics(catName, dbName, tableName, colNames, engine, null);
    }

    @Override
    public final Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        return this.getPartitionColumnStatistics(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, partNames, colNames, engine, null);
    }

    @Override
    public final Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        return this.getPartitionColumnStatistics(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, partNames, colNames, engine, validWriteIdList);
    }

    @Override
    public final Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        return this.getPartitionColumnStatistics(catName, dbName, tableName, partNames, colNames, engine, null);
    }

    @Override
    public final void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.alterFunction(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, funcName, newFunction);
    }

    @Override
    public final void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.dropFunction(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, funcName);
    }

    @Override
    public final Function getFunction(String dbName, String funcName) throws MetaException, TException {
        return this.getFunction(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, funcName);
    }

    @Override
    public final List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        return this.getFunctions(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, pattern);
    }

    @Override
    public final ValidTxnList getValidTxns() throws TException {
        return this.getValidTxns(0L, Arrays.asList(TxnType.READ_ONLY));
    }

    @Override
    public final ValidTxnList getValidTxns(long currentTxn) throws TException {
        return this.getValidTxns(currentTxn, Arrays.asList(TxnType.READ_ONLY));
    }

    @Override
    public final long openTxn(String user) throws TException {
        return this.openTxn(user, null);
    }

    @Override
    public final void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
        this.rollbackTxn(new AbortTxnRequest(txnid));
    }

    @Override
    public final void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
        this.commitTxn(new CommitTxnRequest(txnid));
    }

    @Override
    public final void abortTxns(List<Long> txnids) throws TException {
        AbortTxnsRequest abortTxnsRequest = new AbortTxnsRequest(txnids);
        this.abortTxns(abortTxnsRequest);
    }

    @Override
    public final long allocateTableWriteId(long txnId, String dbName, String tableName) throws TException {
        return this.allocateTableWriteId(txnId, dbName, tableName, false);
    }

    @Override
    public final ShowCompactResponse showCompactions() throws TException {
        return this.showCompactions(new ShowCompactRequest());
    }

    @Override
    public final NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws TException {
        NotificationEventRequest req = new NotificationEventRequest(lastEventId);
        req.setMaxEvents(maxEvents);
        return this.getNextNotification(req, false, filter);
    }

    @Override
    public final AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName, String engine) throws NoSuchObjectException, MetaException, TException {
        return this.getAggrColStatsFor(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, colNames, partName, engine);
    }

    @Override
    public final AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName, String engine, String writeIdList) throws NoSuchObjectException, MetaException, TException {
        return this.getAggrColStatsFor(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName, colNames, partName, engine, writeIdList);
    }

    @Override
    public final void dropConstraint(String dbName, String tableName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        this.dropConstraint(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName, constraintName);
    }
}

