/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.MethodUtils;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluatorResolver;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class DefaultUDAFEvaluatorResolver
implements UDAFEvaluatorResolver {
    private final Class<? extends UDAF> udafClass;

    public DefaultUDAFEvaluatorResolver(Class<? extends UDAF> udafClass) {
        this.udafClass = udafClass;
    }

    @Override
    public Class<? extends UDAFEvaluator> getEvaluatorClass(List<TypeInfo> argClasses) throws UDFArgumentException {
        int n;
        ArrayList classList = new ArrayList();
        for (Class<?> clazz : this.udafClass.getClasses()) {
            if (!UDAFEvaluator.class.isAssignableFrom(clazz)) continue;
            classList.add(clazz);
        }
        ArrayList<Method> mList = new ArrayList<Method>();
        ArrayList<Class> cList = new ArrayList<Class>();
        for (Class clazz : classList) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equalsIgnoreCase("iterate")) continue;
                mList.add(m);
                cList.add(clazz);
            }
        }
        Method m = MethodUtils.getMethodInternal(this.udafClass, mList, false, argClasses);
        int n2 = -1;
        for (int i = 0; i < mList.size(); ++i) {
            if (mList.get(i) != m) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            throw new AmbiguousMethodException(this.udafClass, argClasses, mList);
        }
        assert (n != -1);
        return (Class)cList.get(n);
    }
}

