/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.show;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.catalog.show.ShowCatalogsDesc;
import org.apache.hadoop.hive.ql.ddl.catalog.show.ShowCatalogsFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.io.IOUtils;

public class ShowCatalogsOperation
extends DDLOperation<ShowCatalogsDesc> {
    public ShowCatalogsOperation(DDLOperationContext context, ShowCatalogsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        List<String> catalogs = this.context.getDb().getMSC().getCatalogs();
        if (((ShowCatalogsDesc)this.desc).getPattern() != null) {
            LOG.debug("pattern: {}", (Object)((ShowCatalogsDesc)this.desc).getPattern());
            Pattern pattern = Pattern.compile(UDFLike.likePatternToRegExp(((ShowCatalogsDesc)this.desc).getPattern()), 2);
            catalogs = catalogs.stream().filter(name -> pattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
        }
        LOG.info("Found {} catalog(s) matching the SHOW CATALOGS statement.", (Object)catalogs.size());
        DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((ShowCatalogsDesc)this.desc).getResFile()), this.context);
        try {
            ShowCatalogsFormatter formatter = ShowCatalogsFormatter.getFormatter(this.context.getConf());
            formatter.showCatalogs(outStream, catalogs);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"show catalogs"});
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }
}

