/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.alter;

import java.util.Map;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.dataconnector.alter.AbstractAlterDataConnectorDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class AbstractAlterDataConnectorOperation<T extends AbstractAlterDataConnectorDesc>
extends DDLOperation<T> {
    public AbstractAlterDataConnectorOperation(DDLOperationContext context, T desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String dcName = ((AbstractAlterDataConnectorDesc)this.desc).getConnectorName();
        DataConnector connector = this.context.getDb().getDataConnector(dcName);
        if (connector == null) {
            throw new HiveException(ErrorMsg.DATACONNECTOR_NOT_EXISTS, new String[]{dcName});
        }
        Map params = connector.getParameters();
        this.doAlteration(connector);
        this.context.getDb().alterDataConnector(connector.getName(), connector);
        return 0;
    }

    protected abstract void doAlteration(DataConnector var1) throws HiveException;
}

