/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.alter.url;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.dataconnector.alter.AbstractAlterDataConnectorOperation;
import org.apache.hadoop.hive.ql.ddl.dataconnector.alter.url.AlterDataConnectorSetUrlDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AlterDataConnectorSetUrlOperation
extends AbstractAlterDataConnectorOperation<AlterDataConnectorSetUrlDesc> {
    public AlterDataConnectorSetUrlOperation(DDLOperationContext context, AlterDataConnectorSetUrlDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(DataConnector connector) throws HiveException {
        try {
            String newUrl = ((AlterDataConnectorSetUrlDesc)this.desc).getURL();
            if (StringUtils.isBlank((CharSequence)newUrl) || newUrl.equals(connector.getUrl())) {
                throw new HiveException("New URL for data connector cannot be blank or the same as the current one");
            }
            URI newURI = new URI(newUrl);
            if (!newURI.isAbsolute() || StringUtils.isBlank((CharSequence)newURI.getScheme())) {
                throw new HiveException(ErrorMsg.INVALID_PATH, new String[]{newUrl});
            }
            connector.setUrl(newUrl);
            return;
        }
        catch (URISyntaxException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

