/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.desc;

import java.io.DataOutputStream;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.dataconnector.desc.DescDataConnectorDesc;
import org.apache.hadoop.hive.ql.ddl.dataconnector.desc.DescDataConnectorFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class DescDataConnectorOperation
extends DDLOperation<DescDataConnectorDesc> {
    public DescDataConnectorOperation(DDLOperationContext context, DescDataConnectorDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        try (DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((DescDataConnectorDesc)this.desc).getResFile()), this.context);){
            DataConnector connector = this.context.getDb().getDataConnector(((DescDataConnectorDesc)this.desc).getConnectorName());
            if (connector == null) {
                throw new HiveException(ErrorMsg.DATACONNECTOR_NOT_EXISTS, new String[]{((DescDataConnectorDesc)this.desc).getConnectorName()});
            }
            TreeMap<String, String> params = null;
            if (((DescDataConnectorDesc)this.desc).isExtended()) {
                params = new TreeMap<String, String>(connector.getParameters());
            }
            DescDataConnectorFormatter formatter = DescDataConnectorFormatter.getFormatter(this.context.getConf());
            formatter.showDataConnectorDescription(outStream, connector.getName(), connector.getType(), connector.getUrl(), connector.getOwnerName(), connector.getOwnerType(), connector.getDescription(), params);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }
}

