/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.create;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Function", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateFunctionDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String className;
    private final boolean isTemporary;
    private final List<ResourceUri> resources;
    private final ReplicationSpec replicationSpec;

    public CreateFunctionDesc(String name, String className, boolean isTemporary, List<ResourceUri> resources, ReplicationSpec replicationSpec) {
        this.name = name;
        this.className = className;
        this.isTemporary = isTemporary;
        this.resources = resources;
        this.replicationSpec = replicationSpec == null ? new ReplicationSpec() : replicationSpec;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getName() {
        return this.name;
    }

    @Explain(displayName="class", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getClassName() {
        return this.className;
    }

    @Explain(displayName="temporary", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isTemp() {
        return this.isTemporary;
    }

    public List<ResourceUri> getResources() {
        return this.resources;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }
}

