/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.process.abort.compaction;

import java.util.ArrayList;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.process.abort.compaction.AbortCompactionsDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={836})
public class AbortCompactionsAnalyzer
extends BaseSemanticAnalyzer {
    public AbortCompactionsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        ArrayList<Long> compactionIds = new ArrayList<Long>();
        for (Node child : root.getChildren()) {
            compactionIds.add(Long.parseLong(((Tree)child).getText()));
        }
        AbortCompactionsDesc desc = new AbortCompactionsDesc(this.ctx.getResFile(), compactionIds);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

