/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.change;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableWithConstraintsDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Change Column", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableChangeColumnDesc
extends AbstractAlterTableWithConstraintsDesc {
    private static final long serialVersionUID = 1L;
    private final String oldColumnName;
    private final String newColumnName;
    private final String newColumnType;
    private final String newColumnComment;
    private final boolean first;
    private final String afterColumn;

    public AlterTableChangeColumnDesc(TableName tableName, Map<String, String> partitionSpec, boolean isCascade, Constraints constraints, String oldColumnName, String newColumnName, String newColumnType, String newColumnComment, boolean first, String afterColumn) throws SemanticException {
        super(AlterTableType.RENAME_COLUMN, tableName, partitionSpec, null, isCascade, false, null, constraints);
        this.oldColumnName = oldColumnName;
        this.newColumnName = newColumnName;
        this.newColumnType = newColumnType;
        this.newColumnComment = newColumnComment;
        this.first = first;
        this.afterColumn = afterColumn;
    }

    @Explain(displayName="old column name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOldColumnName() {
        return this.oldColumnName;
    }

    @Explain(displayName="new column name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getNewColumnName() {
        return this.newColumnName;
    }

    @Explain(displayName="new column type", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getNewColumnType() {
        return this.newColumnType;
    }

    @Explain(displayName="new column comment", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getNewColumnComment() {
        return this.newColumnComment;
    }

    @Explain(displayName="first", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isFirst() {
        return this.first;
    }

    @Explain(displayName="after column", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getAfterColumn() {
        return this.afterColumn;
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

