/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.properties;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Set Properties", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableSetPropertiesDesc
extends AbstractAlterTableDesc {
    private static final long serialVersionUID = 1L;
    private final boolean isExplicitStatsUpdate;
    private final boolean isFullAcidConversion;
    private final EnvironmentContext environmentContext;

    public AlterTableSetPropertiesDesc(TableName tableName, Map<String, String> partitionSpec, ReplicationSpec replicationSpec, boolean expectView, Map<String, String> props, boolean isExplicitStatsUpdate, boolean isFullAcidConversion, EnvironmentContext environmentContext) throws SemanticException {
        super(AlterTableType.ADDPROPS, tableName, partitionSpec, replicationSpec, false, expectView, props);
        this.isExplicitStatsUpdate = isExplicitStatsUpdate;
        this.isFullAcidConversion = isFullAcidConversion;
        this.environmentContext = environmentContext;
    }

    @Override
    public EnvironmentContext getEnvironmentContext() {
        return this.environmentContext;
    }

    @Override
    public boolean mayNeedWriteId() {
        return this.isExplicitStatsUpdate || AcidUtils.isToInsertOnlyTable(null, this.getProps()) != false || AcidUtils.isTransactionalTable(this.getProps()) && !this.isFullAcidConversion;
    }
}

