/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.create;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Resource plan", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateResourcePlanDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = -3492803425541479414L;
    private final String resourcePlanName;
    private final Integer queryParallelism;
    private final String copyFromName;
    private final boolean ifNotExists;

    public CreateResourcePlanDesc(String resourcePlanName, Integer queryParallelism, String copyFromName, boolean ifNotExists) {
        this.resourcePlanName = resourcePlanName;
        this.queryParallelism = queryParallelism;
        this.copyFromName = copyFromName;
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="Resource plan name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getResourcePlanName() {
        return this.resourcePlanName;
    }

    @Explain(displayName="Query parallelism", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Integer getQueryParallelism() {
        return this.queryParallelism;
    }

    @Explain(displayName="Copy from", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getCopyFromName() {
        return this.copyFromName;
    }

    @Explain(displayName="If not exists", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }
}

