/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.client.builder.GetPartitionProjectionsSpecBuilder;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.event.filters.DatabaseAndTableFilter;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisedBootstrapUtils {
    public static final String FILE_ENTRY_SEPARATOR = "#";
    private static final Logger LOG = LoggerFactory.getLogger(OptimisedBootstrapUtils.class);
    public static final String TABLE_DIFF_INPROGRESS_DIRECTORY = "table_diff";
    public static final String TABLE_DIFF_COMPLETE_DIRECTORY = "table_diff_complete";
    public static final String ABORT_TXNS_FILE = "abort_txns";
    public static final String EVENT_ACK_FILE = "event_ack";
    public static final String BOOTSTRAP_TABLES_LIST = "_failover_bootstrap_table_list";

    public static boolean isDbTargetOfFailover(String dbName, Hive hive) throws HiveException {
        Database database = hive.getDatabase(dbName);
        return database != null ? MetaStoreUtils.isTargetOfReplication((Database)database) : false;
    }

    public static boolean checkFileExists(Path dumpPath, HiveConf conf, String fileName) throws IOException {
        FileSystem fs = dumpPath.getFileSystem((Configuration)conf);
        return fs.exists(new Path(dumpPath, fileName));
    }

    public static void prepareAbortTxnsFile(List<NotificationEvent> notificationEvents, Set<Long> allOpenTxns, Path dumpPath, HiveConf conf) throws SemanticException {
        if (notificationEvents.size() == 0) {
            return;
        }
        HashSet txnsOpenedPostCurrEventId = new HashSet();
        MessageDeserializer deserializer = ReplUtils.getEventDeserializer(notificationEvents.get(0));
        for (NotificationEvent event : notificationEvents) {
            switch (event.getEventType()) {
                case "OPEN_TXN": {
                    OpenTxnMessage openTxnMessage = deserializer.getOpenTxnMessage(event.getMessage());
                    txnsOpenedPostCurrEventId.addAll(openTxnMessage.getTxnIds());
                    allOpenTxns.removeAll(openTxnMessage.getTxnIds());
                    break;
                }
                case "ABORT_TXN": {
                    AbortTxnMessage abortTxnMessage = deserializer.getAbortTxnMessage(event.getMessage());
                    if (txnsOpenedPostCurrEventId.contains(abortTxnMessage.getTxnId())) break;
                    allOpenTxns.add(abortTxnMessage.getTxnId());
                    break;
                }
                case "COMMIT_TXN": {
                    CommitTxnMessage commitTxnMessage = deserializer.getCommitTxnMessage(event.getMessage());
                    if (txnsOpenedPostCurrEventId.contains(commitTxnMessage.getTxnId())) break;
                    allOpenTxns.add(commitTxnMessage.getTxnId());
                }
            }
        }
        if (!allOpenTxns.isEmpty()) {
            Utils.writeOutput(OptimisedBootstrapUtils.flattenListToString(allOpenTxns), new Path(dumpPath, ABORT_TXNS_FILE), conf);
        }
    }

    public static List<Long> getTxnIdFromAbortTxnsFile(Path dumpPath, HiveConf conf) throws IOException {
        String input;
        Path abortTxnFile = new Path(dumpPath, ABORT_TXNS_FILE);
        FileSystem fs = abortTxnFile.getFileSystem((Configuration)conf);
        try (FSDataInputStream stream = fs.open(abortTxnFile);){
            input = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
        }
        return OptimisedBootstrapUtils.unflattenListFromString(input);
    }

    private static String flattenListToString(Set<Long> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(FILE_ENTRY_SEPARATOR));
    }

    private static List<Long> unflattenListFromString(String input) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (String val : input.replaceAll(System.lineSeparator(), "").trim().split(FILE_ENTRY_SEPARATOR)) {
            ret.add(Long.parseLong(val));
        }
        return ret;
    }

    public static String[] getEventIdFromFile(Path dumpPath, HiveConf conf) throws IOException {
        String lastEventId;
        Path eventAckFilePath = new Path(dumpPath, EVENT_ACK_FILE);
        FileSystem fs = eventAckFilePath.getFileSystem((Configuration)conf);
        try (FSDataInputStream stream = fs.open(eventAckFilePath);){
            lastEventId = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
        }
        return lastEventId.replaceAll(System.lineSeparator(), "").trim().split(FILE_ENTRY_SEPARATOR);
    }

    public static HashSet<String> getTablesFromTableDiffFile(Path dumpPath, HiveConf conf) throws Exception {
        FileSystem fs = dumpPath.getFileSystem((Configuration)conf);
        Path tableDiffPath = new Path(dumpPath, TABLE_DIFF_COMPLETE_DIRECTORY);
        FileStatus[] list = fs.listStatus(tableDiffPath);
        HashSet<String> tables = new HashSet<String>();
        for (FileStatus fStatus : list) {
            tables.add(fStatus.getPath().getName());
        }
        return tables;
    }

    public static HashSet<String> getPathsFromTableFile(String file, Path dumpPath, HiveConf conf) throws IOException {
        String allEntries;
        HashSet<String> paths = new HashSet<String>();
        FileSystem fs = dumpPath.getFileSystem((Configuration)conf);
        Path tableDiffPath = new Path(dumpPath, TABLE_DIFF_COMPLETE_DIRECTORY);
        Path filePath = new Path(tableDiffPath, file);
        try (FSDataInputStream stream = fs.open(filePath);){
            allEntries = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
        }
        paths.addAll(Arrays.asList(allEntries.split(System.lineSeparator())).stream().filter(item -> !item.isEmpty()).collect(Collectors.toSet()));
        return paths;
    }

    public static String getReplEventIdFromDatabase(String dbName, Hive hiveDb) throws HiveException {
        Database database = hiveDb.getDatabase(dbName);
        String currentLastEventId = ReplicationSpec.getLastReplicatedStateFromParameters(database.getParameters());
        return currentLastEventId;
    }

    public static void isFirstIncrementalPending(String dbName, Hive hiveDb) throws HiveException {
        Database database = hiveDb.getDatabase(dbName);
        if (database == null || ReplUtils.isFirstIncPending(database.getParameters())) {
            throw new HiveException("Replication dump not allowed for replicated database with first incremental dump pending : " + dbName);
        }
    }

    public static Long createAndGetEventAckFile(Path currentDumpPath, DumpMetaData dmd, Path cmRoot, String dbEventId, String targetDbEventId, HiveConf conf, ReplDumpWork work) throws Exception {
        Long lastReplId = -1L;
        Path filePath = new Path(currentDumpPath, EVENT_ACK_FILE);
        Utils.writeOutput(dbEventId + FILE_ENTRY_SEPARATOR + targetDbEventId, filePath, conf);
        LOG.info("Created event_ack file at {} with source eventId {} and target eventId {}", new Object[]{filePath, dbEventId, targetDbEventId});
        work.setResultValues(Arrays.asList(currentDumpPath.toUri().toString(), String.valueOf(lastReplId)));
        long executionId = conf.getLong("scheduled.query.executionid", 0L);
        dmd.setDump(DumpType.PRE_OPTIMIZED_BOOTSTRAP, work.eventFrom, lastReplId, cmRoot, executionId, false);
        dmd.write(true);
        return lastReplId;
    }

    public static List<NotificationEvent> getListOfNotificationEvents(Long eventId, Hive hiveDb, ReplLoadWork work) throws Exception {
        List notificationEvents = hiveDb.getMSC().getNextNotification(eventId - 1L, -1, (IMetaStoreClient.NotificationFilter)new DatabaseAndTableFilter(work.dbNameToLoadIn, null)).getEvents();
        if (((NotificationEvent)notificationEvents.get(0)).getEventId() != eventId.longValue()) {
            throw new Exception("Failover notification events expired.");
        }
        notificationEvents.remove(0);
        return notificationEvents;
    }

    public static void prepareTableDiffFile(List<NotificationEvent> notificationEvents, Hive hiveDb, ReplLoadWork work, HiveConf conf) throws Exception {
        HashSet<String> modifiedTables = new HashSet<String>();
        for (NotificationEvent event : notificationEvents) {
            String tableName = event.getTableName();
            if (tableName == null) continue;
            LOG.debug("Added table {} because of eventId {} and eventType {}", new Object[]{event.getTableName(), event.getEventId(), event.getEventType()});
            modifiedTables.add(event.getTableName());
        }
        Path dumpPath = new Path(work.dumpDirectory).getParent();
        FileSystem fs = dumpPath.getFileSystem((Configuration)conf);
        Path diffFilePath = new Path(dumpPath, TABLE_DIFF_INPROGRESS_DIRECTORY);
        fs.mkdirs(diffFilePath);
        for (String table : modifiedTables) {
            Object tables = "";
            LOG.info("Added table {} to table diff", (Object)table);
            ArrayList<String> pathList = OptimisedBootstrapUtils.getListing(work.dbNameToLoadIn, table, hiveDb, conf);
            for (String path : pathList) {
                tables = (String)tables + path + System.lineSeparator();
            }
            Utils.writeOutput((String)tables, new Path(diffFilePath, table), conf);
        }
        LOG.info("Completed writing table diff progress file at {} with entries {}", (Object)dumpPath, modifiedTables);
        fs.rename(diffFilePath, new Path(dumpPath, TABLE_DIFF_COMPLETE_DIRECTORY));
        LOG.info("Completed renaming table diff progress file to table diff complete file.");
    }

    public static String getTargetEventId(String dbName, Hive hiveDb) throws Exception {
        Database database = hiveDb.getDatabase(dbName);
        String targetLastEventId = ReplicationSpec.getTargetLastReplicatedStateFromParameters(database.getParameters());
        List events = hiveDb.getMSC().getNextNotification(Long.parseLong(targetLastEventId) - 1L, 1, null).getEvents();
        if (events == null || events.isEmpty() || ((NotificationEvent)events.get(0)).getEventId() != Long.parseLong(targetLastEventId)) {
            throw new IllegalStateException("Notification events are missing in the meta store.");
        }
        return targetLastEventId;
    }

    public static void createBootstrapTableList(Path newDumpPath, Set<String> tablesForBootstrap, HiveConf conf) throws SemanticException {
        Object tableList = "";
        for (String table : tablesForBootstrap) {
            tableList = (String)tableList + table + System.lineSeparator();
        }
        LOG.info("Generated table list for optimised bootstrap {}", tableList);
        Utils.writeOutput((String)tableList, new Path(newDumpPath, BOOTSTRAP_TABLES_LIST), conf);
    }

    public static String[] getBootstrapTableList(Path dumpPath, HiveConf conf) throws IOException {
        Path tablePath = new Path(dumpPath, BOOTSTRAP_TABLES_LIST);
        String tableList = "";
        FileSystem fs = dumpPath.getFileSystem((Configuration)conf);
        try (FSDataInputStream stream = fs.open(tablePath);){
            tableList = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
        }
        return tableList.split(System.lineSeparator());
    }

    private static ArrayList<String> getListing(String dbName, String tableName, Hive hiveDb, HiveConf conf) throws HiveException, IOException {
        ArrayList<String> paths = new ArrayList<String>();
        Table table = hiveDb.getTable(dbName, tableName, false);
        if (table == null) {
            LOG.info("Table {} not found, excluding the dropped table", (Object)tableName);
            return new ArrayList<String>();
        }
        Path tableLocation = new Path(table.getSd().getLocation());
        paths.add(table.getSd().getLocation());
        FileSystem tableFs = tableLocation.getFileSystem((Configuration)conf);
        OptimisedBootstrapUtils.buildListingForDirectory(paths, tableLocation, tableFs);
        if (table.isPartitioned()) {
            List<Partition> partitions;
            GetProjectionsSpec getProjectionsSpec = new GetPartitionProjectionsSpecBuilder().addProjectFieldList(Arrays.asList("sd.location")).build();
            GetPartitionsRequest request = new GetPartitionsRequest(table.getDbName(), table.getTableName(), getProjectionsSpec, null);
            request.setCatName(table.getCatName());
            try {
                partitions = hiveDb.getPartitionsWithSpecs(table, request);
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
            for (Partition part : partitions) {
                Path partPath = part.getDataLocation();
                if (FileUtils.isPathWithinSubtree((Path)partPath, (Path)tableLocation)) continue;
                OptimisedBootstrapUtils.buildListingForDirectory(paths, partPath, tableFs);
            }
        }
        return paths;
    }

    private static void buildListingForDirectory(ArrayList<String> listing, Path tableLocation, FileSystem tableFs) throws IOException {
        if (!tableFs.exists(tableLocation)) {
            return;
        }
        RemoteIterator itr = tableFs.listStatusIterator(tableLocation);
        while (itr.hasNext()) {
            FileStatus fstatus = (FileStatus)itr.next();
            if (fstatus.isDirectory()) {
                listing.add(fstatus.getPath().toString());
                OptimisedBootstrapUtils.buildListingForDirectory(listing, fstatus.getPath(), tableFs);
                continue;
            }
            listing.add(String.valueOf(fstatus.getPath()) + FILE_ENTRY_SEPARATOR + fstatus.getLen() + FILE_ENTRY_SEPARATOR + String.valueOf(tableFs.getFileChecksum(fstatus.getPath())));
        }
    }
}

