/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.RangerDenyWork;
import org.apache.hadoop.hive.ql.exec.repl.ranger.NoOpRangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerExportPolicyList;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerPolicy;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClientImpl;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDenyTask
extends Task<RangerDenyWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RangerDenyTask.class);
    private transient RangerRestClient rangerRestClient;

    public RangerDenyTask() {
    }

    @VisibleForTesting
    RangerDenyTask(RangerRestClient rangerRestClient, HiveConf conf, RangerDenyWork work) {
        this.conf = conf;
        this.work = work;
        this.rangerRestClient = rangerRestClient;
    }

    public String getName() {
        return "RANGER_DENY";
    }

    @Override
    public int execute() {
        try {
            URL url;
            LOG.info("Checking Ranger Deny Policy for {}", (Object)((RangerDenyWork)this.work).getTargetDbName());
            SecurityUtils.reloginExpiringKeytabUser();
            if (this.rangerRestClient == null) {
                this.rangerRestClient = this.getRangerRestClient();
            }
            if ((url = ((RangerDenyWork)this.work).getRangerConfigResource()) == null) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Ranger configuration is not valid ranger-hive-security.xml", "ranger"}));
            }
            this.conf.addResource(url);
            String rangerHiveServiceName = this.conf.get("ranger.plugin.hive.service.name");
            String rangerEndpoint = this.conf.get("ranger.plugin.hive.policy.rest.url");
            if (StringUtils.isEmpty((CharSequence)rangerEndpoint)) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Ranger endpoint is not valid " + rangerEndpoint, "ranger"}));
            }
            if (!this.rangerRestClient.checkConnection(rangerEndpoint, this.conf)) {
                throw new SemanticException(ErrorMsg.REPL_EXTERNAL_SERVICE_CONNECTION_ERROR.format(new String[]{"ranger", "Ranger endpoint is not valid " + rangerEndpoint}));
            }
            HashMap<String, Long> metricMap = new HashMap<String, Long>();
            metricMap.put(ReplUtils.MetricName.POLICIES.name(), 1L);
            ((RangerDenyWork)this.work).getMetricCollector().reportStageStart(this.getName(), metricMap);
            if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_RANGER_ADD_DENY_POLICY_TARGET)) {
                final RangerPolicy rangerDenyPolicy = this.rangerRestClient.getDenyPolicyForReplicatedDb(rangerHiveServiceName, ((RangerDenyWork)this.work).getSourceDbName(), ((RangerDenyWork)this.work).getTargetDbName());
                RangerExportPolicyList rangerExportPolicyList = new RangerExportPolicyList();
                rangerExportPolicyList.setPolicies((List<RangerPolicy>)new ArrayList<RangerPolicy>(){
                    {
                        this.add(rangerDenyPolicy);
                    }
                });
                this.rangerRestClient.importRangerPolicies(rangerExportPolicyList, ((RangerDenyWork)this.work).getTargetDbName(), rangerEndpoint, rangerHiveServiceName, this.conf);
                ((RangerDenyWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.POLICIES.name(), 1L);
                LOG.info("Created Ranger Deny policy for {}", (Object)((RangerDenyWork)this.work).getTargetDbName());
            } else {
                String policyName = ((RangerDenyWork)this.work).getSourceDbName() + "_replication deny policy for " + ((RangerDenyWork)this.work).getTargetDbName();
                this.rangerRestClient.deleteRangerPolicy(policyName, rangerEndpoint, rangerHiveServiceName, this.conf);
                ((RangerDenyWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.POLICIES.name(), 1L);
                LOG.info("Deleted Ranger Deny policy for {}", (Object)((RangerDenyWork)this.work).getTargetDbName());
            }
            ((RangerDenyWork)this.work).getMetricCollector().reportStageEnd(this.getName(), Status.SUCCESS);
            return 0;
        }
        catch (RuntimeException e) {
            LOG.error("Runtime Excepton during Ranger Deny policy creation.", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, ((RangerDenyWork)this.work).getCurrentDumpPath().getParent().toString(), ((RangerDenyWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            try {
                LOG.error("Ranger Deny policy creation Failed", (Throwable)e);
                this.setException(e);
                return ReplUtils.handleException(true, e, ((RangerDenyWork)this.work).getCurrentDumpPath().getParent().toString(), ((RangerDenyWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
                return errorCode;
            }
        }
    }

    private RangerRestClient getRangerRestClient() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            return new NoOpRangerRestClient();
        }
        return new RangerRestClientImpl();
    }

    @Override
    public StageType getType() {
        return StageType.RANGER_DENY;
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

