/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hive.llap.counters.LlapWmCounters;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.Constants;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.PrintSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;

public class LlapWmSummary
implements PrintSummary {
    private static final String LLAP_SUMMARY_HEADER_FORMAT = "%10s %20s %20s %20s %20s";
    private static final String LLAP_SUMMARY_TITLE = "LLAP WM Summary";
    private static final String LLAP_SUMMARY_HEADER = String.format("%10s %20s %20s %20s %20s", "VERTICES", "SPECULATIVE QUEUED", "SPECULATIVE RUNNING", "GUARANTEED QUEUED", "GUARANTEED RUNNING");
    private final DecimalFormat secondsFormatter = new DecimalFormat("#0.00");
    private Map<String, Progress> progressMap;
    private DAGClient dagClient;
    private boolean first = false;

    LlapWmSummary(Map<String, Progress> progressMap, DAGClient dagClient) {
        this.progressMap = progressMap;
        this.dagClient = dagClient;
    }

    @Override
    public void print(SessionState.LogHelper console) {
        console.printInfo("");
        console.printInfo(LLAP_SUMMARY_TITLE);
        TreeSet<String> keys = new TreeSet<String>(this.progressMap.keySet());
        Set<StatusGetOpts> statusOptions = Collections.singleton(StatusGetOpts.GET_COUNTERS);
        String counterGroup = LlapWmCounters.class.getName();
        for (String vertexName : keys) {
            TezCounters vertexCounters = this.vertexCounter(statusOptions, vertexName);
            if (vertexCounters == null) continue;
            if (!this.first) {
                console.printInfo(Constants.SEPARATOR);
                console.printInfo(LLAP_SUMMARY_HEADER);
                console.printInfo(Constants.SEPARATOR);
                this.first = true;
            }
            console.printInfo(this.vertexSummary(vertexName, counterGroup, vertexCounters));
        }
        console.printInfo(Constants.SEPARATOR);
        console.printInfo("");
    }

    private String vertexSummary(String vertexName, String counterGroup, TezCounters vertexCounters) {
        long sq = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapWmCounters.SPECULATIVE_QUEUED_NS.name());
        long sr = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapWmCounters.SPECULATIVE_RUNNING_NS.name());
        long gq = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapWmCounters.GUARANTEED_QUEUED_NS.name());
        long gr = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapWmCounters.GUARANTEED_RUNNING_NS.name());
        return String.format(LLAP_SUMMARY_HEADER_FORMAT, vertexName, this.secondsFormatter.format((double)sq / 1.0E9) + "s", this.secondsFormatter.format((double)sr / 1.0E9) + "s", this.secondsFormatter.format((double)gq / 1.0E9) + "s", this.secondsFormatter.format((double)gr / 1.0E9) + "s");
    }

    private TezCounters vertexCounter(Set<StatusGetOpts> statusOptions, String vertexName) {
        try {
            return this.dagClient.getVertexStatus(vertexName, statusOptions).getVertexCounters();
        }
        catch (IOException | TezException throwable) {
            return null;
        }
    }
}

