/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableContainerBase;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastLongHashMultiSetContainer
extends VectorMapJoinFastHashTableContainerBase
implements VectorMapJoinLongHashMultiSet {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastLongHashMultiSetContainer.class);
    private final VectorMapJoinFastLongHashMultiSet[] vectorMapJoinFastLongHashMultiSets;
    private final BinarySortableDeserializeRead keyBinarySortableDeserializeRead;
    private final VectorMapJoinDesc.HashTableKeyType hashTableKeyType;
    private final int numThreads;
    private final boolean minMaxEnabled;

    public VectorMapJoinFastLongHashMultiSetContainer(boolean isFullOuter, boolean minMaxEnabled, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, TableDesc tableDesc, int numHTs) {
        this.hashTableKeyType = hashTableKeyType;
        this.vectorMapJoinFastLongHashMultiSets = new VectorMapJoinFastLongHashMultiSet[numHTs];
        LOG.info("Initializing {} HT Containers ", (Object)numHTs);
        for (int i = 0; i < numHTs; ++i) {
            this.vectorMapJoinFastLongHashMultiSets[i] = new VectorMapJoinFastLongHashMultiSet(isFullOuter, minMaxEnabled, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount, tableDesc);
        }
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[]{hashTableKeyType.getPrimitiveTypeInfo()};
        this.keyBinarySortableDeserializeRead = BinarySortableDeserializeRead.with((TypeInfo[])primitiveTypeInfos, (boolean)false, (Properties)tableDesc.getProperties());
        this.numThreads = numHTs;
        this.minMaxEnabled = minMaxEnabled;
    }

    @Override
    public VectorMapJoinHashMultiSetResult createHashMultiSetResult() {
        return new VectorMapJoinFastHashMultiSet.HashMultiSetResult();
    }

    @Override
    public long getHashCode(BytesWritable currentKey) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        try {
            if (!this.keyBinarySortableDeserializeRead.readNextField()) {
                return 0L;
            }
        }
        catch (Exception e) {
            throw new HiveException("DeserializeRead details: " + this.keyBinarySortableDeserializeRead.getDetailedReadPositionString(), (Throwable)e);
        }
        long key = VectorMapJoinFastLongHashUtil.deserializeLongKey(this.keyBinarySortableDeserializeRead, this.hashTableKeyType);
        return HashCodeUtil.calculateLongHashCode((long)key);
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        this.vectorMapJoinFastLongHashMultiSets[(int)((long)(this.numThreads - 1) & hashCode)].putRow(hashCode, currentKey, currentValue);
    }

    @Override
    public JoinUtil.JoinResult contains(long key, VectorMapJoinHashMultiSetResult hashMultiSetResult) {
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        return this.vectorMapJoinFastLongHashMultiSets[(int)((long)(this.numThreads - 1) & hashCode)].contains(key, hashMultiSetResult);
    }

    @Override
    public long getEstimatedMemorySize() {
        long estimatedMemorySize = 0L;
        for (int i = 0; i < this.numThreads; ++i) {
            estimatedMemorySize += this.vectorMapJoinFastLongHashMultiSets[i].getEstimatedMemorySize();
        }
        return estimatedMemorySize;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            size += this.vectorMapJoinFastLongHashMultiSets[i].size();
        }
        return size;
    }

    @Override
    public MatchTracker createMatchTracker() {
        int count = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            count += this.vectorMapJoinFastLongHashMultiSets[i].logicalHashBucketCount;
        }
        return MatchTracker.create(count);
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int spillPartitionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean useMinMax() {
        return this.minMaxEnabled;
    }

    @Override
    public long min() {
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this.numThreads; ++i) {
            long currentMin = this.vectorMapJoinFastLongHashMultiSets[i].min();
            if (currentMin >= min) continue;
            min = currentMin;
        }
        return min;
    }

    @Override
    public long max() {
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.numThreads; ++i) {
            long currentMax = this.vectorMapJoinFastLongHashMultiSets[i].max();
            if (currentMax <= max) continue;
            max = currentMax;
        }
        return max;
    }
}

