/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastStringCommon {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastStringCommon.class);
    private BinarySortableDeserializeRead keyBinarySortableDeserializeRead;

    public boolean adaptPutRow(VectorMapJoinFastBytesHashTable hashTable, BytesWritable currentKey, BytesWritable currentValue, long hashCode) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        try {
            if (!this.keyBinarySortableDeserializeRead.readNextField()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new HiveException("DeserializeRead details: " + this.keyBinarySortableDeserializeRead.getDetailedReadPositionString(), (Throwable)e);
        }
        hashTable.add(this.keyBinarySortableDeserializeRead.currentBytes, this.keyBinarySortableDeserializeRead.currentBytesStart, this.keyBinarySortableDeserializeRead.currentBytesLength, currentValue, hashCode);
        return true;
    }

    public long calculateLongHashCode(BytesWritable currentKey) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        try {
            if (!this.keyBinarySortableDeserializeRead.readNextField()) {
                return 0L;
            }
        }
        catch (Exception e) {
            throw new HiveException("DeserializeRead details: " + this.keyBinarySortableDeserializeRead.getDetailedReadPositionString(), (Throwable)e);
        }
        return HashCodeUtil.murmurHash((byte[])this.keyBinarySortableDeserializeRead.currentBytes, (int)this.keyBinarySortableDeserializeRead.currentBytesStart, (int)this.keyBinarySortableDeserializeRead.currentBytesLength);
    }

    public VectorMapJoinFastStringCommon(TableDesc tableDesc) {
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[]{TypeInfoFactory.stringTypeInfo};
        this.keyBinarySortableDeserializeRead = BinarySortableDeserializeRead.with((TypeInfo[])primitiveTypeInfos, (boolean)false, (Properties)tableDesc.getProperties());
    }
}

