/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableContainerBase;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMultiSetContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashSetContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMultiSetContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashSetContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMultiSetContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashSetContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinTableContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public class VectorMapJoinFastTableContainer
implements VectorMapJoinTableContainer,
VectorMapJoinHashTable {
    private final MapJoinDesc desc;
    private final Configuration hconf;
    private final float keyCountAdj;
    private final int threshold;
    private final float loadFactor;
    private final VectorMapJoinFastHashTableContainerBase INSTANCE;
    private final long estimatedKeyCount;
    private String key;
    private int numHTs;

    public VectorMapJoinFastTableContainer(MapJoinDesc desc, Configuration hconf, long estimatedKeys, int numHTs) throws SerDeException {
        this.desc = desc;
        this.hconf = hconf;
        this.keyCountAdj = HiveConf.getFloatVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HASHTABLE_KEY_COUNT_ADJUSTMENT);
        this.threshold = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HASHTABLE_THRESHOLD);
        this.loadFactor = HiveConf.getFloatVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HASHTABLE_LOAD_FACTOR);
        this.numHTs = numHTs;
        this.estimatedKeyCount = estimatedKeys > (long)numHTs ? estimatedKeys / (long)numHTs : estimatedKeys;
        int newThreshold = HashMapWrapper.calculateTableSize(this.keyCountAdj, this.threshold, this.loadFactor, this.estimatedKeyCount);
        this.INSTANCE = this.createHashTables(newThreshold);
    }

    @Override
    public VectorMapJoinHashTable vectorMapJoinHashTable() {
        return this.INSTANCE;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    private VectorMapJoinFastHashTableContainerBase createHashTables(int newThreshold) {
        VectorMapJoinDesc vectorDesc = (VectorMapJoinDesc)this.desc.getVectorDesc();
        VectorMapJoinDesc.HashTableKind hashTableKind = vectorDesc.getHashTableKind();
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = vectorDesc.getHashTableKeyType();
        boolean isFullOuter = vectorDesc.getIsFullOuter();
        boolean minMaxEnabled = vectorDesc.getMinMaxEnabled();
        int writeBufferSize = HiveConf.getIntVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HASHTABLE_WB_SIZE);
        VectorMapJoinFastHashTableContainerBase htWrapper = null;
        block0 : switch (hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case DATE: 
            case LONG: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        htWrapper = new VectorMapJoinFastLongHashMapContainer(isFullOuter, minMaxEnabled, hashTableKeyType, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.desc.getKeyTblDesc(), this.numHTs);
                        break;
                    }
                    case HASH_MULTISET: {
                        htWrapper = new VectorMapJoinFastLongHashMultiSetContainer(isFullOuter, minMaxEnabled, hashTableKeyType, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.desc.getKeyTblDesc(), this.numHTs);
                        break;
                    }
                    case HASH_SET: {
                        htWrapper = new VectorMapJoinFastLongHashSetContainer(isFullOuter, minMaxEnabled, hashTableKeyType, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.desc.getKeyTblDesc(), this.numHTs);
                    }
                }
                break;
            }
            case STRING: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        htWrapper = new VectorMapJoinFastStringHashMapContainer(isFullOuter, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.desc.getKeyTblDesc(), this.numHTs);
                        break;
                    }
                    case HASH_MULTISET: {
                        htWrapper = new VectorMapJoinFastStringHashMultiSetContainer(isFullOuter, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.desc.getKeyTblDesc(), this.numHTs);
                        break;
                    }
                    case HASH_SET: {
                        htWrapper = new VectorMapJoinFastStringHashSetContainer(isFullOuter, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.desc.getKeyTblDesc(), this.numHTs);
                    }
                }
                break;
            }
            case MULTI_KEY: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        htWrapper = new VectorMapJoinFastMultiKeyHashMapContainer(isFullOuter, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.numHTs);
                        break block0;
                    }
                    case HASH_MULTISET: {
                        htWrapper = new VectorMapJoinFastMultiKeyHashMultiSetContainer(isFullOuter, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.numHTs);
                        break block0;
                    }
                    case HASH_SET: {
                        htWrapper = new VectorMapJoinFastMultiKeyHashSetContainer(isFullOuter, newThreshold, this.loadFactor, writeBufferSize, this.estimatedKeyCount, this.numHTs);
                    }
                }
            }
        }
        return htWrapper;
    }

    public long getHashCode(BytesWritable currentKey) throws HiveException, IOException {
        return this.INSTANCE.getHashCode(currentKey);
    }

    @Override
    public MapJoinKey putRow(Writable currentKey, Writable currentValue) throws SerDeException, HiveException, IOException {
        long hashCode = this.INSTANCE.getHashCode((BytesWritable)currentKey);
        this.INSTANCE.putRow(hashCode, (BytesWritable)currentKey, (BytesWritable)currentValue);
        return null;
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws SerDeException, HiveException, IOException {
        this.INSTANCE.putRow(hashCode, currentKey, currentValue);
    }

    @Override
    public void seal() {
    }

    @Override
    public MapJoinTableContainer.ReusableGetAdaptor createGetter(MapJoinKey keyTypeFromLoader) {
        throw new RuntimeException("Not applicable");
    }

    @Override
    public MapJoinTableContainer.NonMatchedSmallTableIterator createNonMatchedSmallTableIterator(MatchTracker matchTracker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
    }

    @Override
    public MapJoinKey getAnyKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpMetrics() {
    }

    @Override
    public boolean hasSpill() {
        return false;
    }

    @Override
    public boolean containsLongKey(long currentKey) {
        return this.INSTANCE.containsLongKey(currentKey);
    }

    @Override
    public int size() {
        return this.INSTANCE.size();
    }

    @Override
    public MatchTracker createMatchTracker() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int spillPartitionId() {
        throw new UnsupportedOperationException();
    }

    public long getEstimatedMemorySize() {
        return this.INSTANCE.getEstimatedMemorySize();
    }

    @Override
    public void setSerde(MapJoinObjectSerDeContext keyCtx, MapJoinObjectSerDeContext valCtx) throws SerDeException {
    }
}

