/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedStringCommon;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class VectorMapJoinOptimizedStringHashSet
extends VectorMapJoinOptimizedHashSet
implements VectorMapJoinBytesHashSet {
    private VectorMapJoinOptimizedStringCommon stringCommon;

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashSetResult hashSetResult) throws IOException {
        VectorMapJoinOptimizedHashTable.SerializedBytes serializedBytes = this.stringCommon.serialize(keyBytes, keyStart, keyLength);
        return super.contains(serializedBytes.bytes, serializedBytes.offset, serializedBytes.length, hashSetResult);
    }

    public VectorMapJoinOptimizedStringHashSet(boolean isOuterJoin, MapJoinTableContainer originalTableContainer, MapJoinTableContainer.ReusableGetAdaptor hashMapRowGetter, TableDesc tableDesc) {
        super(originalTableContainer, hashMapRowGetter);
        this.stringCommon = new VectorMapJoinOptimizedStringCommon(isOuterJoin, tableDesc);
    }

    @Override
    public long getEstimatedMemorySize() {
        long size = 16384L;
        return super.getEstimatedMemorySize() + size;
    }
}

