/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorAbstractSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorHelper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalSum
extends VectorPTFEvaluatorAbstractSum<HiveDecimalWritable> {
    protected HiveDecimalWritable temp;

    public VectorPTFEvaluatorDecimalSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.sum = new HiveDecimalWritable();
        this.temp = new HiveDecimalWritable();
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        block14: {
            DecimalColumnVector decimalColVector;
            int size;
            block13: {
                this.evaluateInputExpr(batch);
                Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
                size = batch.size;
                if (size == 0) {
                    return;
                }
                decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
                if (!decimalColVector.isRepeating) break block13;
                if (!decimalColVector.noNulls && decimalColVector.isNull[0]) break block14;
                this.temp.setFromLong((long)batch.size);
                if (this.isGroupResultNull) {
                    ((HiveDecimalWritable)this.sum).set(decimalColVector.vector[0]);
                    ((HiveDecimalWritable)this.sum).mutateMultiply(this.temp);
                    this.isGroupResultNull = false;
                } else {
                    this.temp.mutateMultiply(decimalColVector.vector[0]);
                    ((HiveDecimalWritable)this.sum).mutateAdd(this.temp);
                }
                break block14;
            }
            if (decimalColVector.noNulls) {
                HiveDecimalWritable[] vector = decimalColVector.vector;
                if (this.isGroupResultNull) {
                    ((HiveDecimalWritable)this.sum).set(vector[0]);
                    this.isGroupResultNull = false;
                } else {
                    ((HiveDecimalWritable)this.sum).mutateAdd(vector[0]);
                }
                for (int i = 1; i < size; ++i) {
                    ((HiveDecimalWritable)this.sum).mutateAdd(vector[i]);
                }
            } else {
                boolean[] batchIsNull = decimalColVector.isNull;
                int i = 0;
                while (batchIsNull[i]) {
                    if (++i < size) continue;
                    return;
                }
                HiveDecimalWritable[] vector = decimalColVector.vector;
                if (this.isGroupResultNull) {
                    ((HiveDecimalWritable)this.sum).set(vector[i++]);
                    this.isGroupResultNull = false;
                } else {
                    ((HiveDecimalWritable)this.sum).mutateAdd(vector[i++]);
                }
                while (i < size) {
                    if (!batchIsNull[i]) {
                        ((HiveDecimalWritable)this.sum).mutateAdd(vector[i]);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    protected HiveDecimalWritable computeValue(HiveDecimalWritable number) {
        return VectorPTFEvaluatorHelper.computeValue(number);
    }

    @Override
    public HiveDecimalWritable plus(HiveDecimalWritable t1, HiveDecimalWritable t2) {
        return VectorPTFEvaluatorHelper.plus(t1, t2);
    }

    @Override
    public HiveDecimalWritable minus(HiveDecimalWritable t1, HiveDecimalWritable t2) {
        return VectorPTFEvaluatorHelper.minus(t1, t2);
    }

    @Override
    public void onResultCalculated(Object result, Range range) {
        if (this.previousSum != null) {
            ((HiveDecimalWritable)this.previousSum).set((HiveDecimalWritable)result);
        } else {
            this.previousSum = new HiveDecimalWritable((HiveDecimalWritable)result);
        }
        this.previousRange = range;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        ((HiveDecimalWritable)this.sum).set(HiveDecimal.ZERO);
    }
}

