/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorAbstractSum;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorHelper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorLongSum
extends VectorPTFEvaluatorAbstractSum<Long> {
    public VectorPTFEvaluatorLongSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                if (this.isGroupResultNull) {
                    this.sum = longColVector.vector[0] * (long)batch.size;
                    this.isGroupResultNull = false;
                } else {
                    this.sum = (Long)this.sum + longColVector.vector[0] * (long)batch.size;
                }
            }
        } else if (longColVector.noNulls) {
            long[] vector = longColVector.vector;
            long varSum = vector[0];
            for (int i = 1; i < size; ++i) {
                varSum += vector[i];
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum = (Long)this.sum + varSum;
            }
        } else {
            boolean[] batchIsNull = longColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            long[] vector = longColVector.vector;
            long varSum = vector[i++];
            while (i < size) {
                if (!batchIsNull[i]) {
                    varSum += vector[i];
                }
                ++i;
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum = (Long)this.sum + varSum;
            }
        }
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    protected Long plus(Long number1, Long number2) {
        return VectorPTFEvaluatorHelper.plus(number1, number2);
    }

    @Override
    protected Long minus(Long number1, Long number2) {
        return VectorPTFEvaluatorHelper.minus(number1, number2);
    }

    @Override
    protected Long computeValue(Long number) {
        return VectorPTFEvaluatorHelper.computeValue(number);
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.sum = 0L;
    }
}

