/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorStreamingDoubleMin
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected double min;

    public VectorPTFEvaluatorStreamingDoubleMin(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        double[] outputVector = outputColVector.vector;
        if (doubleColVector.isRepeating) {
            if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                double repeatedMin = doubleColVector.vector[0];
                if (this.isNull) {
                    this.min = repeatedMin;
                    this.isNull = false;
                } else if (repeatedMin < this.min) {
                    this.min = repeatedMin;
                }
                outputVector[0] = this.min;
            } else if (this.isNull) {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            } else {
                outputVector[0] = this.min;
            }
            outputColVector.isRepeating = true;
        } else if (doubleColVector.noNulls) {
            double[] vector = doubleColVector.vector;
            for (int i = 0; i < size; ++i) {
                double value = vector[i];
                if (this.isNull) {
                    this.min = value;
                    this.isNull = false;
                } else if (value < this.min) {
                    this.min = value;
                }
                outputVector[i] = this.min;
            }
        } else {
            boolean[] batchIsNull = doubleColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (this.isNull) {
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[i] = this.min;
                }
                if (++i < size) continue;
                return;
            }
            double[] vector = doubleColVector.vector;
            double firstValue = vector[i];
            if (this.isNull) {
                this.min = firstValue;
                this.isNull = false;
            } else if (firstValue < this.min) {
                this.min = firstValue;
            }
            outputVector[i++] = this.min;
            while (i < size) {
                if (!batchIsNull[i]) {
                    double value = vector[i];
                    if (this.isNull) {
                        this.min = value;
                        this.isNull = false;
                    } else if (value < this.min) {
                        this.min = value;
                    }
                    outputVector[i] = this.min;
                } else {
                    outputVector[i] = this.min;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.min = 0.0;
    }
}

