/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.history;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.history.HiveHistoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHistoryViewer
implements HiveHistory.Listener {
    String historyFile;
    String sessionId;
    private static final Logger LOG = LoggerFactory.getLogger(HiveHistoryViewer.class);
    private final HashMap<String, HiveHistory.QueryInfo> jobInfoMap = new HashMap();
    private final HashMap<String, HiveHistory.TaskInfo> taskInfoMap = new HashMap();

    public HiveHistoryViewer(String path) {
        this.historyFile = path;
        this.init();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Map<String, HiveHistory.QueryInfo> getJobInfoMap() {
        return this.jobInfoMap;
    }

    public Map<String, HiveHistory.TaskInfo> getTaskInfoMap() {
        return this.taskInfoMap;
    }

    void init() {
        try {
            HiveHistoryUtil.parseHiveHistory(this.historyFile, this);
        }
        catch (IOException e) {
            LOG.error("Error parsing hive history log file", (Throwable)e);
        }
    }

    @Override
    public void handle(HiveHistory.RecordTypes recType, Map<String, String> values) {
        if (recType == HiveHistory.RecordTypes.SessionStart) {
            this.sessionId = values.get(HiveHistory.Keys.SESSION_ID.name());
        } else if (recType == HiveHistory.RecordTypes.QueryStart || recType == HiveHistory.RecordTypes.QueryEnd) {
            String key = values.get(HiveHistory.Keys.QUERY_ID.name());
            if (this.jobInfoMap.containsKey(key)) {
                HiveHistory.QueryInfo ji = this.jobInfoMap.get(key);
                ji.hm.putAll(values);
            } else {
                HiveHistory.QueryInfo ji = new HiveHistory.QueryInfo();
                ji.hm = new HashMap<String, String>();
                ji.hm.putAll(values);
                this.jobInfoMap.put(key, ji);
            }
        } else if (recType == HiveHistory.RecordTypes.TaskStart || recType == HiveHistory.RecordTypes.TaskEnd || recType == HiveHistory.RecordTypes.TaskProgress) {
            String taskid;
            String jobid = values.get(HiveHistory.Keys.QUERY_ID.name());
            String key = jobid + ":" + (taskid = values.get(HiveHistory.Keys.TASK_ID.name()));
            if (this.taskInfoMap.containsKey(key)) {
                HiveHistory.TaskInfo ti = this.taskInfoMap.get(key);
                ti.hm.putAll(values);
            } else {
                HiveHistory.TaskInfo ti = new HiveHistory.TaskInfo();
                ti.hm = new HashMap<String, String>();
                ti.hm.putAll(values);
                this.taskInfoMap.put(key, ti);
            }
        }
    }
}

