/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr.zookeeper;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;

public class ZooKeeperHiveLock
extends HiveLock {
    private String path;
    private HiveLockObject obj;
    private HiveLockMode mode;

    public ZooKeeperHiveLock(String path, HiveLockObject obj, HiveLockMode mode) {
        this.path = path;
        this.obj = obj;
        this.mode = mode;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public HiveLockObject getHiveLockObject() {
        return this.obj;
    }

    public void setHiveLockObject(HiveLockObject obj) {
        this.obj = obj;
    }

    @Override
    public HiveLockMode getHiveLockMode() {
        return this.mode;
    }

    public void setHiveLockMode(HiveLockMode mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZooKeeperHiveLock)) {
            return false;
        }
        ZooKeeperHiveLock zLock = (ZooKeeperHiveLock)o;
        return this.path.equals(zLock.getPath()) && this.obj.equals(zLock.getHiveLockObject()) && this.mode == zLock.getHiveLockMode();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean pathPresent = this.path != null;
        builder.append(pathPresent);
        if (pathPresent) {
            builder.append(this.path.toCharArray());
        }
        boolean lockObjectPresent = this.obj != null;
        builder.append(lockObjectPresent);
        if (lockObjectPresent) {
            builder.append(this.obj.hashCode());
        }
        boolean modePresent = this.mode != null;
        builder.append(modePresent);
        if (modePresent) {
            builder.append((Object)this.mode);
        }
        return builder.toHashCode();
    }

    public String toString() {
        return String.format("ZKHL[%s;%s;%s]", new Object[]{this.path, this.obj, this.mode});
    }
}

