/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log.syslog;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogInputFormat
extends TextInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogInputFormat.class);
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private SearchArgument sarg;
    private JobConf jobConf;
    private ProjectionPusher projectionPusher = new ProjectionPusher();

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        FileStatus[] fileStatuses = super.listStatus(job);
        String filterExprSerialized = job.get("hive.io.filter.expr.serialized");
        boolean filePruning = HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.SYSLOG_INPUT_FORMAT_FILE_PRUNING);
        long timeSliceSeconds = HiveConf.getTimeVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.SYSLOG_INPUT_FORMAT_FILE_TIME_SLICE, (TimeUnit)TimeUnit.SECONDS);
        if (filePruning && filterExprSerialized != null) {
            ExprNodeGenericFuncDesc filterExpr = SerializationUtilities.deserializeExpression(filterExprSerialized);
            this.sarg = ConvertAstToSearchArg.create((Configuration)job, filterExpr);
        }
        LOG.info("Syslog configs - filePruning: {} SARG: {} timeSliceSeconds: {}", new Object[]{filePruning, this.sarg, timeSliceSeconds});
        if (this.sarg != null) {
            fileStatuses = this.pruneFiles(this.sarg, timeSliceSeconds, Arrays.asList(fileStatuses)).toArray(new FileStatus[0]);
        }
        return fileStatuses;
    }

    @VisibleForTesting
    public List<FileStatus> pruneFiles(SearchArgument sarg, long timeSliceSeconds, List<FileStatus> inputFiles) {
        int tsExpr = 0;
        List predLeaves = sarg.getLeaves();
        SearchArgument.TruthValue[] truthValues = new SearchArgument.TruthValue[predLeaves.size()];
        PredicateLeaf tsPred = null;
        for (int i = 0; i < truthValues.length; ++i) {
            if (!((PredicateLeaf)predLeaves.get(i)).getColumnName().equalsIgnoreCase("ts")) {
                truthValues[i] = SearchArgument.TruthValue.YES_NO_NULL;
                continue;
            }
            tsPred = (PredicateLeaf)predLeaves.get(i);
            ++tsExpr;
        }
        if (tsExpr == 0 || tsExpr > 1) {
            if (tsExpr == 0) {
                LOG.warn("No filter expression on 'ts' column. Skipping file pruning..");
            } else {
                LOG.warn("Multi-filter expression ({}) on 'ts' column is not supported. Skipping file pruning..", (Object)tsExpr);
            }
            return inputFiles;
        }
        if (tsPred.getOperator() == PredicateLeaf.Operator.BETWEEN) {
            ArrayList<FileStatus> selectedFiles = new ArrayList<FileStatus>();
            List objects = tsPred.getLiteralList();
            Timestamp left = (Timestamp)objects.get(0);
            Timestamp right = (Timestamp)objects.get(1);
            Timestamp predLowerBound = this.roundupToMinuteFloor(left);
            Timestamp predUpperBound = this.roundupToMinuteCeil(right);
            for (FileStatus fileStatus : inputFiles) {
                Timestamp fileLowerBound = SyslogInputFormat.getTimeStampFromPath(fileStatus);
                if (fileLowerBound != null) {
                    Timestamp fileUpperBound = Timestamp.from(fileLowerBound.toInstant().plusSeconds(timeSliceSeconds));
                    Location predUpperLocation = null;
                    Location predLowerLocation = this.compareToRange(predLowerBound, fileLowerBound, fileUpperBound);
                    boolean selected = false;
                    if (predLowerLocation == Location.BEFORE || predLowerLocation == Location.MIN) {
                        predUpperLocation = this.compareToRange(predUpperBound, fileLowerBound, fileUpperBound);
                        if (predUpperLocation == Location.AFTER || predUpperLocation == Location.MAX) {
                            selectedFiles.add(fileStatus);
                            selected = true;
                        } else if (predUpperLocation != Location.BEFORE) {
                            selectedFiles.add(fileStatus);
                            selected = true;
                        }
                    } else if (predLowerLocation != Location.AFTER) {
                        selectedFiles.add(fileStatus);
                        selected = true;
                    }
                    LOG.info("file: {} -> [{}, {}] against predicate [{}({}), {}({})]. selected? {}", new Object[]{fileStatus.getPath(), fileLowerBound.toInstant(), fileUpperBound.toInstant(), predLowerBound.toInstant(), predLowerLocation, predUpperBound.toInstant(), predUpperLocation, selected});
                    continue;
                }
                LOG.warn("Timestamp cannot be extracted from filename. Incorrect file name convention? {}", (Object)fileStatus.getPath());
                return inputFiles;
            }
            LOG.info("Total selected files: {}", (Object)selectedFiles.size());
            return selectedFiles;
        }
        LOG.warn("Unsupported expression ({}) on 'ts' column. Skipping file pruning..", (Object)tsPred.getOperator());
        return inputFiles;
    }

    private Timestamp roundupToMinuteFloor(Timestamp ts) {
        long millis = ts.getTime();
        long newMillis = 60000L * (millis / 60000L);
        return new Timestamp(newMillis);
    }

    private Timestamp roundupToMinuteCeil(Timestamp ts) {
        long millis = ts.getTime();
        long newMillis = 60000L * (millis / 60000L);
        return new Timestamp(newMillis += 60000L);
    }

    private static Timestamp getTimeStampFromPath(FileStatus fileStatus) {
        String[] tsTokens;
        String tsStr;
        String file = fileStatus.getPath().getName();
        if (file.contains("_") && (tsStr = file.split("_")[0]).contains("-") && (tsTokens = tsStr.split("-")).length == 5) {
            try {
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.getDefault());
                int year = Integer.parseUnsignedInt(tsTokens[0]);
                int month = Integer.parseUnsignedInt(tsTokens[1]);
                int day = Integer.parseUnsignedInt(tsTokens[2]);
                int hour = Integer.parseUnsignedInt(tsTokens[3]);
                int min = Integer.parseUnsignedInt(tsTokens[4]);
                calendar.set(year, month - 1, day, hour, min, 0);
                Timestamp ts = new Timestamp(calendar.getTimeInMillis());
                ts.setNanos(0);
                return ts;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private <T> Location compareToRange(Comparable<T> point, T min, T max) {
        int minCompare = point.compareTo(min);
        if (minCompare < 0) {
            return Location.BEFORE;
        }
        if (minCompare == 0) {
            return Location.MIN;
        }
        int maxCompare = point.compareTo(max);
        if (maxCompare > 0) {
            return Location.AFTER;
        }
        return maxCompare == 0 ? Location.MAX : Location.MIDDLE;
    }

    public RecordReader<LongWritable, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        if (genericSplit instanceof FileSplit) {
            Path finalPath = ((FileSplit)genericSplit).getPath();
            LOG.debug("Returning record reader for path {}", (Object)finalPath);
            this.jobConf = this.projectionPusher.pushProjectionsAndFilters(job, finalPath.getParent());
        }
        this.jobConf.set("textinputformat.record.delimiter", "\n");
        return super.getRecordReader(genericSplit, this.jobConf, reporter);
    }

    static enum Location {
        BEFORE,
        MIN,
        MIDDLE,
        MAX,
        AFTER;

    }
}

