/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.ParallelEdgeFixer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.graph.OperatorGraph;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedWorkOptimizer
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger(SharedWorkOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LOG.info("SharedWorkOptimizer start");
        Map<String, TableScanOperator> topOps = pctx.getTopOps();
        if (topOps.size() < 2) {
            return pctx;
        }
        ListMultimap<String, TableScanOperator> tableNameToOps = SharedWorkOptimizer.splitTableScanOpsByTable(pctx);
        boolean tablesReferencedOnlyOnce = tableNameToOps.asMap().entrySet().stream().noneMatch(e -> ((Collection)e.getValue()).size() > 1);
        if (tablesReferencedOnlyOnce) {
            return pctx;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before SharedWorkOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
        }
        List<Map.Entry<String, Long>> sortedTables = SharedWorkOptimizer.rankTablesByAccumulatedSize(pctx);
        LOG.debug("Sorted tables by size: {}", sortedTables);
        SharedWorkOptimizerCache optimizerCache = new SharedWorkOptimizerCache();
        SharedWorkOptimizer.gatherDPPTableScanOps(pctx, optimizerCache);
        int batchSize = HiveConf.getIntVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SHARED_WORK_MAX_SIBLINGS);
        Preconditions.checkArgument((batchSize == -1 || batchSize > 0 ? 1 : 0) != 0, (String)"%s must be -1 or greater than 0", (Object)HiveConf.ConfVars.HIVE_SHARED_WORK_MAX_SIBLINGS.varname);
        for (List<TableScanOperator> scans : SharedWorkOptimizer.groupTableScanOperators(sortedTables, tableNameToOps, batchSize)) {
            boolean optimized;
            this.runSharedWorkOptimization(pctx, optimizerCache, scans, Mode.SubtreeMerge);
            if (LOG.isDebugEnabled()) {
                LOG.debug("After SharedWorkOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
            }
            if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_EXTENDED_OPTIMIZATION)) {
                SharedWorkOptimizer.sharedWorkExtendedOptimization(pctx, optimizerCache);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("After SharedWorkExtendedOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
                }
            }
            if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_SEMIJOIN_OPTIMIZATION)) {
                optimized = this.runSharedWorkOptimization(pctx, optimizerCache, scans, Mode.RemoveSemijoin);
                if (optimized && pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_EXTENDED_OPTIMIZATION)) {
                    SharedWorkOptimizer.sharedWorkExtendedOptimization(pctx, optimizerCache);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("After SharedWorkSJOptimizer:\n" + Operator.toString(pctx.getTopOps().values()));
                }
            }
            if (!pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_DPPUNION_OPTIMIZATION)) continue;
            optimized = this.runSharedWorkOptimization(pctx, optimizerCache, scans, Mode.DPPUnion);
            if (optimized && pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_EXTENDED_OPTIMIZATION)) {
                SharedWorkOptimizer.sharedWorkExtendedOptimization(pctx, optimizerCache);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("After DPPUnion:\n" + Operator.toString(pctx.getTopOps().values()));
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_REUSE_MAPJOIN_CACHE)) {
            this.runMapJoinCacheReuseOptimization(pctx, optimizerCache);
        }
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            HashSet<Operator> visited = new HashSet<Operator>();
            for (Map.Entry<String, TableScanOperator> e2 : topOps.entrySet()) {
                for (Operator op : OperatorUtils.findOperators(e2.getValue(), Operator.class)) {
                    Set<Operator<?>> workPlanOps;
                    if (visited.contains(op)) continue;
                    Set<Operator<?>> workCachedOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, op);
                    if (!workCachedOps.equals(workPlanOps = SharedWorkOptimizer.findWorkOperators(op, new HashSet()))) {
                        throw new SemanticException("Error in shared work optimizer: operator cache contents and actual plan differ\nIn cache: " + String.valueOf(workCachedOps) + "\nIn plan: " + String.valueOf(workPlanOps));
                    }
                    visited.add(op);
                }
            }
        }
        LOG.info("SharedWorkOptimizer end");
        return pctx;
    }

    private static List<List<TableScanOperator>> groupTableScanOperators(List<Map.Entry<String, Long>> sortedTables, ListMultimap<String, TableScanOperator> tableNameToOps, int batchSize) {
        if (batchSize == -1) {
            return sortedTables.stream().map(entry -> tableNameToOps.get((Object)((String)entry.getKey()))).collect(Collectors.toList());
        }
        ArrayList<List<TableScanOperator>> batches = new ArrayList<List<TableScanOperator>>();
        for (Map.Entry<String, Long> tablePair : sortedTables) {
            String tableName = tablePair.getKey();
            List scans = tableNameToOps.get((Object)tableName);
            int limit = scans.size();
            int from = 0;
            while (from != limit) {
                int to = Math.min(limit, from + batchSize);
                ArrayList subList = new ArrayList(scans.subList(from, to));
                batches.add(subList);
                from = to;
            }
        }
        return batches;
    }

    private boolean runSharedWorkOptimization(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, List<TableScanOperator> scans, Mode mode) throws SemanticException {
        boolean ret = false;
        ret |= this.sharedWorkOptimization(pctx, optimizerCache, scans, mode, false);
        if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_MERGE_TS_SCHEMA)) {
            ret |= this.sharedWorkOptimization(pctx, optimizerCache, scans, mode, true);
        }
        return ret;
    }

    public boolean sharedWorkOptimization(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, List<TableScanOperator> tableScans, Mode mode, boolean schemaMerge) throws SemanticException {
        boolean mergedExecuted = false;
        LinkedHashSet<TableScanOperator> retainedScans = new LinkedHashSet<TableScanOperator>();
        HashSet removedOps = new HashSet();
        for (TableScanOperator discardableTsOp : tableScans) {
            TableName tableName1 = discardableTsOp.getTableName();
            if (discardableTsOp.getNumChild() == 0) {
                removedOps.add(discardableTsOp);
            }
            if (removedOps.contains(discardableTsOp)) {
                LOG.debug("Skip {} as it has already been removed", (Object)discardableTsOp);
                continue;
            }
            for (TableScanOperator retainableTsOp : retainedScans) {
                SharedResult sr;
                if (optimizerCache.getWorkGroup(discardableTsOp).contains(retainableTsOp)) {
                    LOG.trace("No need check further {} and {} are in the same group", (Object)discardableTsOp, (Object)retainableTsOp);
                    continue;
                }
                if (removedOps.contains(retainableTsOp)) {
                    LOG.debug("Skip {} as it has already been removed", (Object)retainableTsOp);
                    continue;
                }
                LOG.debug("Can we merge {} into {} to remove a scan on {}?", new Object[]{discardableTsOp, retainableTsOp, tableName1});
                String metaTable1 = ((TableScanDesc)retainableTsOp.getConf()).getTableMetadata().getMetaTable();
                String metaTable2 = ((TableScanDesc)discardableTsOp.getConf()).getTableMetadata().getMetaTable();
                if (metaTable1 != null || metaTable2 != null) {
                    LOG.info("Skip the schema merging as the query contains Iceberg metadata table.");
                    continue;
                }
                if (!schemaMerge && !SharedWorkOptimizer.compatibleSchema(retainableTsOp, discardableTsOp)) {
                    LOG.debug("incompatible schemas: {} {} for {} (and merge disabled)", new Object[]{discardableTsOp, retainableTsOp, tableName1});
                    continue;
                }
                if (mode == Mode.RemoveSemijoin) {
                    mergeable = this.areMergeable(pctx, retainableTsOp, discardableTsOp);
                    if (!mergeable) {
                        LOG.debug("{} and {} cannot be merged", (Object)retainableTsOp, (Object)discardableTsOp);
                        continue;
                    }
                    validMerge = SharedWorkOptimizer.areMergeableExcludeSemijoinsExtendedCheck(pctx, optimizerCache, retainableTsOp, discardableTsOp);
                    if (!validMerge) {
                        LOG.debug("{} and {} do not meet preconditions", (Object)retainableTsOp, (Object)discardableTsOp);
                        continue;
                    }
                    sr = SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, retainableTsOp, discardableTsOp, true, true);
                } else if (mode == Mode.DPPUnion) {
                    mergeable = this.areMergeable(pctx, retainableTsOp, discardableTsOp);
                    if (!mergeable) {
                        LOG.debug("{} and {} cannot be merged", (Object)retainableTsOp, (Object)discardableTsOp);
                        continue;
                    }
                    validMerge = SharedWorkOptimizer.areMergeableDppUnion(pctx, optimizerCache, retainableTsOp, discardableTsOp);
                    if (!validMerge) {
                        LOG.debug("{} and {} do not meet preconditions", (Object)retainableTsOp, (Object)discardableTsOp);
                        continue;
                    }
                    sr = SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, retainableTsOp, discardableTsOp, false, false);
                    if (!SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, sr)) {
                        continue;
                    }
                } else if (mode == Mode.SubtreeMerge) {
                    if (!this.areMergeable(pctx, retainableTsOp, discardableTsOp) || !SharedWorkOptimizer.areMergeableExtendedCheck(pctx, optimizerCache, retainableTsOp, discardableTsOp)) {
                        LOG.debug("{} and {} cannot be merged", (Object)retainableTsOp, (Object)discardableTsOp);
                        continue;
                    }
                    sr = SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, retainableTsOp, discardableTsOp, true, true);
                    if (!SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, sr)) {
                        LOG.debug("{} and {} do not meet preconditions", (Object)retainableTsOp, (Object)discardableTsOp);
                        continue;
                    }
                } else {
                    throw new RuntimeException("unhandled mode: " + String.valueOf((Object)mode));
                }
                mergedExecuted = true;
                if (mode != Mode.DPPUnion && sr.retainableOps.size() > 1) {
                    Operator<?> lastRetainableOp = sr.retainableOps.get(sr.retainableOps.size() - 1);
                    Operator<?> lastDiscardableOp = sr.discardableOps.get(sr.discardableOps.size() - 1);
                    if (lastDiscardableOp.getNumChild() != 0) {
                        ArrayList allChildren = Lists.newArrayList(lastDiscardableOp.getChildOperators());
                        for (Operator op : allChildren) {
                            lastDiscardableOp.getChildOperators().remove(op);
                            op.replaceParent(lastDiscardableOp, lastRetainableOp);
                            lastRetainableOp.getChildOperators().add(op);
                        }
                    }
                    LOG.debug("Merging subtree starting at {} into subtree starting at {}", (Object)discardableTsOp, (Object)retainableTsOp);
                } else {
                    if (sr.discardableOps.size() > 1) {
                        throw new RuntimeException("we can't discard more in this path");
                    }
                    DecomposedTs modelR = new DecomposedTs(retainableTsOp);
                    DecomposedTs modelD = new DecomposedTs(discardableTsOp);
                    SharedWorkOptimizer.pushFilterToTopOfTableScan(optimizerCache, modelR);
                    if (mode == Mode.RemoveSemijoin || mode == Mode.SubtreeMerge) {
                        SharedWorkOptimizer.replaceSemijoinExpressions(discardableTsOp, modelR.getSemiJoinFilter());
                    }
                    modelD.replaceTabAlias(((TableScanDesc)discardableTsOp.getConf()).getAlias(), ((TableScanDesc)retainableTsOp.getConf()).getAlias());
                    SharedWorkOptimizer.pushFilterToTopOfTableScan(optimizerCache, modelD);
                    ExprNodeDesc exprNode = null;
                    if (modelR.normalFilterExpr != null && modelD.normalFilterExpr != null) {
                        exprNode = ExprNodeDescUtils.disjunction(modelR.normalFilterExpr, modelD.normalFilterExpr);
                    }
                    List<ExprNodeDesc> semiJoinExpr = null;
                    if (mode == Mode.DPPUnion) {
                        assert (modelR.semijoinExprNodes != null);
                        assert (modelD.semijoinExprNodes != null);
                        ExprNodeDesc disjunction = ExprNodeDescUtils.disjunction(ExprNodeDescUtils.conjunction(modelR.semijoinExprNodes), ExprNodeDescUtils.conjunction(modelD.semijoinExprNodes));
                        semiJoinExpr = disjunction == null ? null : Lists.newArrayList((Object[])new ExprNodeDesc[]{disjunction});
                    } else {
                        semiJoinExpr = modelR.semijoinExprNodes;
                    }
                    exprNode = ExprNodeDescUtils.conjunction(semiJoinExpr, exprNode);
                    ((TableScanDesc)retainableTsOp.getConf()).setFilterExpr((ExprNodeGenericFuncDesc)exprNode);
                    SharedWorkOptimizer.adoptChildren(retainableTsOp, discardableTsOp);
                    LOG.debug("Merging {} into {}", (Object)discardableTsOp, (Object)retainableTsOp);
                }
                if (mode != Mode.DPPUnion) {
                    for (Operator<?> op : sr.discardableInputOps) {
                        DynamicPruningEventDesc dped;
                        OperatorUtils.removeOperator(op);
                        optimizerCache.removeOp(op);
                        removedOps.add(op);
                        if (op instanceof ReduceSinkOperator) {
                            SemiJoinBranchInfo sjbi = pctx.getRsToSemiJoinBranchInfo().get(op);
                            if (sjbi != null && !sr.discardableOps.contains(sjbi.getTsOp()) && !sr.discardableInputOps.contains(sjbi.getTsOp())) {
                                GenTezUtils.removeSemiJoinOperator(pctx, (ReduceSinkOperator)op, sjbi.getTsOp());
                                optimizerCache.tableScanToDPPSource.remove((Object)sjbi.getTsOp(), op);
                            }
                        } else if (op instanceof AppMasterEventOperator && !sr.discardableOps.contains((dped = (DynamicPruningEventDesc)op.getConf()).getTableScan()) && !sr.discardableInputOps.contains(dped.getTableScan())) {
                            GenTezUtils.removeSemiJoinOperator(pctx, (AppMasterEventOperator)op, dped.getTableScan());
                            optimizerCache.tableScanToDPPSource.remove((Object)dped.getTableScan(), op);
                        }
                        LOG.debug("Input operator removed: {}", op);
                    }
                }
                if (retainableTsOp.getProbeDecodeContext() != null) {
                    LOG.debug("Removing probeDecodeCntx for merged TS op {}", (Object)retainableTsOp);
                    retainableTsOp.setProbeDecodeContext(null);
                    ((TableScanDesc)retainableTsOp.getConf()).setProbeDecodeContext(null);
                }
                this.mergeSchema(discardableTsOp, retainableTsOp);
                if (mode == Mode.DPPUnion) {
                    Operator<?> op;
                    Collection discardableDPP = optimizerCache.tableScanToDPPSource.get((Object)discardableTsOp);
                    op = discardableDPP.iterator();
                    while (op.hasNext()) {
                        Operator op2 = (Operator)op.next();
                        if (op2 instanceof ReduceSinkOperator) {
                            SemiJoinBranchInfo sjInfo = pctx.getRsToSemiJoinBranchInfo().get(op2);
                            sjInfo.setTableScan(retainableTsOp);
                            continue;
                        }
                        if (!(op2.getConf() instanceof DynamicPruningEventDesc)) continue;
                        DynamicPruningEventDesc dynamicPruningEventDesc = (DynamicPruningEventDesc)op2.getConf();
                        dynamicPruningEventDesc.setTableScan(retainableTsOp);
                    }
                    optimizerCache.tableScanToDPPSource.get((Object)retainableTsOp).addAll(discardableDPP);
                    discardableDPP.clear();
                }
                optimizerCache.removeOpAndCombineWork(discardableTsOp, retainableTsOp);
                removedOps.add(discardableTsOp);
                for (Operator<?> op : sr.discardableOps) {
                    OperatorUtils.removeOperator(op);
                    optimizerCache.removeOp(op);
                    removedOps.add(op);
                    LOG.debug("Operator removed: {}", op);
                }
                if (!pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_DOWNSTREAM_MERGE) || sr.discardableOps.size() != 1) break;
                SharedWorkOptimizer.downStreamMerge(retainableTsOp, optimizerCache, pctx);
                break;
            }
            if (removedOps.contains(discardableTsOp)) {
                retainedScans.remove(discardableTsOp);
                continue;
            }
            retainedScans.add(discardableTsOp);
        }
        pctx.getTopOps().entrySet().removeIf(e -> ((TableScanOperator)e.getValue()).getNumChild() == 0);
        tableScans.removeAll(removedOps);
        return mergedExecuted;
    }

    protected boolean areMergeable(ParseContext pctx, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        if (((TableScanDesc)tsOp1.getConf()).getRowLimit() != ((TableScanDesc)tsOp2.getConf()).getRowLimit()) {
            LOG.debug("rowlimit differ {} ~ {}", (Object)((TableScanDesc)tsOp1.getConf()).getRowLimit(), (Object)((TableScanDesc)tsOp2.getConf()).getRowLimit());
            return false;
        }
        if (!Objects.equals(((TableScanDesc)tsOp1.getConf()).getOpProps(), ((TableScanDesc)tsOp2.getConf()).getOpProps())) {
            LOG.debug("opProps differ {} ~ {}", ((TableScanDesc)tsOp1.getConf()).getOpProps(), ((TableScanDesc)tsOp2.getConf()).getOpProps());
            return false;
        }
        PrunedPartitionList prevTsOpPPList = pctx.getPrunedPartitions(tsOp1);
        PrunedPartitionList tsOpPPList = pctx.getPrunedPartitions(tsOp2);
        if (!prevTsOpPPList.getPartitions().equals(tsOpPPList.getPartitions())) {
            LOG.debug("partitions differ {} ~ {}", (Object)prevTsOpPPList.getPartitions().size(), (Object)tsOpPPList.getPartitions().size());
            return false;
        }
        if (!Objects.equals(((TableScanDesc)tsOp1.getConf()).getIncludedBuckets(), ((TableScanDesc)tsOp2.getConf()).getIncludedBuckets())) {
            LOG.debug("includedBuckets differ {} ~ {}", (Object)((TableScanDesc)tsOp1.getConf()).getIncludedBuckets(), (Object)((TableScanDesc)tsOp2.getConf()).getIncludedBuckets());
            return false;
        }
        return true;
    }

    protected void mergeSchema(TableScanOperator discardableTsOp, TableScanOperator retainableTsOp) {
        Iterator<Object> iterator = ((TableScanDesc)discardableTsOp.getConf()).getNeededColumnIDs().iterator();
        while (iterator.hasNext()) {
            int colId = iterator.next();
            if (((TableScanDesc)retainableTsOp.getConf()).getNeededColumnIDs().contains(colId)) continue;
            ((TableScanDesc)retainableTsOp.getConf()).getNeededColumnIDs().add(colId);
        }
        for (String col : ((TableScanDesc)discardableTsOp.getConf()).getNeededColumns()) {
            if (((TableScanDesc)retainableTsOp.getConf()).getNeededColumns().contains(col)) continue;
            ((TableScanDesc)retainableTsOp.getConf()).getNeededColumns().add(col);
        }
        for (VirtualColumn col : ((TableScanDesc)discardableTsOp.getConf()).getVirtualCols()) {
            if (((TableScanDesc)retainableTsOp.getConf()).getVirtualCols().contains((Object)col)) continue;
            ((TableScanDesc)retainableTsOp.getConf()).getVirtualCols().add(col);
        }
    }

    private static boolean compatibleSchema(TableScanOperator tsOp1, TableScanOperator tsOp2) {
        return Objects.equals(tsOp1.getNeededColumns(), tsOp2.getNeededColumns()) && Objects.equals(tsOp1.getNeededColumnIDs(), tsOp2.getNeededColumnIDs()) && Objects.equals(((TableScanDesc)tsOp1.getConf()).getVirtualCols(), ((TableScanDesc)tsOp2.getConf()).getVirtualCols());
    }

    private static void replaceSemijoinExpressions(TableScanOperator tsOp, List<ExprNodeDesc> semijoinExprNodes) {
        ExprNodeGenericFuncDesc tsFilterExpr;
        ExprNodeConstantDesc constNode = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, Boolean.TRUE);
        if (((TableScanDesc)tsOp.getConf()).getFilterExpr() != null && FunctionRegistry.isOpAnd(tsFilterExpr = ((TableScanDesc)tsOp.getConf()).getFilterExpr())) {
            ((ExprNodeDesc)tsFilterExpr).getChildren().removeIf(SharedWorkOptimizer::isSemijoinExpr);
            ((ExprNodeDesc)tsFilterExpr).getChildren().addAll(semijoinExprNodes);
            if (((ExprNodeDesc)tsFilterExpr).getChildren().isEmpty() || ((ExprNodeDesc)tsFilterExpr).getChildren().size() == 1 && !(((ExprNodeDesc)tsFilterExpr).getChildren().get(0) instanceof ExprNodeGenericFuncDesc)) {
                ((TableScanDesc)tsOp.getConf()).setFilterExpr(null);
            }
        }
        if (tsOp.getChildOperators() != null) {
            for (Operator<OperatorDesc> op : tsOp.getChildOperators()) {
                FilterOperator filterOp;
                ExprNodeDesc filterExpr;
                if (!(op instanceof FilterOperator) || !FunctionRegistry.isOpAnd(filterExpr = ((FilterDesc)(filterOp = (FilterOperator)op).getConf()).getPredicate())) continue;
                filterExpr.getChildren().removeIf(SharedWorkOptimizer::isSemijoinExpr);
                if (filterExpr.getChildren().isEmpty()) {
                    ((FilterDesc)filterOp.getConf()).setPredicate(constNode);
                    continue;
                }
                if (filterExpr.getChildren().size() != 1) continue;
                ((FilterDesc)filterOp.getConf()).setPredicate(filterExpr.getChildren().get(0));
            }
        }
    }

    private static void downStreamMerge(Operator<?> op, SharedWorkOptimizerCache optimizerCache, ParseContext pctx) throws SemanticException {
        List<Operator<OperatorDesc>> childs = op.getChildOperators();
        for (int i = 0; i < childs.size(); ++i) {
            Operator<OperatorDesc> cI = childs.get(i);
            if (cI instanceof ReduceSinkOperator || cI instanceof JoinOperator || cI.getParentOperators().size() != 1) continue;
            for (int j = i + 1; j < childs.size(); ++j) {
                Operator<OperatorDesc> cJ = childs.get(j);
                if (!cI.logicalEquals(cJ)) continue;
                LOG.debug("downstream merge: from {} into {}", cJ, cI);
                SharedWorkOptimizer.adoptChildren(cI, cJ);
                op.removeChild(cJ);
                optimizerCache.removeOp(cJ);
                --j;
                SharedWorkOptimizer.downStreamMerge(cI, optimizerCache, pctx);
            }
        }
    }

    private static void adoptChildren(Operator<?> target, Operator<?> donor) {
        List<Operator<OperatorDesc>> children = donor.getChildOperators();
        for (Operator<OperatorDesc> c : children) {
            c.replaceParent(donor, target);
        }
        target.getChildOperators().addAll(children);
        children.clear();
    }

    private static boolean isSemijoinExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeDynamicListDesc) {
            return true;
        }
        if (FunctionRegistry.isOpBetween(expr) && expr.getChildren().get(2) instanceof ExprNodeDynamicValueDesc) {
            return true;
        }
        return FunctionRegistry.isOpInBloomFilter(expr) && expr.getChildren().get(1) instanceof ExprNodeDynamicValueDesc;
    }

    private static void splitExpressions(ExprNodeDesc exprNode, List<ExprNodeDesc> allExprNodesExceptSemijoin, List<ExprNodeDesc> semijoinExprNodes) {
        if (FunctionRegistry.isOpAnd(exprNode)) {
            for (ExprNodeDesc expr : exprNode.getChildren()) {
                if (SharedWorkOptimizer.isSemijoinExpr(expr)) {
                    semijoinExprNodes.add(expr);
                    continue;
                }
                allExprNodesExceptSemijoin.add(expr);
            }
        } else if (SharedWorkOptimizer.isSemijoinExpr(exprNode)) {
            semijoinExprNodes.add(exprNode);
        } else {
            allExprNodesExceptSemijoin.add(exprNode);
        }
    }

    private static void sharedWorkExtendedOptimization(ParseContext pctx, SharedWorkOptimizerCache optimizerCache) throws SemanticException {
        ArrayListMultimap parentToRsOps = ArrayListMultimap.create();
        HashSet<Operator<Object>> visited = new HashSet();
        for (Map.Entry<String, TableScanOperator> e2 : pctx.getTopOps().entrySet()) {
            SharedWorkOptimizer.gatherReduceSinkOpsByInput(parentToRsOps, visited, SharedWorkOptimizer.findWorkOperators(optimizerCache, e2.getValue()));
        }
        HashSet removedOps = new HashSet();
        while (!parentToRsOps.isEmpty()) {
            List<Map.Entry<Operator<?>, Long>> sortedRSGroups = SharedWorkOptimizer.rankOpsByAccumulatedSize(parentToRsOps.keySet());
            LOG.debug("Sorted operators by size: {}", sortedRSGroups);
            ArrayListMultimap existingRsOps = ArrayListMultimap.create();
            for (Map.Entry<Operator<?>, Long> rsGroupInfo : sortedRSGroups) {
                Operator<?> rsParent = rsGroupInfo.getKey();
                for (ReduceSinkOperator discardableRsOp : parentToRsOps.get(rsParent)) {
                    if (removedOps.contains(discardableRsOp)) {
                        LOG.debug("Skip {} as it has already been removed", (Object)discardableRsOp);
                        continue;
                    }
                    Collection otherRsOps = existingRsOps.get(rsParent);
                    for (ReduceSinkOperator retainableRsOp : otherRsOps) {
                        boolean mergeable;
                        if (retainableRsOp.getChildOperators().size() == 0) continue;
                        if (removedOps.contains(retainableRsOp)) {
                            LOG.debug("Skip {} as it has already been removed", (Object)retainableRsOp);
                            continue;
                        }
                        boolean bl = mergeable = SharedWorkOptimizer.compareOperator(pctx, retainableRsOp, discardableRsOp) && SharedWorkOptimizer.compareOperator(pctx, retainableRsOp.getChildOperators().get(0), discardableRsOp.getChildOperators().get(0));
                        if (!mergeable) {
                            LOG.debug("{} and {} cannot be merged", (Object)retainableRsOp, (Object)discardableRsOp);
                            continue;
                        }
                        LOG.debug("Checking additional conditions for merging subtree starting at {} into subtree starting at {}", (Object)discardableRsOp, (Object)retainableRsOp);
                        Operator<OperatorDesc> retainableRsOpChild = retainableRsOp.getChildOperators().get(0);
                        Operator<OperatorDesc> discardableRsOpChild = discardableRsOp.getChildOperators().get(0);
                        SharedResult sr = SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, retainableRsOp, discardableRsOp, retainableRsOpChild, discardableRsOpChild);
                        if (sr.retainableOps.isEmpty() || !SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, sr)) {
                            LOG.debug("{} and {} do not meet preconditions", (Object)retainableRsOp, (Object)discardableRsOp);
                            continue;
                        }
                        SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)retainableRsOp.getConf(), (ReduceSinkDesc)discardableRsOp.getConf());
                        Operator<?> lastRetainableOp = sr.retainableOps.get(sr.retainableOps.size() - 1);
                        Operator<?> lastDiscardableOp = sr.discardableOps.get(sr.discardableOps.size() - 1);
                        if (lastDiscardableOp.getNumChild() != 0) {
                            ArrayList allChildren = Lists.newArrayList(lastDiscardableOp.getChildOperators());
                            for (Operator op : allChildren) {
                                lastDiscardableOp.getChildOperators().remove(op);
                                op.replaceParent(lastDiscardableOp, lastRetainableOp);
                                lastRetainableOp.getChildOperators().add(op);
                            }
                        }
                        LOG.debug("Merging subtree starting at {} into subtree starting at {}", (Object)discardableRsOp, (Object)retainableRsOp);
                        for (Operator<?> op : sr.discardableInputOps) {
                            DynamicPruningEventDesc dped;
                            OperatorUtils.removeOperator(op);
                            optimizerCache.removeOp(op);
                            removedOps.add(op);
                            if (op instanceof ReduceSinkOperator) {
                                SemiJoinBranchInfo sjbi = pctx.getRsToSemiJoinBranchInfo().get(op);
                                if (sjbi != null && !sr.discardableOps.contains(sjbi.getTsOp()) && !sr.discardableInputOps.contains(sjbi.getTsOp())) {
                                    GenTezUtils.removeSemiJoinOperator(pctx, (ReduceSinkOperator)op, sjbi.getTsOp());
                                    optimizerCache.tableScanToDPPSource.remove((Object)sjbi.getTsOp(), op);
                                }
                            } else if (op instanceof AppMasterEventOperator && !sr.discardableOps.contains((dped = (DynamicPruningEventDesc)op.getConf()).getTableScan()) && !sr.discardableInputOps.contains(dped.getTableScan())) {
                                GenTezUtils.removeSemiJoinOperator(pctx, (AppMasterEventOperator)op, dped.getTableScan());
                                optimizerCache.tableScanToDPPSource.remove((Object)dped.getTableScan(), op);
                            }
                            LOG.debug("Input operator removed: {}", op);
                        }
                        OperatorUtils.removeOperator(discardableRsOp);
                        optimizerCache.removeOp(discardableRsOp);
                        removedOps.add(discardableRsOp);
                        LOG.debug("Operator removed: {}", (Object)discardableRsOp);
                        optimizerCache.removeOpAndCombineWork(discardableRsOpChild, retainableRsOpChild);
                        for (Operator<?> op : sr.discardableOps) {
                            OperatorUtils.removeOperator(op);
                            optimizerCache.removeOp(op);
                            removedOps.add(op);
                            LOG.debug("Operator removed: {}", op);
                        }
                        if (!pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_DOWNSTREAM_MERGE) || sr.discardableOps.size() != 1) break;
                        SharedWorkOptimizer.downStreamMerge(retainableRsOp, optimizerCache, pctx);
                        break;
                    }
                    if (removedOps.contains(discardableRsOp)) {
                        existingRsOps.remove(rsParent, (Object)discardableRsOp);
                        continue;
                    }
                    existingRsOps.put(rsParent, (Object)discardableRsOp);
                }
            }
            parentToRsOps = ArrayListMultimap.create();
            visited = new HashSet();
            for (Map.Entry<Operator<Object>, Long> e3 : existingRsOps.entries()) {
                if (removedOps.contains(e3.getValue()) || ((ReduceSinkOperator)((Object)e3.getValue())).getNumChild() < 1) continue;
                SharedWorkOptimizer.gatherReduceSinkOpsByInput(parentToRsOps, visited, SharedWorkOptimizer.findWorkOperators(optimizerCache, ((ReduceSinkOperator)((Object)e3.getValue())).getChildOperators().get(0)));
            }
        }
        pctx.getTopOps().entrySet().removeIf(e -> ((TableScanOperator)e.getValue()).getNumChild() == 0);
    }

    @VisibleForTesting
    public void runMapJoinCacheReuseOptimization(ParseContext pctx, SharedWorkOptimizerCache optimizerCache) throws SemanticException {
        ArrayListMultimap parentToMapJoinOperators = ArrayListMultimap.create();
        for (Set<Operator<?>> workOperators : optimizerCache.getWorkGroups()) {
            for (Operator<?> op : workOperators) {
                MapJoinOperator mapJoinOp;
                if (!(op instanceof MapJoinOperator) || ((MapJoinDesc)(mapJoinOp = (MapJoinOperator)op).getConf()).isBucketMapJoin() || ((MapJoinDesc)mapJoinOp.getConf()).isDynamicPartitionHashJoin()) continue;
                parentToMapJoinOperators.put(this.obtainFirstBroadcastInput(mapJoinOp).getParentOperators().get(0), (Object)mapJoinOp);
            }
        }
        for (Collection c : parentToMapJoinOperators.asMap().values()) {
            HashMap<MapJoinOperator, String> mapJoinOpToCacheKey = new HashMap<MapJoinOperator, String>();
            for (MapJoinOperator mapJoinOp : c) {
                String cacheKey = null;
                for (Map.Entry e : mapJoinOpToCacheKey.entrySet()) {
                    if (!this.canShareBroadcastInputs(pctx, mapJoinOp, (MapJoinOperator)e.getKey())) continue;
                    cacheKey = (String)e.getValue();
                    break;
                }
                if (cacheKey == null) {
                    cacheKey = MapJoinDesc.generateCacheKey(mapJoinOp.getOperatorId());
                    mapJoinOpToCacheKey.put(mapJoinOp, cacheKey);
                }
                ((MapJoinDesc)mapJoinOp.getConf()).setCacheKey(cacheKey);
            }
        }
    }

    private ReduceSinkOperator obtainFirstBroadcastInput(MapJoinOperator mapJoinOp) {
        return mapJoinOp.getParentOperators().get(0) instanceof ReduceSinkOperator ? (ReduceSinkOperator)mapJoinOp.getParentOperators().get(0) : (ReduceSinkOperator)mapJoinOp.getParentOperators().get(1);
    }

    private boolean canShareBroadcastInputs(ParseContext pctx, MapJoinOperator mapJoinOp1, MapJoinOperator mapJoinOp2) throws SemanticException {
        if (mapJoinOp1.getNumParent() != mapJoinOp2.getNumParent()) {
            return false;
        }
        if (((MapJoinDesc)mapJoinOp1.getConf()).getPosBigTable() != ((MapJoinDesc)mapJoinOp2.getConf()).getPosBigTable()) {
            return false;
        }
        if (ArrayUtils.isNotEmpty((Object[])((MapJoinDesc)mapJoinOp1.getConf()).getConds()) && ArrayUtils.isNotEmpty((Object[])((MapJoinDesc)mapJoinOp2.getConf()).getConds()) && ((MapJoinDesc)mapJoinOp1.getConf()).getConds()[0].getType() != ((MapJoinDesc)mapJoinOp2.getConf()).getConds()[0].getType() && (((MapJoinDesc)mapJoinOp1.getConf()).isNoOuterJoin() || ((MapJoinDesc)mapJoinOp2.getConf()).isNoOuterJoin())) {
            return false;
        }
        for (int i = 0; i < mapJoinOp1.getNumParent(); ++i) {
            Operator<OperatorDesc> grandParent2;
            ReduceSinkOperator parentRS2;
            if (i == ((MapJoinDesc)mapJoinOp1.getConf()).getPosBigTable()) continue;
            ReduceSinkOperator parentRS1 = (ReduceSinkOperator)mapJoinOp1.getParentOperators().get(i);
            if (!SharedWorkOptimizer.compareOperator(pctx, parentRS1, parentRS2 = (ReduceSinkOperator)mapJoinOp2.getParentOperators().get(i))) {
                return false;
            }
            Operator<OperatorDesc> grandParent1 = parentRS1.getParentOperators().get(0);
            if (grandParent1 == (grandParent2 = parentRS2.getParentOperators().get(0))) continue;
            return false;
        }
        return true;
    }

    private static void gatherDPPTableScanOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache) throws SemanticException {
        Map<String, TableScanOperator> topOps = pctx.getTopOps();
        ArrayList tableScanOps = Lists.newArrayList(topOps.values());
        Set<AppMasterEventOperator> s = OperatorUtils.findOperators(tableScanOps, AppMasterEventOperator.class);
        for (AppMasterEventOperator appMasterEventOperator : s) {
            if (!(appMasterEventOperator.getConf() instanceof DynamicPruningEventDesc)) continue;
            DynamicPruningEventDesc dped = (DynamicPruningEventDesc)appMasterEventOperator.getConf();
            optimizerCache.tableScanToDPPSource.put((Object)dped.getTableScan(), (Object)appMasterEventOperator);
        }
        for (Map.Entry entry : pctx.getRsToSemiJoinBranchInfo().entrySet()) {
            optimizerCache.tableScanToDPPSource.put((Object)((SemiJoinBranchInfo)entry.getValue()).getTsOp(), (Object)((Operator)entry.getKey()));
        }
        LOG.debug("DPP information stored in the cache: {}", optimizerCache.tableScanToDPPSource);
    }

    private static ListMultimap<String, TableScanOperator> splitTableScanOpsByTable(ParseContext pctx) {
        ArrayListMultimap tableNameToOps = ArrayListMultimap.create();
        TSComparator comparator = new TSComparator();
        PriorityQueue<TableScanOperator> sortedTopOps = new PriorityQueue<TableScanOperator>(comparator);
        sortedTopOps.addAll(pctx.getTopOps().values());
        for (TableScanOperator tsOp : sortedTopOps) {
            tableNameToOps.put((Object)tsOp.getTableName().toString(), (Object)tsOp);
        }
        return tableNameToOps;
    }

    private static List<Map.Entry<String, Long>> rankTablesByAccumulatedSize(ParseContext pctx) {
        HashMap<String, Long> tableToTotalSize = new HashMap<String, Long>();
        for (Map.Entry<String, TableScanOperator> e : pctx.getTopOps().entrySet()) {
            TableScanOperator tsOp = e.getValue();
            String tableName = tsOp.getTableName().toString();
            long tableSize = tsOp.getStatistics() != null ? tsOp.getStatistics().getDataSize() : 0L;
            Long totalSize = (Long)tableToTotalSize.get(tableName);
            if (totalSize != null) {
                tableToTotalSize.put(tableName, StatsUtils.safeAdd(totalSize, tableSize));
                continue;
            }
            tableToTotalSize.put(tableName, tableSize);
        }
        ArrayList<Map.Entry<String, Long>> sortedTables = new ArrayList<Map.Entry<String, Long>>(tableToTotalSize.entrySet());
        Collections.sort(sortedTables, Collections.reverseOrder(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }));
        return sortedTables;
    }

    private static void gatherReduceSinkOpsByInput(Multimap<Operator<?>, ReduceSinkOperator> parentToRsOps, Set<Operator<?>> visited, Set<Operator<?>> ops) {
        for (Operator<?> op : ops) {
            if (!(op instanceof ReduceSinkOperator) || visited.contains(op)) continue;
            Operator<OperatorDesc> parent = op.getParentOperators().get(0);
            LinkedHashSet<ReduceSinkOperator> s = new LinkedHashSet<ReduceSinkOperator>();
            for (Operator<OperatorDesc> c : parent.getChildOperators()) {
                if (!(c instanceof ReduceSinkOperator)) continue;
                s.add((ReduceSinkOperator)c);
                visited.add(c);
            }
            if (s.size() <= 1) continue;
            parentToRsOps.putAll(parent, s);
        }
    }

    private static List<Map.Entry<Operator<?>, Long>> rankOpsByAccumulatedSize(Set<Operator<?>> opsSet) {
        HashMap opToTotalSize = new HashMap();
        for (Operator<?> op : opsSet) {
            long size = op.getStatistics() != null ? op.getStatistics().getDataSize() : 0L;
            opToTotalSize.put(op, StatsUtils.safeMult((long)op.getChildOperators().size(), size));
        }
        ArrayList sortedOps = new ArrayList(opToTotalSize.entrySet());
        Collections.sort(sortedOps, Collections.reverseOrder(new Comparator<Map.Entry<Operator<?>, Long>>(){

            @Override
            public int compare(Map.Entry<Operator<?>, Long> o1, Map.Entry<Operator<?>, Long> o2) {
                int valCmp = o1.getValue().compareTo(o2.getValue());
                if (valCmp == 0) {
                    return o1.getKey().toString().compareTo(o2.getKey().toString());
                }
                return valCmp;
            }
        }));
        return sortedOps;
    }

    private static boolean areMergeableExtendedCheck(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        Set<Operator<?>> ascendants;
        Operator op;
        int i;
        ArrayList dppsOp1 = new ArrayList(optimizerCache.tableScanToDPPSource.get((Object)tsOp1));
        ArrayList dppsOp2 = new ArrayList(optimizerCache.tableScanToDPPSource.get((Object)tsOp2));
        if (dppsOp1.isEmpty() && dppsOp2.isEmpty()) {
            return true;
        }
        for (i = 0; i < dppsOp1.size(); ++i) {
            op = (Operator)dppsOp1.get(i);
            if (!(op instanceof ReduceSinkOperator) || !(ascendants = SharedWorkOptimizer.findAscendantOperators(optimizerCache, op)).contains(tsOp2)) continue;
            return false;
        }
        for (i = 0; i < dppsOp2.size(); ++i) {
            op = (Operator)dppsOp2.get(i);
            if (!(op instanceof ReduceSinkOperator) || !(ascendants = SharedWorkOptimizer.findAscendantOperators(optimizerCache, op)).contains(tsOp1)) continue;
            return false;
        }
        if (dppsOp1.size() != dppsOp2.size()) {
            return false;
        }
        BitSet bs = new BitSet();
        for (int i2 = 0; i2 < dppsOp1.size(); ++i2) {
            Operator dppOp1 = (Operator)dppsOp1.get(i2);
            for (int j = 0; j < dppsOp2.size(); ++j) {
                Operator dppOp2;
                if (bs.get(j) || SharedWorkOptimizer.compareAndGatherOps(pctx, optimizerCache, dppOp1, dppOp2 = (Operator)dppsOp2.get(j)) == null) continue;
                bs.set(j);
                break;
            }
            if (bs.cardinality() >= i2 + 1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean areMergeableExcludeSemijoinsExtendedCheck(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        ArrayList<ReduceSinkOperator> semijoinRsOps;
        TableScanOperator targetTSOp;
        ReduceSinkOperator semijoinRSOp;
        Operator op;
        int i;
        ArrayList dppsOp1 = new ArrayList(optimizerCache.tableScanToDPPSource.get((Object)tsOp1));
        boolean removedDppOp1 = false;
        ArrayList<ReduceSinkOperator> rsOpsSemijoin1 = new ArrayList<ReduceSinkOperator>();
        ArrayList dppsOp2 = new ArrayList(optimizerCache.tableScanToDPPSource.get((Object)tsOp2));
        boolean removedDppOp2 = false;
        ArrayList<ReduceSinkOperator> rsOpsSemijoin2 = new ArrayList<ReduceSinkOperator>();
        for (i = 0; i < dppsOp1.size(); ++i) {
            op = (Operator)dppsOp1.get(i);
            if (!(op instanceof ReduceSinkOperator)) continue;
            semijoinRSOp = (ReduceSinkOperator)op;
            if (pctx.getRsToSemiJoinBranchInfo().get(semijoinRSOp).getIsHint()) {
                return false;
            }
            rsOpsSemijoin1.add(semijoinRSOp);
            dppsOp1.remove(i);
            removedDppOp1 = true;
        }
        for (i = 0; i < dppsOp2.size(); ++i) {
            op = (Operator)dppsOp2.get(i);
            if (!(op instanceof ReduceSinkOperator)) continue;
            semijoinRSOp = (ReduceSinkOperator)op;
            if (pctx.getRsToSemiJoinBranchInfo().get(semijoinRSOp).getIsHint()) {
                return false;
            }
            rsOpsSemijoin2.add(semijoinRSOp);
            dppsOp2.remove(i);
            removedDppOp2 = true;
        }
        if (removedDppOp1 && removedDppOp2) {
            return false;
        }
        if (!removedDppOp1 && !removedDppOp2) {
            return false;
        }
        if (dppsOp1.size() != dppsOp2.size()) {
            return false;
        }
        boolean equalBranches = true;
        BitSet bs = new BitSet();
        for (int i2 = 0; i2 < dppsOp1.size(); ++i2) {
            Operator dppOp1 = (Operator)dppsOp1.get(i2);
            for (int j = 0; j < dppsOp2.size(); ++j) {
                Object dppOp2;
                if (bs.get(j) || SharedWorkOptimizer.compareAndGatherOps(pctx, optimizerCache, dppOp1, dppOp2 = (Operator)dppsOp2.get(j)) == null) continue;
                bs.set(j);
                break;
            }
            if (bs.cardinality() >= i2 + 1) continue;
            equalBranches = false;
            break;
        }
        if (!equalBranches) {
            return false;
        }
        ArrayList<SemiJoinBranchInfo> sjBranches = new ArrayList<SemiJoinBranchInfo>();
        if (removedDppOp1) {
            targetTSOp = tsOp1;
            semijoinRsOps = rsOpsSemijoin1;
        } else {
            targetTSOp = tsOp2;
            semijoinRsOps = rsOpsSemijoin2;
        }
        optimizerCache.tableScanToDPPSource.get((Object)targetTSOp).removeAll(semijoinRsOps);
        for (ReduceSinkOperator reduceSinkOperator : semijoinRsOps) {
            sjBranches.add((SemiJoinBranchInfo)pctx.getRsToSemiJoinBranchInfo().remove(reduceSinkOperator));
        }
        boolean validMerge = SharedWorkOptimizer.validPreConditions(pctx, optimizerCache, SharedWorkOptimizer.extractSharedOptimizationInfoForRoot(pctx, optimizerCache, tsOp1, tsOp2, true, true));
        if (validMerge) {
            for (ReduceSinkOperator semijoinRsOp : semijoinRsOps) {
                Operator<?> branchOp = GenTezUtils.removeBranch(semijoinRsOp);
                while (branchOp != null) {
                    optimizerCache.removeOp(branchOp);
                    branchOp = branchOp.getNumChild() > 0 ? branchOp.getChildOperators().get(0) : null;
                }
                GenTezUtils.removeSemiJoinOperator(pctx, semijoinRsOp, targetTSOp);
            }
        } else {
            void var16_23;
            optimizerCache.tableScanToDPPSource.get((Object)targetTSOp).addAll(semijoinRsOps);
            boolean bl = false;
            while (var16_23 < semijoinRsOps.size()) {
                pctx.getRsToSemiJoinBranchInfo().put((ReduceSinkOperator)semijoinRsOps.get((int)var16_23), (SemiJoinBranchInfo)sjBranches.get((int)var16_23));
                ++var16_23;
            }
        }
        return validMerge;
    }

    private static boolean areMergeableDppUnion(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator tsOp1, TableScanOperator tsOp2) throws SemanticException {
        if (!SharedWorkOptimizer.areSupportedDppUnionOps(pctx, optimizerCache, tsOp1, tsOp2)) {
            return false;
        }
        return SharedWorkOptimizer.areSupportedDppUnionOps(pctx, optimizerCache, tsOp2, tsOp1);
    }

    private static boolean areSupportedDppUnionOps(ParseContext pctx, SharedWorkOptimizerCache cache, TableScanOperator tsOp1, TableScanOperator tsOp2) {
        Collection dppOps = cache.tableScanToDPPSource.get((Object)tsOp1);
        if (dppOps.isEmpty()) {
            return false;
        }
        for (Operator op : dppOps) {
            if (op instanceof ReduceSinkOperator) {
                ReduceSinkOperator semijoinRSOp = (ReduceSinkOperator)op;
                if (!pctx.getRsToSemiJoinBranchInfo().get(semijoinRSOp).getIsHint()) continue;
                return false;
            }
            if (op.getConf() instanceof DynamicPruningEventDesc) {
                if (pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_DPPUNION_MERGE_EVENTOPS)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static SharedResult extractSharedOptimizationInfoForRoot(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, TableScanOperator retainableTsOp, TableScanOperator discardableTsOp, boolean mayRemoveDownStreamOperators, boolean mayRemoveInputOps) throws SemanticException {
        LinkedHashSet retainableOps = new LinkedHashSet();
        LinkedHashSet discardableOps = new LinkedHashSet();
        HashSet discardableInputOps = new HashSet();
        long dataSize = 0L;
        long maxDataSize = 0L;
        retainableOps.add(retainableTsOp);
        discardableOps.add(discardableTsOp);
        Operator equalOp1 = retainableTsOp;
        Operator equalOp2 = discardableTsOp;
        if (equalOp1.getNumChild() > 1 || equalOp2.getNumChild() > 1) {
            discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
            return SharedWorkOptimizer.createSharedResultForRoot(optimizerCache, retainableTsOp, discardableTsOp, retainableOps, discardableOps, discardableInputOps);
        }
        if (retainableTsOp.getChildOperators().size() == 0 || discardableTsOp.getChildOperators().size() == 0) {
            return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
        }
        Operator<OperatorDesc> currentOp1 = retainableTsOp.getChildOperators().get(0);
        Operator<OperatorDesc> currentOp2 = discardableTsOp.getChildOperators().get(0);
        if (mayRemoveDownStreamOperators && currentOp1 instanceof FilterOperator && currentOp2 instanceof FilterOperator) {
            Multiset<String> conjsOp2String;
            Multiset<String> conjsOp1String;
            boolean equalFilters = false;
            FilterDesc op1Conf = (FilterDesc)((FilterOperator)currentOp1).getConf();
            FilterDesc op2Conf = (FilterDesc)((FilterOperator)currentOp2).getConf();
            if (op1Conf.getIsSamplingPred() == op2Conf.getIsSamplingPred() && StringUtils.equals((CharSequence)op1Conf.getSampleDescExpr(), (CharSequence)op2Conf.getSampleDescExpr()) && (conjsOp1String = SharedWorkOptimizer.extractConjsIgnoringDPPPreds(op1Conf.getPredicate())).equals(conjsOp2String = SharedWorkOptimizer.extractConjsIgnoringDPPPreds(op2Conf.getPredicate()))) {
                equalFilters = true;
            }
            if (equalFilters) {
                equalOp1 = currentOp1;
                equalOp2 = currentOp2;
                retainableOps.add(equalOp1);
                discardableOps.add(equalOp2);
                if (currentOp1.getNumChild() > 1 || currentOp2.getNumChild() > 1) {
                    discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
                    discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
                    return SharedWorkOptimizer.createSharedResultForRoot(optimizerCache, retainableTsOp, discardableTsOp, retainableOps, discardableOps, discardableInputOps);
                }
                currentOp1 = currentOp1.getChildOperators().get(0);
                currentOp2 = currentOp2.getChildOperators().get(0);
            } else {
                discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, discardableOps));
                discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
                return SharedWorkOptimizer.createSharedResultForRoot(optimizerCache, retainableTsOp, discardableTsOp, retainableOps, discardableOps, discardableInputOps);
            }
        }
        return SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, equalOp1, equalOp2, currentOp1, currentOp2, retainableOps, discardableOps, discardableInputOps, mayRemoveDownStreamOperators, mayRemoveInputOps);
    }

    private static SharedResult createSharedResultForRoot(SharedWorkOptimizerCache optimizerCache, Operator<?> retainableOp, Operator<?> discardableOp, LinkedHashSet<Operator<?>> retainableOps, LinkedHashSet<Operator<?>> discardableOps, Set<Operator<?>> discardableInputOps) {
        long dataSize = 0L;
        long maxDataSize = 0L;
        Set<Operator<?>> opsWork1 = SharedWorkOptimizer.findWorkOperators(optimizerCache, retainableOp);
        for (Operator<?> op : opsWork1) {
            if (!(op instanceof MapJoinOperator)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            if (maxDataSize >= ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize()) continue;
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        Set<Operator<?>> opsWork2 = SharedWorkOptimizer.findWorkOperators(optimizerCache, discardableOp);
        for (Operator<?> op : opsWork2) {
            if (!(op instanceof MapJoinOperator)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            if (maxDataSize >= ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize()) continue;
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
    }

    private static SharedResult extractSharedOptimizationInfo(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> retainableOpEqualParent, Operator<?> discardableOpEqualParent, Operator<?> retainableOp, Operator<?> discardableOp) throws SemanticException {
        return SharedWorkOptimizer.extractSharedOptimizationInfo(pctx, optimizerCache, retainableOpEqualParent, discardableOpEqualParent, retainableOp, discardableOp, new LinkedHashSet(), new LinkedHashSet(), new HashSet(), true, true);
    }

    private static SharedResult extractSharedOptimizationInfo(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> retainableOpEqualParent, Operator<?> discardableOpEqualParent, Operator<?> retainableOp, Operator<?> discardableOp, LinkedHashSet<Operator<?>> retainableOps, LinkedHashSet<Operator<?>> discardableOps, Set<Operator<?>> discardableInputOps, boolean mayRemoveDownStreamOperators, boolean mayRemoveInputOps) throws SemanticException {
        Operator<?> equalOp1 = retainableOpEqualParent;
        Operator<?> equalOp2 = discardableOpEqualParent;
        Operator<Object> currentOp1 = retainableOp;
        Operator<Object> currentOp2 = discardableOp;
        long dataSize = 0L;
        long maxDataSize = 0L;
        while (mayRemoveDownStreamOperators && !(currentOp1 instanceof ReduceSinkOperator) && SharedWorkOptimizer.compareOperator(pctx, currentOp1, currentOp2) && currentOp1.getParentOperators().size() == currentOp2.getParentOperators().size()) {
            if (currentOp1.getParentOperators().size() > 1) {
                int idx;
                ArrayList discardableOpsForCurrentOp = new ArrayList();
                for (idx = 0; idx < currentOp1.getParentOperators().size(); ++idx) {
                    List<Operator<?>> removeOpsForCurrentInput;
                    Operator<OperatorDesc> parentOp1 = currentOp1.getParentOperators().get(idx);
                    Operator<OperatorDesc> parentOp2 = currentOp2.getParentOperators().get(idx);
                    if (parentOp1 == equalOp1 && parentOp2 == equalOp2) continue;
                    if (parentOp1 == equalOp1 && parentOp2 != equalOp2 || parentOp1 != equalOp1 && parentOp2 == equalOp2 || (removeOpsForCurrentInput = SharedWorkOptimizer.compareAndGatherOps(pctx, optimizerCache, parentOp1, parentOp2)) == null) break;
                    discardableOpsForCurrentOp.addAll(removeOpsForCurrentInput);
                }
                if (idx != currentOp1.getParentOperators().size()) break;
                discardableInputOps.addAll(discardableOpsForCurrentOp);
            }
            equalOp1 = currentOp1;
            equalOp2 = currentOp2;
            retainableOps.add(equalOp1);
            discardableOps.add(equalOp2);
            if (equalOp1 instanceof MapJoinOperator) {
                MapJoinOperator mop = (MapJoinOperator)equalOp1;
                dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
                if (maxDataSize < ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize()) {
                    maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
                }
            }
            if (currentOp1.getChildOperators().size() > 1 || currentOp2.getChildOperators().size() > 1) break;
            currentOp1 = currentOp1.getChildOperators().get(0);
            currentOp2 = currentOp2.getChildOperators().get(0);
        }
        Set<Operator<?>> opsWork1 = SharedWorkOptimizer.findWorkOperators(optimizerCache, currentOp1);
        for (Operator<?> op : opsWork1) {
            if (!(op instanceof MapJoinOperator) || retainableOps.contains(op)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            if (maxDataSize >= ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize()) continue;
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        Set<Operator<?>> opsWork2 = SharedWorkOptimizer.findWorkOperators(optimizerCache, currentOp2);
        for (Operator<?> op : opsWork2) {
            if (!(op instanceof MapJoinOperator) || discardableOps.contains(op)) continue;
            MapJoinOperator mop = (MapJoinOperator)op;
            dataSize = StatsUtils.safeAdd(dataSize, ((MapJoinDesc)mop.getConf()).getInMemoryDataSize());
            if (maxDataSize >= ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize()) continue;
            maxDataSize = ((MapJoinDesc)mop.getConf()).getMemoryMonitorInfo().getAdjustedNoConditionalTaskSize();
        }
        if (mayRemoveInputOps) {
            discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, Sets.union(discardableInputOps, discardableOps)));
            discardableInputOps.addAll(SharedWorkOptimizer.gatherDPPBranchOps(pctx, optimizerCache, retainableOps, discardableInputOps));
        }
        return new SharedResult(retainableOps, discardableOps, discardableInputOps, dataSize, maxDataSize);
    }

    private static Multiset<String> extractConjsIgnoringDPPPreds(ExprNodeDesc predicate) {
        List<ExprNodeDesc> conjsOp = ExprNodeDescUtils.split(predicate);
        TreeMultiset conjsOpString = TreeMultiset.create();
        for (int i = 0; i < conjsOp.size(); ++i) {
            ExprNodeGenericFuncDesc func;
            if (conjsOp.get(i) instanceof ExprNodeGenericFuncDesc ? GenericUDFInBloomFilter.class == (func = (ExprNodeGenericFuncDesc)conjsOp.get(i)).getGenericUDF().getClass() || GenericUDFBetween.class == func.getGenericUDF().getClass() && (func.getChildren().get(2) instanceof ExprNodeDynamicValueDesc || func.getChildren().get(3) instanceof ExprNodeDynamicValueDesc) : conjsOp.get(i) instanceof ExprNodeDynamicListDesc) continue;
            conjsOpString.add((Object)conjsOp.get(i).toString());
        }
        return conjsOpString;
    }

    private static Set<Operator<?>> gatherDPPBranchOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Set<Operator<?>> ops) {
        HashSet dppBranches = new HashSet();
        for (Operator<?> op : ops) {
            if (!(op instanceof TableScanOperator)) continue;
            Collection c = optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op));
            for (Operator dppSource : c) {
                SharedWorkOptimizer.removeBranch(dppSource, dppBranches, ops, optimizerCache);
            }
        }
        return dppBranches;
    }

    private static Set<Operator<?>> gatherDPPBranchOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Set<Operator<?>> ops, Set<Operator<?>> discardedOps) {
        HashSet dppBranches = new HashSet();
        for (Operator<?> op : ops) {
            if (!(op instanceof TableScanOperator)) continue;
            Collection c = optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op));
            for (Operator dppSource : c) {
                Set<Operator<?>> ascendants = SharedWorkOptimizer.findAscendantOperators(optimizerCache, dppSource);
                if (Collections.disjoint(ascendants, discardedOps)) continue;
                SharedWorkOptimizer.removeBranch(dppSource, dppBranches, ops, optimizerCache);
            }
        }
        return dppBranches;
    }

    private static void removeBranch(Operator<?> currentOp, Set<Operator<?>> branchesOps, Set<Operator<?>> discardableOps, SharedWorkOptimizerCache optimizerCache) {
        block5: {
            block4: {
                if (currentOp.getNumChild() > 1) {
                    for (Operator<OperatorDesc> childOp : currentOp.getChildOperators()) {
                        if (branchesOps.contains(childOp) || discardableOps.contains(childOp)) continue;
                        return;
                    }
                }
                branchesOps.add(currentOp);
                if (currentOp.getParentOperators() == null || currentOp.getParentOperators().size() <= 0) break block4;
                for (Operator<OperatorDesc> parentOp : currentOp.getParentOperators()) {
                    SharedWorkOptimizer.removeBranch(parentOp, branchesOps, discardableOps, optimizerCache);
                }
                break block5;
            }
            if (!(currentOp instanceof TableScanOperator)) break block5;
            Collection c = optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)currentOp));
            for (Operator dppSource : c) {
                SharedWorkOptimizer.removeBranch(dppSource, branchesOps, discardableOps, optimizerCache);
            }
        }
    }

    private static List<Operator<?>> compareAndGatherOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> op1, Operator<?> op2) throws SemanticException {
        ArrayList result = new ArrayList();
        boolean mergeable = SharedWorkOptimizer.compareAndGatherOps(pctx, optimizerCache, op1, op2, result, true);
        if (!mergeable) {
            return null;
        }
        return result;
    }

    private static boolean compareAndGatherOps(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> op1, Operator<?> op2, List<Operator<?>> result, boolean gather) throws SemanticException {
        Boolean areMergeable;
        if (!SharedWorkOptimizer.compareOperator(pctx, op1, op2)) {
            LOG.debug("Operators not equal: {} and {}", op1, op2);
            return false;
        }
        if (op1 instanceof TableScanOperator && !(areMergeable = Boolean.valueOf(SharedWorkOptimizer.areMergeableExtendedCheck(pctx, optimizerCache, (TableScanOperator)op1, (TableScanOperator)op2))).booleanValue()) {
            LOG.debug("Operators have different DPP parent: {} and {}", op1, op2);
            return false;
        }
        if (gather && op2.getChildOperators().size() > 1) {
            gather = false;
        }
        if (gather) {
            result.add(op2);
        }
        List<Operator<OperatorDesc>> op1ParentOperators = op1.getParentOperators();
        List<Operator<OperatorDesc>> op2ParentOperators = op2.getParentOperators();
        if (op1ParentOperators != null && op2ParentOperators != null) {
            if (op1ParentOperators.size() != op2ParentOperators.size()) {
                return false;
            }
            for (int i = 0; i < op1ParentOperators.size(); ++i) {
                Operator<OperatorDesc> op2ParentOp;
                Operator<OperatorDesc> op1ParentOp = op1ParentOperators.get(i);
                boolean mergeable = SharedWorkOptimizer.compareAndGatherOps(pctx, optimizerCache, op1ParentOp, op2ParentOp = op2ParentOperators.get(i), result, gather);
                if (mergeable) continue;
                return false;
            }
        } else if (op1ParentOperators != null || op2ParentOperators != null) {
            return false;
        }
        return true;
    }

    private static boolean compareOperator(ParseContext pctx, Operator<?> op1, Operator<?> op2) throws SemanticException {
        if (!op1.getClass().getName().equals(op2.getClass().getName())) {
            return false;
        }
        if (op1 instanceof ReduceSinkOperator) {
            ReduceSinkDesc op1Conf = (ReduceSinkDesc)((ReduceSinkOperator)op1).getConf();
            ReduceSinkDesc op2Conf = (ReduceSinkDesc)((ReduceSinkOperator)op2).getConf();
            return StringUtils.equals((CharSequence)op1Conf.getKeyColString(), (CharSequence)op2Conf.getKeyColString()) && StringUtils.equals((CharSequence)op1Conf.getValueColsString(), (CharSequence)op2Conf.getValueColsString()) && StringUtils.equals((CharSequence)op1Conf.getParitionColsString(), (CharSequence)op2Conf.getParitionColsString()) && op1Conf.getTag() == op2Conf.getTag() && StringUtils.equals((CharSequence)op1Conf.getOrder(), (CharSequence)op2Conf.getOrder()) && StringUtils.equals((CharSequence)op1Conf.getNullOrder(), (CharSequence)op2Conf.getNullOrder()) && op1Conf.getTopN() == op2Conf.getTopN() && SharedWorkOptimizer.canDeduplicateReduceTraits(op1Conf, op2Conf);
        }
        if (op1 instanceof TableScanOperator) {
            TableScanOperator tsOp1 = (TableScanOperator)op1;
            TableScanOperator tsOp2 = (TableScanOperator)op2;
            TableScanDesc op1Conf = (TableScanDesc)tsOp1.getConf();
            TableScanDesc op2Conf = (TableScanDesc)tsOp2.getConf();
            Table tableMeta1 = op1Conf.getTableMetadata();
            Table tableMeta2 = op2Conf.getTableMetadata();
            return StringUtils.equals((CharSequence)tableMeta1.getFullyQualifiedName(), (CharSequence)tableMeta2.getFullyQualifiedName()) && op1Conf.getNeededColumns().equals(op2Conf.getNeededColumns()) && StringUtils.equals((CharSequence)op1Conf.getFilterExprString(), (CharSequence)op2Conf.getFilterExprString()) && pctx.getPrunedPartitions(tsOp1).getPartitions().equals(pctx.getPrunedPartitions(tsOp2).getPartitions()) && op1Conf.getRowLimit() == op2Conf.getRowLimit() && Objects.equals(op1Conf.getIncludedBuckets(), op2Conf.getIncludedBuckets()) && Objects.equals(op1Conf.getOpProps(), op2Conf.getOpProps());
        }
        return op1.logicalEquals(op2);
    }

    private static boolean validPreConditions(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, SharedResult sr) {
        if (sr.dataSize > sr.maxDataSize) {
            LOG.debug("accumulated data size: {} / max size: {}", (Object)sr.dataSize, (Object)sr.maxDataSize);
            return false;
        }
        Operator<?> op1 = sr.retainableOps.get(0);
        Operator<?> op2 = sr.discardableOps.get(0);
        Set<Operator<?>> workOps1 = SharedWorkOptimizer.findWorkOperators(optimizerCache, op1);
        Set<Operator<?>> workOps2 = SharedWorkOptimizer.findWorkOperators(optimizerCache, op2);
        for (Operator<?> op : workOps1) {
            if (op instanceof UnionOperator) {
                return false;
            }
            if (!(op instanceof DummyStoreOperator)) continue;
            return false;
        }
        for (Operator<?> op : workOps2) {
            if (op instanceof UnionOperator) {
                return false;
            }
            if (!(op instanceof DummyStoreOperator)) continue;
            return false;
        }
        Set<Operator<?>> descendantWorksOps1 = SharedWorkOptimizer.findDescendantWorkOperators(pctx, optimizerCache, op1, sr.discardableInputOps);
        Set<Operator<?>> descendantWorksOps2 = SharedWorkOptimizer.findDescendantWorkOperators(pctx, optimizerCache, op2, sr.discardableInputOps);
        if (!Collections.disjoint(descendantWorksOps1, workOps2) || !Collections.disjoint(workOps1, descendantWorksOps2)) {
            return false;
        }
        RelaxedVertexEdgePredicate edgePredicate = pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_PARALLEL_EDGE_SUPPORT) ? new RelaxedVertexEdgePredicate(EnumSet.of(OperatorGraph.EdgeType.DPP, OperatorGraph.EdgeType.SEMIJOIN, OperatorGraph.EdgeType.BROADCAST)) : new RelaxedVertexEdgePredicate(EnumSet.of(OperatorGraph.EdgeType.DPP));
        OperatorGraph og = new OperatorGraph(pctx);
        Set<OperatorGraph.Cluster> clusterSet1 = og.clusterOf(op1);
        Set<OperatorGraph.Cluster> clusterSet2 = og.clusterOf(op2);
        for (OperatorGraph.Cluster cluster1 : clusterSet1) {
            for (OperatorGraph.Cluster cluster2 : clusterSet2) {
                Set<OperatorGraph.Cluster> cc2;
                Set<OperatorGraph.Cluster> cc1 = cluster1.childClusters(edgePredicate);
                if (Collections.disjoint(cc1, cc2 = cluster2.childClusters(edgePredicate))) continue;
                LOG.debug("merging {} and {} would create an unsupported parallel edge(CHILDS)", op1, op2);
                return false;
            }
        }
        if (!og.mayMerge(op1, op2)) {
            LOG.debug("merging {} and {} would violate dag properties", op1, op2);
            return false;
        }
        for (OperatorGraph.Cluster cluster1 : clusterSet1) {
            for (OperatorGraph.Cluster cluster2 : clusterSet2) {
                Set<OperatorGraph.Cluster> pc1 = cluster1.parentClusters(edgePredicate);
                Set<OperatorGraph.Cluster> pc2 = cluster2.parentClusters(edgePredicate);
                HashSet pc = new HashSet(Sets.intersection(pc1, pc2));
                for (Operator<OperatorDesc> operator : sr.discardableOps.get(0).getParentOperators()) {
                    pc.removeAll(og.clusterOf(operator));
                }
                for (Operator<OperatorDesc> operator : sr.discardableInputOps) {
                    pc.removeAll(og.clusterOf(operator));
                }
                if (pc.size() <= 0) continue;
                LOG.debug("merging {} and {} would create an unsupported parallel edge(PARENTS)", op1, op2);
                return false;
            }
        }
        return true;
    }

    private static Set<Operator<?>> findAscendantOperators(SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        HashSet visited = new HashSet();
        visited.add(start);
        LinkedList<Operator<OperatorDesc>> remaining = new LinkedList<Operator<OperatorDesc>>(start.getParentOperators());
        while (!remaining.isEmpty()) {
            Operator op = (Operator)remaining.poll();
            if (visited.contains(op)) continue;
            visited.add(op);
            if (op.getParentOperators() != null) {
                remaining.addAll(op.getParentOperators());
            }
            if (!(op instanceof TableScanOperator)) continue;
            remaining.addAll(optimizerCache.tableScanToDPPSource.get((Object)((TableScanOperator)op)));
        }
        return visited;
    }

    private static Set<Operator<?>> findDescendantWorkOperators(ParseContext pctx, SharedWorkOptimizerCache optimizerCache, Operator<?> start, Set<Operator<?>> excludeOps) {
        Set<Operator<?>> workOps = SharedWorkOptimizer.findWorkOperators(optimizerCache, start);
        HashSet result = new HashSet();
        while (!workOps.isEmpty()) {
            HashSet set = new HashSet();
            for (Operator<?> op : workOps) {
                if (excludeOps.contains(op)) continue;
                if (op instanceof ReduceSinkOperator) {
                    SemiJoinBranchInfo sjbi;
                    if (op.getChildOperators() != null) {
                        for (Operator<OperatorDesc> child : op.getChildOperators()) {
                            set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, child));
                        }
                    }
                    if ((sjbi = pctx.getRsToSemiJoinBranchInfo().get(op)) == null) continue;
                    set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, sjbi.getTsOp()));
                    continue;
                }
                if (!(op.getConf() instanceof DynamicPruningEventDesc)) continue;
                set.addAll(SharedWorkOptimizer.findWorkOperators(optimizerCache, ((DynamicPruningEventDesc)op.getConf()).getTableScan()));
            }
            workOps = set;
            result.addAll(set);
        }
        return result;
    }

    private static Set<Operator<?>> findWorkOperators(SharedWorkOptimizerCache optimizerCache, Operator<?> start) {
        Set<Operator<?>> c = optimizerCache.getWorkGroup(start);
        if (!c.isEmpty()) {
            return c;
        }
        c = SharedWorkOptimizer.findWorkOperators(start, new HashSet());
        optimizerCache.addWorkGroup(c);
        return c;
    }

    private static Set<Operator<?>> findWorkOperators(Operator<?> start, Set<Operator<?>> found) {
        found.add(start);
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                if (parent instanceof ReduceSinkOperator || found.contains(parent)) continue;
                SharedWorkOptimizer.findWorkOperators(parent, found);
            }
        }
        if (start instanceof ReduceSinkOperator) {
            return found;
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                if (found.contains(child)) continue;
                SharedWorkOptimizer.findWorkOperators(child, found);
            }
        }
        return found;
    }

    private static void pushFilterToTopOfTableScan(SharedWorkOptimizerCache optimizerCache, DecomposedTs tsModel) throws UDFArgumentException {
        TableScanOperator tsOp = tsModel.ts;
        ExprNodeGenericFuncDesc tableScanExprNode = (ExprNodeGenericFuncDesc)tsModel.getFullFilterExpr();
        if (tableScanExprNode == null) {
            return;
        }
        ArrayList allChildren = Lists.newArrayList(tsOp.getChildOperators());
        block0: for (Operator op : allChildren) {
            if (optimizerCache.isKnownFilteringOperator(op)) continue;
            if (op instanceof FilterOperator) {
                FilterOperator filterOp = (FilterOperator)op;
                ExprNodeDesc filterExprNode = ((FilterDesc)filterOp.getConf()).getPredicate();
                if (tableScanExprNode.isSame(filterExprNode)) {
                    optimizerCache.setKnownFilteringOperator(filterOp);
                    continue;
                }
                if (tableScanExprNode.getGenericUDF() instanceof GenericUDFOPOr) {
                    for (ExprNodeDesc childExprNode : tableScanExprNode.getChildren()) {
                        if (!childExprNode.isSame(filterExprNode)) continue;
                        optimizerCache.setKnownFilteringOperator(filterOp);
                        continue block0;
                    }
                }
                ExprNodeDesc newFilterExpr = ExprNodeDescUtils.conjunction(filterExprNode, (ExprNodeDesc)tableScanExprNode);
                if (!ExprNodeDescUtils.isSame(((FilterDesc)filterOp.getConf()).getPredicate(), newFilterExpr)) {
                    ((FilterDesc)filterOp.getConf()).setPredicate(newFilterExpr);
                }
                optimizerCache.setKnownFilteringOperator(filterOp);
                continue;
            }
            Operator<FilterDesc> newOp = OperatorFactory.get(tsOp.getCompilationOpContext(), new FilterDesc(tableScanExprNode.clone(), false), new RowSchema(tsOp.getSchema().getSignature()));
            tsOp.replaceChild(op, newOp);
            newOp.getParentOperators().add(tsOp);
            op.replaceParent(tsOp, newOp);
            newOp.getChildOperators().add(op);
            optimizerCache.putIfWorkExists(newOp, tsOp);
            optimizerCache.setKnownFilteringOperator(newOp);
        }
    }

    static boolean canDeduplicateReduceTraits(ReduceSinkDesc retainable, ReduceSinkDesc discardable) {
        return SharedWorkOptimizer.deduplicateReduceTraits(retainable, discardable, false);
    }

    static boolean deduplicateReduceTraits(ReduceSinkDesc retainable, ReduceSinkDesc discardable) {
        return SharedWorkOptimizer.deduplicateReduceTraits(retainable, discardable, true);
    }

    private static boolean deduplicateReduceTraits(ReduceSinkDesc retainable, ReduceSinkDesc discardable, boolean apply) {
        EnumSet<ReduceSinkDesc.ReducerTraits> retainableTraits = retainable.getReducerTraits();
        EnumSet<ReduceSinkDesc.ReducerTraits> discardableTraits = discardable.getReducerTraits();
        boolean x1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNSET);
        boolean f1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.FIXED);
        boolean u1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
        boolean a1 = retainableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
        int n1 = retainable.getNumReducers();
        boolean x2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNSET);
        boolean f2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.FIXED);
        boolean u2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
        boolean a2 = discardableTraits.contains((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
        int n2 = discardable.getNumReducers();
        boolean dedup = false;
        boolean x3 = false;
        boolean f3 = false;
        boolean u3 = false;
        boolean a3 = false;
        int n3 = n1;
        if (x1 || x2) {
            dedup = true;
            n3 = Math.max(n1, n2);
            x3 = x1 && x2;
            f3 = f1 || f2;
            u3 = u1 || u2;
            a3 = a1 || a2;
        } else if (f1 || f2) {
            if (f1 && f2) {
                if (n1 == n2) {
                    dedup = true;
                    f3 = true;
                }
            } else {
                dedup = true;
                f3 = true;
                n3 = f1 ? n1 : n2;
            }
        } else {
            if (u1 && u2) {
                dedup = true;
                u3 = true;
                n3 = Math.max(n1, n2);
            }
            if (a1 && a2) {
                dedup = true;
                a3 = true;
                n3 = Math.max(n1, n2);
            }
        }
        if (apply && dedup) {
            retainable.setNumReducers(n3);
            if (x3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.UNSET);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.UNSET);
            }
            if (f3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.FIXED);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.FIXED);
            }
            if (u3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.UNIFORM);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
            }
            if (a3) {
                retainableTraits.add(ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
            } else {
                retainableTraits.remove((Object)ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
            }
        }
        return dedup;
    }

    static class SharedWorkOptimizerCache {
        private final Map<Operator<?>, Set<Operator<?>>> operatorToWorkOperators = new IdentityHashMap();
        final Multimap<TableScanOperator, Operator<?>> tableScanToDPPSource = HashMultimap.create();
        private Set<Operator<?>> knownFilterOperators = new HashSet();

        SharedWorkOptimizerCache() {
        }

        void putIfWorkExists(Operator<?> opToAdd, Operator<?> existingOp) {
            Set<Operator<?>> group = this.operatorToWorkOperators.get(existingOp);
            if (group == null) {
                return;
            }
            group.add(opToAdd);
            this.operatorToWorkOperators.put(opToAdd, group);
        }

        public void addWorkGroup(Collection<Operator<?>> c) {
            Set group = Sets.newIdentityHashSet();
            group.addAll(c);
            for (Operator<?> op : c) {
                this.operatorToWorkOperators.put(op, group);
            }
        }

        public Set<Operator<?>> getWorkGroup(Operator<?> start) {
            Set<Operator<?>> set = this.operatorToWorkOperators.get(start);
            if (set == null) {
                return Collections.emptySet();
            }
            return set;
        }

        public Set<Set<Operator<?>>> getWorkGroups() {
            Set ret = Sets.newIdentityHashSet();
            ret.addAll(this.operatorToWorkOperators.values());
            return ret;
        }

        public boolean isKnownFilteringOperator(Operator<? extends OperatorDesc> op) {
            return this.knownFilterOperators.contains(op);
        }

        public void setKnownFilteringOperator(Operator<?> filterOp) {
            this.knownFilterOperators.add(filterOp);
        }

        void removeOp(Operator<?> opToRemove) {
            Set<Operator<?>> group = this.operatorToWorkOperators.get(opToRemove);
            if (group == null) {
                return;
            }
            group.remove(opToRemove);
            this.operatorToWorkOperators.remove(opToRemove);
        }

        void removeOpAndCombineWork(Operator<?> opToRemove, Operator<?> replacementOp) {
            Set<Operator<?>> group1 = this.operatorToWorkOperators.get(opToRemove);
            Set<Operator<?>> group2 = this.operatorToWorkOperators.get(replacementOp);
            group1.remove(opToRemove);
            this.operatorToWorkOperators.remove(opToRemove);
            if (group1.size() > group2.size()) {
                Set<Operator<?>> t = group2;
                group2 = group1;
                group1 = t;
            }
            group2.addAll(group1);
            for (Operator<?> o : group1) {
                this.operatorToWorkOperators.put(o, group2);
            }
        }

        public String toString() {
            return "SharedWorkOptimizerCache { \n" + this.operatorToWorkOperators.toString() + "\n };";
        }
    }

    public static enum Mode {
        SubtreeMerge,
        RemoveSemijoin,
        DPPUnion;

    }

    private static class SharedResult {
        final List<Operator<?>> retainableOps;
        final List<Operator<?>> discardableOps;
        final Set<Operator<?>> discardableInputOps;
        final long dataSize;
        final long maxDataSize;

        private SharedResult(Collection<Operator<?>> retainableOps, Collection<Operator<?>> discardableOps, Set<Operator<?>> discardableInputOps, long dataSize, long maxDataSize) {
            this.retainableOps = ImmutableList.copyOf(retainableOps);
            this.discardableOps = ImmutableList.copyOf(discardableOps);
            this.discardableInputOps = ImmutableSet.copyOf(discardableInputOps);
            this.dataSize = dataSize;
            this.maxDataSize = maxDataSize;
        }

        public String toString() {
            return "SharedResult { " + String.valueOf(this.retainableOps) + "; " + String.valueOf(this.discardableOps) + "; " + String.valueOf(this.discardableInputOps) + "};";
        }
    }

    static class DecomposedTs {
        private TableScanOperator ts;
        private ExprNodeDesc normalFilterExpr;
        private List<ExprNodeDesc> semijoinExprNodes = new ArrayList<ExprNodeDesc>();

        public DecomposedTs(TableScanOperator ts) throws UDFArgumentException {
            this.ts = ts;
            TableScanOperator retainableTsOp = ts;
            if (((TableScanDesc)retainableTsOp.getConf()).getFilterExpr() != null) {
                ArrayList<ExprNodeDesc> allExprNodesExceptSemijoin = new ArrayList<ExprNodeDesc>();
                SharedWorkOptimizer.splitExpressions(((TableScanDesc)retainableTsOp.getConf()).getFilterExpr(), allExprNodesExceptSemijoin, this.semijoinExprNodes);
                this.normalFilterExpr = ExprNodeDescUtils.conjunction(allExprNodesExceptSemijoin);
            }
        }

        public List<ExprNodeDesc> getSemiJoinFilter() {
            return this.semijoinExprNodes;
        }

        public void replaceTabAlias(String oldAlias, String newAlias) {
            ExprNodeDescUtils.replaceTabAlias(this.normalFilterExpr, oldAlias, newAlias);
            for (ExprNodeDesc expr : this.semijoinExprNodes) {
                ExprNodeDescUtils.replaceTabAlias(expr, oldAlias, newAlias);
            }
            List<Operator<OperatorDesc>> children = this.ts.getChildOperators();
            for (Operator<OperatorDesc> c : children) {
                c.replaceTabAlias(oldAlias, newAlias);
            }
        }

        public ExprNodeDesc getFullFilterExpr() throws UDFArgumentException {
            return ExprNodeDescUtils.conjunction(this.semijoinExprNodes, this.normalFilterExpr);
        }
    }

    static class TSComparator
    implements Comparator<TableScanOperator> {
        TSComparator() {
        }

        @Override
        public int compare(TableScanOperator o1, TableScanOperator o2) {
            int r = this.cmpFiltered(o1, o2);
            if (r != 0) {
                return r;
            }
            r = this.cmpDataSize(o1, o2);
            if (r != 0) {
                return r;
            }
            return o1.toString().compareTo(o2.toString());
        }

        private int cmpFiltered(TableScanOperator o1, TableScanOperator o2) {
            if (((TableScanDesc)o1.getConf()).getFilterExpr() == null ^ ((TableScanDesc)o2.getConf()).getFilterExpr() == null) {
                return ((TableScanDesc)o1.getConf()).getFilterExpr() == null ? -1 : 1;
            }
            return 0;
        }

        private int cmpDataSize(TableScanOperator o1, TableScanOperator o2) {
            long ds2;
            long ds1 = o1.getStatistics() == null ? -1L : o1.getStatistics().getDataSize();
            long l = ds2 = o2.getStatistics() == null ? -1L : o2.getStatistics().getDataSize();
            if (ds1 == ds2) {
                return 0;
            }
            if (ds1 < ds2) {
                return 1;
            }
            return -1;
        }
    }

    static class RelaxedVertexEdgePredicate
    implements OperatorGraph.OperatorEdgePredicate {
        private EnumSet<OperatorGraph.EdgeType> traverseableEdgeTypes;

        public RelaxedVertexEdgePredicate(EnumSet<OperatorGraph.EdgeType> nonTraverseableEdgeTypes) {
            this.traverseableEdgeTypes = nonTraverseableEdgeTypes;
        }

        @Override
        public boolean accept(Operator<?> s, Operator<?> t, OperatorGraph.OpEdge opEdge) {
            ReduceSinkOperator rs;
            if (!this.traverseableEdgeTypes.contains((Object)opEdge.getEdgeType())) {
                return true;
            }
            return s instanceof ReduceSinkOperator && !ParallelEdgeFixer.colMappingInverseKeys(rs = (ReduceSinkOperator)s).isPresent();
        }
    }
}

