/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteCteException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CommonTableExpressionSuggester;

@InterfaceAudience.Private
public final class CommonTableExpressionSuggesterFactory {
    private CommonTableExpressionSuggesterFactory() {
        throw new IllegalStateException("Must not instantiate");
    }

    public static CommonTableExpressionSuggester create(HiveConf configuration) {
        String suggestName = configuration.getVar(HiveConf.ConfVars.HIVE_CTE_SUGGESTER_CLASS);
        if (suggestName == null || suggestName.isEmpty()) {
            return (query, conf) -> Collections.emptyList();
        }
        try {
            Class<?> suggesterClass = Class.forName(suggestName);
            if (CommonTableExpressionSuggester.class.isAssignableFrom(suggesterClass)) {
                return (CommonTableExpressionSuggester)suggesterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalArgumentException(suggesterClass.getSimpleName() + " must implement " + CommonTableExpressionSuggester.class.getSimpleName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CalciteCteException("Failed to instantiate suggester from class: " + suggestName, e);
        }
    }
}

